/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.init;

import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.world.ForgeWorld;
import com.endertech.minecraft.mods.adfinders.Main;
import com.endertech.minecraft.mods.adfinders.finder.Definitions;
import com.endertech.minecraft.mods.adfinders.items.Finder;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public enum Finders implements IForgeEnum
{
    GEMS("gemDiamond", 6, 32, 2, TextFormatting.DARK_AQUA),
    METALS("ingotGold", 8, 48, 3, TextFormatting.GOLD),
    MINERALS("ingotIron", 7, 40, 4, TextFormatting.DARK_PURPLE);

    public final Finder instance;
    public final Definitions definitions;

    private Finders(String baseMaterial, int scanRange, int pingRange, int veinMinSize, TextFormatting textFormatting) {
        UnitConfig config = new UnitConfig(Main.instance.getConfig().getConfigDir(), ((Object)((Object)this)).getClass().getSimpleName(), this.func_176610_l());
        this.instance = new Finder(Main.instance, config, this.func_176610_l(), baseMaterial, scanRange, pingRange, veinMinSize, veinMinSize * 4, textFormatting);
        this.definitions = new Definitions(this.instance.getUnitCategory());
        config.save();
    }

    @SubscribeEvent
    public static void onMissingMappings(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            if (!mapping.key.func_110623_a().equals("chemicals_finder")) continue;
            mapping.remap((IForgeRegistryEntry)Finders.MINERALS.instance);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        World world = player.func_130014_f_();
        if (ForgeWorld.isServerSide((World)world) && player instanceof EntityPlayerMP) {
            for (Finders finder : Finders.values()) {
                Finder.SyncClientMsg message = new Finder.SyncClientMsg(finder);
                Main.instance.getConnection().sendToPlayer((IMessage)message, (EntityPlayerMP)player);
            }
        }
    }

    public String func_176610_l() {
        return this.getLowerCase(this.name());
    }
}

