/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.init;

import com.endertech.minecraft.forge.versions.ForgeJoiner;
import com.endertech.minecraft.forge.versions.GameVersions;
import com.endertech.minecraft.mods.adfinders.finder.Definitions;
import com.endertech.minecraft.mods.adfinders.finder.Ore;
import com.endertech.minecraft.mods.adfinders.init.Finders;

public class Targets {
    static void initSubstratum() {
        String modId = "substratum";
        String regName = "ore";
        String oreDust = ForgeJoiner.withRegNameDelimiters((String[])new String[]{"ore", "dust"}).oreDictFormatFor(GameVersions.V10).toString();
        Finders.METALS.definitions.forMod(modId).addOres(regName, 0, Ore.Metals.COPPER.colored(-3648247), Ore.Metals.TIN.colored(-4470838), Ore.Metals.NICKEL.colored(-6251129), Ore.Metals.ZINC.colored(-10185235), Ore.Metals.SILVER.colored(-1644806), Ore.Metals.LEAD.colored(-12634036)).addOre(regName, 6, Ore.Metals.PLATINUM.colored(-3746586)).addOre(regName, 7, Ore.Metals.ALUMINUM.colored(-5857609)).addOre(regName, 8, Ore.Metals.CHROME.colored(-11579547));
        Finders.MINERALS.definitions.forMod(modId).addOre(oreDust, Ore.Minerals.SULFUR.colored(-256)).addOre(oreDust, 1, Ore.Minerals.NITER.colored(-2176305));
    }

    static void initMysticalAgriculture() {
        String modId = "mysticalagriculture";
        String[] prefixes = new String[]{"", "nether", "end"};
        Finders.METALS.definitions.forMod(modId).withPrefixes(prefixes).withOreSuffix().addOre(new Ore("inferium", -8809216));
        Finders.MINERALS.definitions.forMod(modId).withPrefixes(prefixes).withOreSuffix().addOre(new Ore("prosperity", -3343622));
    }

    static void initLightningCraft() {
        String modId = "lightningcraft";
        String regName = ForgeJoiner.withRegNameDelimiters((String[])new String[]{"ore", "block"}).oreDictFormatFor(GameVersions.V10).setFor(GameVersions.V7, new String[]{"tile.underworldOre"}).toString();
        Finders.METALS.definitions.forMod(modId).addOres(regName, 0, Ore.Metals.IRON.colored(-2180985), Ore.Metals.GOLD.colored(-10496));
        Finders.GEMS.definitions.forMod(modId).addOres(regName, 2, Ore.Gems.DIAMOND.colored(-11866671), Ore.Gems.EMERALD.colored(-16732104));
    }

    static void initFuturePack() {
        String modId = "fp";
        String regName = "erze";
        Finders.GEMS.definitions.forMod(modId).addOre(regName, 5, Ore.Gems.QUARTZ.colored(-790298));
        Finders.METALS.definitions.forMod(modId).addOres(regName, 0, Ore.Metals.TIN.colored(-4470838), Ore.Metals.ZINC.colored(-10185235), Ore.Metals.COPPER.colored(-3648247), Ore.Metals.BAUXITE.colored(-6608128), Ore.Metals.MAGNETITE.colored(-7766194)).addOre(regName, 6, Ore.Metals.COPPER.colored(-3648247));
        Finders.MINERALS.definitions.forMod(modId).addOre(regName, 7, Ore.COAL);
    }

    static void initEbonArts() {
        String modId = "ea";
        String orePrefix = new ForgeJoiner(new String[]{"ore/"}).setFor(GameVersions.V7, new String[]{"ores/"}).toString();
        String oreSuffix = "_ore";
        Ore ebon = Ore.from("ebon", 0);
        String[] oreSuffixes = new String[]{oreSuffix, oreSuffix + "_nether", oreSuffix + "_end"};
        Finders.GEMS.definitions.forMod(modId).withNoDelimiters().withPrefixes(orePrefix).withSuffixes(oreSuffix).addOre(new Ore("arcanite", -15880549)).addOre(new Ore("katcheen", -65536)).addOre(new Ore("velious", -14084504)).withSuffixes(oreSuffixes).addOre(new Ore("necrocite", -12062720)).addOre(new Ore("soularite", -674045)).addOre(new Ore("ebonheart", -9704983)).addOre(ebon.colored(-16776961));
        Finders.METALS.definitions.forMod(modId).withNoDelimiters().withPrefixes(orePrefix).withSuffixes(oreSuffixes).addOre(ebon.colored(-10496));
        Finders.MINERALS.definitions.forMod(modId).withNoDelimiters().withPrefixes(orePrefix).withSuffixes(oreSuffix).addOre(new Ore("draconium", -348422)).withSuffixes(oreSuffixes).addOre(ebon.colored(-65536));
    }

    static void initForestry() {
        String modId = new ForgeJoiner(new String[]{"forestry"}).capitalizeWordsFor(GameVersions.V7).toString();
        String regName = "resources";
        Finders.METALS.definitions.forMod(modId).addOres(regName, 1, Ore.Metals.COPPER.colored(-3891413), Ore.Metals.TIN.colored(-2171950));
        Finders.GEMS.definitions.forMod(modId).addOre(regName, Ore.Gems.APATITE.colored(-14251319));
    }

    static void initActuallyAdditions() {
        String modId = new ForgeJoiner(new String[]{"actually", "additions"}).capitalizeWordsFor(GameVersions.V7).toString();
        String regName = ForgeJoiner.withRegNameDelimiters((String[])new String[]{"block", "misc"}).oreDictFormatFor(GameVersions.V10).oreDictFormatFor(GameVersions.V7).toString();
        Finders.GEMS.definitions.forMod(modId).addOres(regName, 3, Ore.Gems.QUARTZ.colored(-15132391));
    }

    static void initAbyssalCraft() {
        String modId = "abyssalcraft";
        String prefix = "aby";
        String coralium = "coralium";
        Ore oreCoralium = new Ore(coralium, -15832460);
        Ore oreAbyssalnite = new Ore("abyssalnite", -11199579);
        Finders.GEMS.definitions.forMod(modId).withNoDelimiters().addOre(coralium + "stone", oreCoralium.colored(-10706518)).withOreSuffix().addOre(coralium, oreCoralium).withPrefixes(prefix).addOre("dia", Ore.Gems.DIAMOND.colored(-11866671)).addOre("cor", oreCoralium).addOre("pcor", oreCoralium.colored(-10706518));
        Finders.METALS.definitions.forMod(modId).withNoDelimiters().withOreSuffix().addOre("dread", oreAbyssalnite.colored(-11730397)).withPrefixes(prefix).addOre("lcor", oreCoralium.colored(-15883118)).addOre("", oreAbyssalnite).addOre("dread", oreAbyssalnite).addOre("iro", Ore.Metals.IRON.colored(-2180985)).addOre("gol", Ore.Metals.GOLD.colored(-10496)).addOre("tin", Ore.Metals.TIN.colored(-4470838)).addOre("cop", Ore.Metals.COPPER.colored(-3648247));
        Finders.MINERALS.definitions.forMod(modId).withNoDelimiters().withOreSuffix().addOre("nitre", Ore.Minerals.NITER.colored(-10794187)).withPrefixes(prefix).addOre("nit", Ore.Minerals.NITER.colored(-10794187));
    }

    static void initVanilla() {
        String modId = "minecraft";
        Finders.GEMS.definitions.forMod(modId).withOreSuffix().addOres(Ore.Gems.DIAMOND.colored(-11866671), Ore.Gems.EMERALD.colored(-16732104), Ore.Gems.LAPIS.colored(-16776961), Ore.Gems.QUARTZ.colored(-790298));
        Finders.METALS.definitions.forMod(modId).withOreSuffix().addOres(Ore.Metals.IRON.colored(-2180985), Ore.Metals.GOLD.colored(-10496));
        Finders.MINERALS.definitions.forMod(modId).withOreSuffix().addOres(Ore.COAL, Ore.Minerals.REDSTONE.colored(-65536)).addOre("lit_redstone", Ore.Minerals.REDSTONE.colored(-65536));
    }

    static void initAdOver() {
        String modId = "adover";
        Finders.GEMS.definitions.forMod(modId).withOreSuffix().addOres(Ore.Gems.DIAMOND.colored(-11866671), Ore.Gems.EMERALD.colored(-16732104), Ore.Gems.RUBY.colored(-1048576), Ore.Gems.SAPPHIRE.colored(-12763749), Ore.Gems.TOPAZ.colored(-23800));
        Finders.METALS.definitions.forMod(modId).withOreSuffix().addOre(Ore.Metals.IRON.colored(-2180985)).addOre(Ore.Metals.SILVER.colored(-1644806)).addOre(Ore.Metals.GOLD.colored(-10496)).addOre(Ore.Metals.OSMIUM.colored(-10185235)).addOre(Ore.Metals.TITANIUM.colored(-7114533)).addOre(Ore.Metals.ADAMANTIUM.colored(-4565549)).addOre(Ore.Metals.URANIUM.colored(-16711936));
        Finders.MINERALS.definitions.forMod(modId).withOreSuffix().addOres(Ore.COAL, Ore.Minerals.REDSTONE.colored(-65536), Ore.Minerals.SULFUR.colored(-256));
    }

    static void initBiomesOplenty() {
        String modId = new ForgeJoiner(new String[]{"biomes", "o", "plenty"}).capitalizeWordsFor(GameVersions.V7).toString();
        String biomeBlock = ForgeJoiner.withRegNameDelimiters((String[])new String[]{"biome", "block"}).oreDictFormatFor(GameVersions.V7).toString();
        String gemOre = ForgeJoiner.withRegNameDelimiters((String[])new String[]{"gem", "ore"}).oreDictFormatFor(GameVersions.V7).toString();
        boolean isV7 = GameVersions.V7.isRunning();
        int metaStep = isV7 ? 2 : 1;
        Finders.GEMS.definitions.forMod(modId).addOres(gemOre, 0, metaStep, Ore.Gems.AMETHYST.colored(-4838200), Ore.Gems.RUBY.colored(-1048576), Ore.Gems.PERIDOT.colored(-9927378), Ore.Gems.TOPAZ.colored(-23800), Ore.Gems.TANZANITE.colored(-11650921), Ore.Gems.MALACHITE.colored(-15368347)).addOre(gemOre, 6 * metaStep, Ore.Gems.SAPPHIRE.colored(-15040557)).addOre(gemOre, 7 * metaStep, Ore.Gems.AMBER.colored(-4351965));
        Finders.MINERALS.definitions.forMod(modId).addOre(biomeBlock, new Ore("biome_essense", -1));
    }

    static void initUndergroundBiomes() {
        String modId = new ForgeJoiner(new String[]{"underground", "biomes"}).capitalizeWordsFor(GameVersions.V7).toString();
        String igneous = "igneous";
        String metamorphic = "metamorphic";
        String sedimentary = "sedimentary";
        String ore = new ForgeJoiner(new String[]{"stone"}).setFor(GameVersions.V7, new String[]{"ore"}).toString();
        String[] prefixes = Definitions.Prefixes.create().add(igneous, ore).add(metamorphic, ore).add(sedimentary, ore).toArray();
        String delimiter = ForgeJoiner.Delimiter.regName().setNoneFor(GameVersions.V7).toString();
        String suffix = new ForgeJoiner(new String[]{"ore"}).setFor(GameVersions.V7, new String[]{""}).toString();
        boolean capitalized = GameVersions.getCurrent() == GameVersions.V7;
        int meta = Short.MAX_VALUE;
        Finders.GEMS.definitions.forMod(modId).withPrefixes(prefixes).withDelimiter(delimiter).withSuffixes(suffix).addOre(capitalized, meta, Ore.Gems.DIAMOND.colored(-11866671)).addOre(capitalized, meta, Ore.Gems.EMERALD.colored(-16732104)).addOre(capitalized, meta, Ore.Gems.LAPIS.colored(-16776961));
        Finders.METALS.definitions.forMod(modId).withPrefixes(prefixes).withDelimiter(delimiter).withSuffixes(suffix).addOre(capitalized, meta, Ore.Metals.GOLD.colored(-10496)).addOre(capitalized, meta, Ore.Metals.IRON.colored(-2180985));
        Finders.MINERALS.definitions.forMod(modId).withPrefixes(prefixes).withDelimiter(delimiter).withSuffixes(suffix).addOre(capitalized, meta, Ore.COAL).addOre(capitalized, meta, Ore.Minerals.REDSTONE.colored(-65536));
    }

    static void initFunOres() {
        String modId = new ForgeJoiner(new String[]{"fun", "ores"}).capitalizeWordsFor(GameVersions.V7).toString();
        String regName = new ForgeJoiner(new String[]{"metal", "ore"}).capitalizeWordsFor(GameVersions.V7).toString();
        Finders.METALS.definitions.forMod(modId).addOres(regName, 0, Ore.Metals.COPPER.colored(-3648247), Ore.Metals.TIN.colored(-5790578), Ore.Metals.SILVER.colored(-1644806), Ore.Metals.LEAD.colored(-12634036), Ore.Metals.NICKEL.colored(-4491143), Ore.Metals.PLATINUM.colored(-14584920), Ore.Metals.ALUMINUM.colored(-5746611), Ore.Metals.ZINC.colored(-10185235), Ore.Metals.TITANIUM.colored(-7114533), Ore.Metals.OSMIUM.colored(-10185235));
    }

    static void initThermalFoundation() {
        String modId = new ForgeJoiner(new String[]{"thermal", "foundation"}).capitalizeWordsFor(GameVersions.V7).toString();
        String regName = new ForgeJoiner(new String[]{"ore"}).capitalizeWordsFor(GameVersions.V7).toString();
        Finders.METALS.definitions.forMod(modId).addOres(regName, 0, Ore.Metals.COPPER.colored(-1155059), Ore.Metals.TIN.colored(-7097131), Ore.Metals.SILVER.colored(-1644806).colored(-2231562), Ore.Metals.LEAD.colored(-7758115));
        if (GameVersions.V7.isRunning()) {
            Finders.METALS.definitions.addOres(regName, 4, new Ore("ferrous", -5002367), new Ore("shiny", -16744223), Ore.Metals.MYTHRIL.colored(-13004052));
        } else {
            Finders.METALS.definitions.addOres(regName, 4, Ore.Metals.ALUMINUM.colored(-5746611), Ore.Metals.NICKEL.colored(-6251129), Ore.Metals.PLATINUM.colored(-14584920), Ore.Metals.IRIDIUM.colored(-8356210), Ore.Metals.MYTHRIL.colored(-13004052));
        }
    }

    static void initDraconicEvolution() {
        String modId = new ForgeJoiner(new String[]{"draconic", "evolution"}).capitalizeWordsFor(GameVersions.V7).toString();
        String ore = new ForgeJoiner(new String[]{"ore"}).capitalizeWordsFor(GameVersions.V7).toString();
        Ore oreDraconium = new Ore("draconium", -10536575);
        String delimiter = ForgeJoiner.Delimiter.regName().setForOlderThan(GameVersions.V12, "").toString();
        Finders.METALS.definitions.forMod(modId).withDelimiter(delimiter).withSuffixes(ore).addOres(oreDraconium.getName(), 0, oreDraconium, oreDraconium, oreDraconium);
    }

    static void initImmersiveEngineering() {
        String modId = new ForgeJoiner(new String[]{"immersive", "engineering"}).capitalizeWordsFor(GameVersions.V7).toString();
        String ore = "ore";
        Finders.METALS.definitions.forMod(modId).addOres(ore, 0, Ore.Metals.COPPER.colored(-11371417), Ore.Metals.BAUXITE.colored(-9818329), Ore.Metals.LEAD.colored(-12634036), Ore.Metals.SILVER.colored(-1644806), Ore.Metals.NICKEL.colored(-6251129), Ore.Metals.URANIUM.colored(-11243448));
    }

    static void initRailcraft() {
        String modId = new ForgeJoiner(new String[]{"railcraft"}).capitalizeWordsFor(GameVersions.V7).toString();
        String regName = "ore";
        Ore oreCopper = Ore.Metals.COPPER.colored(-8139376);
        Ore oreTin = Ore.Metals.TIN.colored(-723724);
        Ore oreLead = Ore.Metals.LEAD.colored(-8816470);
        Ore oreSilver = Ore.Metals.SILVER.colored(-2699066);
        Finders.GEMS.definitions.forMod(modId).addOres(regName, 2, Ore.Gems.DIAMOND.colored(-11866671), Ore.Gems.EMERALD.colored(-16732104), Ore.Gems.LAPIS.colored(-16776961));
        if (GameVersions.V7.isRunning()) {
            Finders.GEMS.definitions.addOre(regName, 5, new Ore("firestone", -2659815));
            Finders.METALS.definitions.forMod(modId).addOres(regName, 7, Ore.Metals.IRON.colored(-2180985), Ore.Metals.GOLD.colored(-10496), oreCopper, oreTin, oreLead);
        } else {
            Finders.GEMS.definitions.addOre("ore_magic", new Ore("firestone", -2659815));
            Finders.METALS.definitions.forMod(modId).addOres(regName, 5, Ore.Metals.IRON.colored(-2180985), Ore.Metals.GOLD.colored(-10496), oreCopper, oreTin, oreLead, oreSilver, oreCopper, oreTin, oreLead, oreSilver);
        }
        Finders.MINERALS.definitions.forMod(modId).addOre(regName, Ore.Minerals.SULFUR.colored(-256)).addOre(regName, 1, Ore.Minerals.SALTPETER.colored(-2171170));
    }

    static void initWaterPower() {
        String modId = new ForgeJoiner(new String[]{"water", "power"}).capitalizeWordsFor(GameVersions.V7).toString();
        String ore = new ForgeJoiner(new String[]{"ore"}).setFor(GameVersions.V7, new String[]{"cptBlockOre"}).toString();
        Finders.METALS.definitions.forMod(modId).addOres(ore, 0, new Ore("monazite", -5986157), new Ore("vanadium", -7760738), new Ore("manganeze", -11969947), new Ore("magnet", -14145495), Ore.Metals.ZINC.colored(-6704456));
    }

    static void initQuark() {
        Finders.GEMS.definitions.forMod("quark").withOreSuffix().addOre(new Ore("biotite", -15132391));
    }

    static void initTinkersConstruct() {
        String modId = new ForgeJoiner(new String[]{"t", "construct"}).capitalizeWordsFor(GameVersions.V7).toString();
        if (GameVersions.V7.isRunning()) {
            String gravelOre = "GravelOre";
            String searedBrick = "SearedBrick";
            Finders.METALS.definitions.forMod(modId).addOres(gravelOre, 0, Ore.Metals.IRON.colored(-2180985), Ore.Metals.GOLD.colored(-10496), Ore.Metals.COPPER.colored(-3648247), Ore.Metals.TIN.colored(-8634854), Ore.Metals.ALUMINUM.colored(-263173), Ore.Metals.COBALT.colored(-14593883)).addOres(searedBrick, 1, Ore.Metals.COBALT.colored(-14593883), Ore.Metals.ARDITE.colored(-9477861), Ore.Metals.COPPER.colored(-3648247), Ore.Metals.TIN.colored(-8634854), Ore.Metals.ALUMINUM.colored(-263173));
        } else {
            String ore = "ore";
            Finders.METALS.definitions.forMod(modId).addOre("ore", Ore.Metals.COBALT.colored(-14593883)).addOre(ore, 1, Ore.Metals.ARDITE.colored(-9477861));
        }
    }

    static void initTechReborn() {
        String modId = "techreborn";
        String ore = "ore";
        String ore2 = ore + "2";
        Finders.GEMS.definitions.forMod(modId).addOres(ore, 2, Ore.Gems.RUBY.colored(-613443), Ore.Gems.SAPPHIRE.colored(-10841678)).addOre(ore, 5, Ore.Gems.PYRITE.colored(-1203168)).addOre(ore, 10, Ore.Gems.PERIDOT.colored(-16145351)).addOre(ore, 11, Ore.Gems.SODALITE.colored(-10386519));
        Finders.METALS.definitions.forMod(modId).addOres(ore, 0, Ore.Metals.GALENA.colored(-14807246), Ore.Metals.IRIDIUM.colored(-14669276)).addOre(ore, 4, Ore.Metals.BAUXITE.colored(-3113118)).addOres(ore, 6, Ore.Metals.CINNABAR.colored(-4718592), Ore.Metals.SPHALERITE.colored(-6114942), Ore.Metals.TUNGSTEN.colored(-15329770), Ore.Metals.SHELDONITE.colored(-10910324)).addOres(ore, 12, Ore.Metals.LEAD.colored(-14478280), Ore.Metals.SILVER.colored(-1644806)).addOres(ore2, 0, Ore.Metals.COPPER.colored(-9795460), Ore.Metals.TIN.colored(-4470838), Ore.Metals.GARNIERITE.colored(-7487928));
    }

    static void initAdInferos() {
        String modId = new ForgeJoiner(new String[]{"adinferos"}).setFor(GameVersions.V7, new String[]{"dextersnether"}).toString();
        Ore oreWither = new Ore("wither", -16777216);
        Ore oreNetherite = new Ore("netherite", -10518914);
        Ore oreDimensional = new Ore("dimensional", -12438925);
        if (GameVersions.V7.isRunning()) {
            String ore = "ore";
            String oreDarkStone = "ore_darkstone";
            Finders.GEMS.definitions.forMod(modId).withSuffixes(ore, oreDarkStone).addOre(oreWither);
            Finders.METALS.definitions.forMod(modId).withSuffixes(ore, oreDarkStone).addOre(oreNetherite).withSuffixes("ore_nether").addOre(Ore.Metals.GOLD.colored(-10496));
            Finders.MINERALS.definitions.forMod(modId).withSuffixes(ore).addOre(oreDimensional);
        } else {
            Finders.GEMS.definitions.forMod(modId).withOreSuffix().addOres(oreWither.getName(), 0, oreWither, oreWither);
            Finders.METALS.definitions.forMod(modId).withOreSuffix().addOre(Ore.Metals.GOLD.colored(-10496)).addOres(oreNetherite.getName(), 0, oreNetherite, oreNetherite);
            Finders.MINERALS.definitions.forMod(modId).addOre(new Ore("dimstone", -15000805)).withOreSuffix().addOre(new Ore("soul", -4804694)).addOre(oreDimensional).addOre(new Ore("peat", -9029631));
        }
    }

    static void initAstralSorcery() {
        String modId = "astralsorcery";
        String ore = new ForgeJoiner(new String[]{"block", "custom", "ore"}).capitalizeWordsFor(GameVersions.V10).capitalizeWordsFor(GameVersions.V7).toString();
        String sandOre = new ForgeJoiner(new String[]{"block", "custom", "sand", "ore"}).capitalizeWordsFor(GameVersions.V10).capitalizeWordsFor(GameVersions.V7).toString();
        Finders.GEMS.definitions.forMod(modId).addOre(sandOre, new Ore("aquamarine", -14251544)).addOre(ore, new Ore("crystal_rock", -1));
        Finders.METALS.definitions.forMod(modId).addOre(ore, 1, new Ore("starmetal", -16770200));
    }

    static void initEmbers() {
        String modId = "embers";
        Finders.METALS.definitions.forMod(modId).withOrePrefix().addOre(Ore.Metals.COPPER.colored(-3648247)).addOre(Ore.Metals.LEAD.colored(-12634036)).addOre(Ore.Metals.SILVER.colored(-4665644));
        Finders.GEMS.definitions.forMod(modId).withOrePrefix().addOre(Ore.Gems.QUARTZ.colored(-790298));
    }

    static void initEvilCraft() {
        String name = ForgeJoiner.withRegNameDelimiters((String[])new String[]{"dark", "ore"}).oreDictFormatFor(GameVersions.V10).oreDictFormatFor(GameVersions.V7).toString();
        Ore oreDark = new Ore(name, -16777216);
        Finders.GEMS.definitions.forMod("evilcraft").addOres(name, 0, oreDark, oreDark);
    }

    static void initLotOfThings() {
        String modId = new ForgeJoiner(new String[]{"l", "o", "t"}).capitalizeWordsFor(GameVersions.V7).toString();
        Finders.GEMS.definitions.forMod(modId).withOreSuffix().addOre(Ore.Gems.RUBY.colored(-1048576));
        Finders.METALS.definitions.forMod(modId).withOreSuffix().addOre(Ore.Metals.COPPER.colored(-3648247));
    }

    static void initNuclearCraft() {
        String modId = new ForgeJoiner(new String[]{"nuclear", "craft"}).capitalizeWordsFor(GameVersions.V7).toString();
        String regName = new ForgeJoiner(new String[]{"ore"}).setFor(GameVersions.V7, new String[]{"blockOre"}).toString();
        boolean isV7 = GameVersions.V7.isRunning();
        Finders.METALS.definitions.forMod(modId).addOres(regName, 0, Ore.Metals.COPPER.colored(-9742266), Ore.Metals.TIN.colored(-4276534), Ore.Metals.LEAD.colored(-10984865)).addOre(regName, isV7 ? 5 : 3, new Ore("thorium", -11119274)).addOre(regName, 4, Ore.Metals.URANIUM.colored(-12889818)).addOre(regName, isV7 ? 8 : 5, new Ore("boron", -12566464)).addOre(regName, isV7 ? 7 : 6, new Ore("lithium", -3355444)).addOre(regName, isV7 ? 9 : 7, new Ore("magnesium", -2569518));
        if (isV7) {
            Finders.METALS.definitions.addOre(regName, 3, Ore.Metals.SILVER.colored(-1644806)).addOre(regName, 6, new Ore("plutonium", -9408380));
        }
    }

    static void initExtremeReactors() {
        String modId = "bigreactors";
        String regName = "brore";
        Finders.GEMS.definitions.forMod(modId).addOres(regName, 1, new Ore("anglesite", -752640), new Ore("benitoite", -15796511));
        Finders.METALS.definitions.forMod(modId).addOre(Ore.Metals.YELLORITE.colored(-724736));
    }

    static void initTAIGA() {
        String modId = "taiga";
        Finders.METALS.definitions.forMod(modId).withOreSuffix().addOre("lignite", -12963543).addOre("slagiron", Ore.Metals.IRON.colored(-2180985)).addOre("slaggold", Ore.Metals.GOLD.colored(-10496)).addOre("titanite", -3109201).addOre("meteorite", -12106697).addOre("vibranium", -6048081).addOre("adamantite", -6077499).addOre("prometheum", -15988462).addOre("rubium", -6080716).addOre("tiberium", -13990609).addOre("arcanite", -13354621).addOre("eternite", -2042829).addOre("mythril", -9007994).addOre("palladium", -445435).addOre("ignitite", -3239599).addOre("violium", -9925747).addOre("bismuth", -7315582).addOre("mindorite", -15550789).addOre("karmesine", -6598576);
    }

    static void initArsMagica2() {
        String modId = "arsmagica2";
        String regName = new ForgeJoiner(new String[]{"ore"}).setFor(GameVersions.V7, new String[]{"vinteumOre"}).toString();
        Finders.GEMS.definitions.forMod(modId).addOres(regName, 1, new Ore("chimerite", -2251313), new Ore("bluetopaz", -11430465), new Ore("moonstone", -6042400), new Ore("sunstone", -5028302));
        Finders.MINERALS.definitions.forMod(modId).addOre(regName, new Ore("vinteum", -13743909));
    }

    static void initDeepResonance() {
        String modId = "deepresonance";
        String name = ForgeJoiner.withRegNameDelimiters((String[])new String[]{"resonating", "ore"}).reverseWordsOrderFor(GameVersions.V7).oreDictFormatFor(GameVersions.V7).toString();
        Ore ore = new Ore(name, -695967);
        Finders.GEMS.definitions.forMod(modId).addOres(name, 0, ore, ore, ore);
    }

    static void initSimpleOres() {
        String modId = "simpleores";
        Finders.GEMS.definitions.forMod(modId).withOreSuffix().addOre("onyx", -15132391);
        Finders.METALS.definitions.forMod(modId).withOreSuffix().addOres(Ore.Metals.COPPER.colored(-3648247), Ore.Metals.TIN.colored(-4470838), Ore.Metals.MYTHRIL.colored(-13004052), Ore.Metals.ADAMANTIUM.colored(-16745727));
    }

    static void initIndustrialCraft2() {
        String modId = new ForgeJoiner(new String[]{"i", "c", "2"}).capitalizeWordsFor(GameVersions.V7).toString();
        if (GameVersions.V7.isRunning()) {
            Finders.METALS.definitions.forMod(modId).withNoDelimiters().withPrefixes("blockOre").addOre(true, 0, Ore.Metals.COPPER.colored(-3648247)).addOre(true, 0, Ore.Metals.LEAD.colored(-8548715)).addOre(true, 0, Ore.Metals.TIN.colored(-4470838)).addOre("Uran", Ore.Metals.URANIUM.colored(-9318638));
        } else {
            String regName = "resource";
            Finders.METALS.definitions.forMod(modId).addOres(regName, 1, Ore.Metals.COPPER.colored(-3648247), Ore.Metals.LEAD.colored(-8548715), Ore.Metals.TIN.colored(-4470838), Ore.Metals.URANIUM.colored(-9318638));
        }
    }

    static void initTerraqueous() {
        String regName = "earth_ore";
        Finders.GEMS.definitions.forMod("terraqueous").addOres(regName, 0, new Ore("endimium", -14838924), new Ore("burnium", -2852330));
    }

    static void initRFTools() {
        String regName = new ForgeJoiner(new String[]{"dimensional_shard_ore"}).setFor(GameVersions.V7, new String[]{"dimensionalShardBlock"}).toString();
        Finders.GEMS.definitions.forMod("rftools").addOre(regName, new Ore("dimensional_shard", -6489351));
    }

    static void initAppliedEnergistics2() {
        String modId = "appliedenergistics2";
        String quartz = new ForgeJoiner(new String[]{Ore.Gems.QUARTZ.func_176610_l()}).capitalizeWordsFor(GameVersions.V7).toString();
        String charged = new ForgeJoiner(new String[]{"charged"}).capitalizeWordsFor(GameVersions.V7).toString();
        int color = -6963731;
        if (GameVersions.V7.isRunning()) {
            Finders.GEMS.definitions.forMod(modId).withNoDelimiters().withPrefixes("tile.Ore").withSuffixes("", charged).addOre(quartz, Ore.Gems.QUARTZ.colored(color));
        } else {
            Finders.GEMS.definitions.forMod(modId).withPrefixes(charged, "").withOreSuffix().addOre(quartz, color);
        }
    }

    static void initQuantumFlux() {
        String modId = "quantumflux";
        String regName = ForgeJoiner.withRegNameDelimiters((String[])new String[]{"graphite", "ore"}).oreDictFormatFor(GameVersions.V10).toString();
        Finders.MINERALS.definitions.forMod(modId).addOre(regName, new Ore("graphite", -15132391));
        if (GameVersions.V7.isRunning()) {
            Finders.METALS.definitions.forMod(modId).addOre("titaniumOre", Ore.Metals.TITANIUM.colored(-16747837));
        }
    }

    static void initProjectRed() {
        String modId = new ForgeJoiner(new String[]{"projectred-exploration"}).setFor(GameVersions.V7, new String[]{"ProjRed|Exploration"}).toString();
        String regName = new ForgeJoiner(new String[]{"ore"}).setFor(GameVersions.V7, new String[]{"projectred.exploration.ore"}).toString();
        Finders.GEMS.definitions.forMod(modId).addOres(regName, 0, Ore.Gems.RUBY.colored(-8249569), Ore.Gems.SAPPHIRE.colored(-13485924), Ore.Gems.PERIDOT.colored(-10640568));
        Finders.METALS.definitions.forMod(modId).addOres(regName, 3, Ore.Metals.COPPER.colored(-2651850), Ore.Metals.TIN.colored(-1710619), Ore.Metals.SILVER.colored(-6375727));
        Finders.MINERALS.definitions.forMod(modId).addOre(regName, 6, new Ore("electrotin", -15768403));
    }

    static void initPracticalLogistics2() {
        String modId = new ForgeJoiner(new String[]{"practicallogistics2"}).setFor(GameVersions.V7, new String[]{"PracticalLogistics"}).toString();
        ForgeJoiner.Delimiter delimiter = ForgeJoiner.Delimiter.regName().setNoneFor(GameVersions.V7);
        String regName = new ForgeJoiner(delimiter, new String[]{"sapphire", "ore"}).capitalizeWordsFor(GameVersions.V10).capitalizeWordsFor(GameVersions.V7).toString();
        Finders.GEMS.definitions.forMod(modId).addOre(regName, Ore.Gems.SAPPHIRE.colored(-15708569));
    }

    static void initMekanism() {
        String modId = new ForgeJoiner(new String[]{"mekanism"}).capitalizeWordsFor(GameVersions.V7).toString();
        ForgeJoiner.Delimiter delimiter = ForgeJoiner.Delimiter.regName().setNoneFor(GameVersions.V7).setNoneFor(GameVersions.V12);
        String ore = new ForgeJoiner(delimiter, new String[]{"ore", "block"}).capitalizeWordsFor(GameVersions.V10).capitalizeWordsFor(GameVersions.V7).toString();
        Finders.METALS.definitions.forMod(modId).addOres(ore, 0, Ore.Metals.OSMIUM.colored(-10185235), Ore.Metals.COPPER.colored(-3648247), Ore.Metals.TIN.colored(-4470838));
    }

    static void initGeoActivity() {
        String prefix = new ForgeJoiner(new String[]{""}).setFor(GameVersions.V7, new String[]{"geoactivitytile."}).toString();
        Finders.MINERALS.definitions.forMod("geoactivity").withNoDelimiters().withPrefixes(prefix).withOreSuffix().addOre("lignite", -7119360).addOre("bituminous", -568064).addOre("anthracite", -3604480);
    }

    static void initSaltyMod() {
        String salt = Ore.Minerals.SALT.func_176610_l();
        String modId = new ForgeJoiner(new String[]{salt, "mod"}).capitalizeWordsFor(GameVersions.V7).toString();
        String ore = ForgeJoiner.withRegNameDelimiters((String[])new String[]{salt, "ore"}).oreDictFormatFor(GameVersions.V10).oreDictFormatFor(GameVersions.V7).toString();
        String lake = ForgeJoiner.withRegNameDelimiters((String[])new String[]{salt, "lake"}).oreDictFormatFor(GameVersions.V10).oreDictFormatFor(GameVersions.V7).toString();
        Ore oreSalt = new Ore(salt, -5323338);
        Finders.MINERALS.definitions.forMod(modId).addOre(ore, oreSalt).addOre(lake, oreSalt);
    }

    static void initTheBetweenlands() {
        String modId = "thebetweenlands";
        ForgeJoiner.Delimiter delimiter = ForgeJoiner.Delimiter.regName().setNoneFor(GameVersions.V7);
        String middleGemOre = new ForgeJoiner(delimiter, new String[]{"middle", "gem", "ore"}).capitalizeWordsFor(GameVersions.V7).toString();
        String ore = new ForgeJoiner(new String[]{"ore"}).capitalizeWordsFor(GameVersions.V7).toString();
        String lifeCrystal = ForgeJoiner.withRegNameDelimiters((String[])new String[]{"life", "crystal"}).oreDictFormatFor(GameVersions.V7).toString();
        String slimyBone = ForgeJoiner.withRegNameDelimiters((String[])new String[]{"slimy", "bone"}).setFor(GameVersions.V7, new String[]{"bone"}).toString();
        Finders.GEMS.definitions.forMod(modId).withDelimiter(delimiter.toString()).withSuffixes(ore).addOre(lifeCrystal, -1385504).addOre("valonite", -6257760).addOre("scabyst", -13009552).withSuffixes(middleGemOre).addOre("aqua", -16645382).addOre("crimson", -1769472).addOre("green", -16730624);
        Finders.METALS.definitions.forMod(modId).withDelimiter(delimiter.toString()).withSuffixes(ore).addOre("octine", -365568).addOre("syrmorite", -11445076);
        Finders.MINERALS.definitions.forMod(modId).withDelimiter(delimiter.toString()).withSuffixes(ore).addOre("sulfur", -789760).addOre(slimyBone, -16680447);
    }

    static void initAether2() {
        String modId = "aether";
        String delimiter = ForgeJoiner.Delimiter.regName().setNoneFor(GameVersions.V7).toString();
        String ore = new ForgeJoiner(new String[]{"ore"}).capitalizeWordsFor(GameVersions.V7).toString();
        Finders.GEMS.definitions.forMod(modId).withDelimiter(delimiter).withSuffixes(ore).addOre("ambrosium", -2175115).addOre("zanite", -12638088).addOre("icestone", -7822107).addOre("continuum", -2134737);
        Finders.METALS.definitions.forMod(modId).withDelimiter(delimiter).withSuffixes(ore).addOre("gravitite", -6665853).addOre("arkenium", -15132391);
    }

    static void initThaumcraft() {
        String modId = "thaumcraft";
        Finders.GEMS.definitions.forMod(modId).withOrePrefix().addOres(Ore.Gems.AMBER.colored(-611534), Ore.Gems.QUARTZ.colored(-1910831));
        Finders.METALS.definitions.forMod(modId).withOrePrefix().addOres(Ore.Metals.CINNABAR.colored(-10542301));
        Finders.GEMS.definitions.forMod(modId).withMetaAll().addOre("crystal_aer", -196748).addOre("crystal_ignis", -239103).addOre("crystal_aqua", -12856089).addOre("crystal_terra", -11157504).addOre("crystal_ordo", -2960167).addOre("crystal_perditio", -12632006).addOre("crystal_vitium", -8519563);
    }

    static void initAetherLegacy() {
        String modId = "aether_legacy";
        Finders.GEMS.definitions.forMod(modId).withOreSuffix().addOre(Short.MAX_VALUE, new Ore("ambrosium", -2175115)).addOre("zanite", -12638088);
        Finders.METALS.definitions.forMod(modId).withOreSuffix().addOre("gravitite", -6665853);
    }

    static void initRealWorld() {
        String modId = "realworld";
        Finders.GEMS.definitions.forMod(modId).withOrePrefix().addOres(Ore.Gems.AMETHYST.colored(-4838200), Ore.Gems.CITRINE.colored(-4949734), Ore.Gems.PERIDOT.colored(-9927378), Ore.Gems.MELANITE.colored(-14869216), Ore.Gems.GARNET.colored(-5111808), Ore.Gems.TOPAZ.colored(-23800), Ore.Gems.RUBY.colored(-1048576), Ore.Gems.SAPPHIRE.colored(-16769095), Ore.Gems.TANZANITE.colored(-16742450));
    }

    static void initSimpleOreGeneration() {
        String modId = "simpleoregen";
        String[] prefixes = new String[]{"surface", "nether", "end"};
        String delimiter = ForgeJoiner.Delimiter.none().toString();
        String suffix = new ForgeJoiner(new String[]{"ore"}).capitalizeWordsFor(GameVersions.V10).toString();
        boolean capitalized = GameVersions.getCurrent() == GameVersions.V10;
        Finders.GEMS.definitions.forMod(modId).withPrefixes(prefixes).withDelimiter(delimiter).withSuffixes(suffix).addOres(capitalized, Ore.Gems.DIAMOND.colored(-11866671), Ore.Gems.EMERALD.colored(-16732104), Ore.Gems.LAPIS.colored(-16776961), Ore.Gems.QUARTZ.colored(-790298));
        Finders.METALS.definitions.forMod(modId).withPrefixes(prefixes).withDelimiter(delimiter).withSuffixes(suffix).addOres(capitalized, Ore.Metals.IRON.colored(-2180985), Ore.Metals.GOLD.colored(-10496), Ore.Metals.BAUXITE.colored(-8365538), Ore.Metals.COPPER.colored(-2046559), Ore.Metals.LEAD.colored(-6058837), Ore.Metals.NICKEL.colored(-10714060), Ore.Metals.SILVER.colored(-5855578), Ore.Metals.TIN.colored(-1907998), Ore.Metals.URANIUM.colored(-8922349));
        Finders.MINERALS.definitions.forMod(modId).withPrefixes(prefixes).withDelimiter(delimiter).withSuffixes(suffix).addOres(capitalized, Ore.COAL, Ore.Minerals.REDSTONE.colored(-65536));
    }

    static void initNetherEx() {
        String modId = "nex";
        String ore = "ore";
        String prefix = new ForgeJoiner(new String[]{ore}).setFor(GameVersions.V10, new String[]{""}).toString();
        String suffix = new ForgeJoiner(new String[]{""}).setFor(GameVersions.V10, new String[]{ore}).toString();
        Finders.GEMS.definitions.forMod(modId).withPrefixes(prefix).withSuffixes(suffix).addOres(Ore.Gems.QUARTZ.func_176610_l(), 0, Ore.Gems.QUARTZ.colored(-790298), Ore.Gems.QUARTZ.colored(-790298), Ore.Gems.QUARTZ.colored(-790298), Ore.Gems.QUARTZ.colored(-790298), Ore.Gems.AMETHYST.colored(-9490548)).addOre("rime", -8622147);
    }

    static void initIceAndFire() {
        String modId = "iceandfire";
        Finders.GEMS.definitions.forMod(modId).withOreSuffix().addOre(Ore.Gems.SAPPHIRE.colored(-15912032));
        Finders.METALS.definitions.forMod(modId).withOreSuffix().addOre(Ore.Metals.SILVER.colored(-1644806));
    }

    static void initSteamEnginesMod() {
        String modId = "sem";
        String regName = "erze";
        Finders.METALS.definitions.forMod(modId).addOres(regName, 0, Ore.Metals.TIN.colored(-5921371), Ore.Metals.ZINC.colored(-7355699), Ore.Metals.COPPER.colored(-2195634)).addOre(regName, 4, new Ore("devils", -10161396));
        Finders.MINERALS.definitions.forMod(modId).addOre(regName, 3, Ore.Minerals.SALT.colored(-723724)).addOres(regName, 5, Ore.Minerals.SULFUR.colored(-256), Ore.COAL);
    }

    static void initDefiledLands() {
        String modId = "defiledlands";
        Finders.GEMS.definitions.forMod(modId).withOreSuffix().addOre("scarlite", -3793897);
        Finders.METALS.definitions.forMod(modId).withOreSuffix().addOre("umbrium", -6547516);
        Finders.MINERALS.definitions.forMod(modId).withOreSuffix().addOre("hephaestite", -374784);
    }

    static void initSpectrite() {
        String spectrite;
        String modId = spectrite = "spectrite";
        Finders.GEMS.definitions.forMod(modId).withOreSuffix().addOre(Short.MAX_VALUE, new Ore(spectrite, -1));
    }

    static void initBetterWithAddons() {
        String modId = "betterwithaddons";
        Finders.MINERALS.definitions.forMod(modId).withOreSuffix().addOre(Short.MAX_VALUE, new Ore("world_scale", -7778415));
    }

    static void initAwesomeCraft() {
        String modId = "awesome";
        Finders.METALS.definitions.forMod(modId).withOreSuffix().addOres(Ore.Metals.COPPER.colored(-7316411), Ore.Metals.TIN.colored(-7631989), Ore.Metals.URANIUM.colored(-14579679), Ore.Metals.PLATINUM.colored(-6776424)).addOre("aluminium", Ore.Metals.ALUMINUM.colored(-8947849));
        Finders.MINERALS.definitions.forMod(modId).addOre("salt_block", Ore.Minerals.SALT.colored(-723724));
    }

    static void initClockworkPhase2() {
        String modId = "clockworkphase2";
        Finders.METALS.definitions.forMod(modId).withOreSuffix().addOres(Ore.Metals.COPPER.colored(-4360933), Ore.Metals.ZINC.colored(-9602159), Ore.Metals.ALUMINUM.colored(-6316129));
    }

    static void initMagneticraft() {
        String modId = "magneticraft";
        String regName = "ores";
        Finders.GEMS.definitions.forMod(modId).addOre(regName, 4, Ore.Gems.PYRITE.colored(-1203168));
        Finders.METALS.definitions.forMod(modId).addOres(regName, 0, Ore.Metals.COPPER.colored(-4560059), Ore.Metals.LEAD.colored(-10532700), Ore.Metals.COBALT.colored(-10649444), Ore.Metals.TUNGSTEN.colored(-12303292));
    }

    static void initEssentialCraft4() {
        String modId = "essentialcraft";
        String regName = "oredrops";
        int metaStep = 5;
        Ore oreElemental = new Ore("elemental", -5308241);
        Ore oreFire = new Ore("fire", -5308416);
        Ore oreWater = new Ore("water", -16777037);
        Ore oreEarth = new Ore("earth", -11059416);
        Ore oreAir = new Ore("air", -5197648);
        Ore oreMithriline = new Ore("mithriline", -16739840);
        String mithrilineName = "ore" + oreMithriline.getName();
        Finders.GEMS.definitions.forMod(modId).addOres(regName, 0, metaStep, oreElemental, oreElemental, oreElemental).addOres(regName, 1, metaStep, oreFire, oreFire, oreFire).addOres(regName, 2, metaStep, oreWater, oreWater, oreWater).addOres(regName, 3, metaStep, oreEarth, oreEarth, oreEarth).addOres(regName, 4, metaStep, oreAir, oreAir, oreAir).addOre(mithrilineName, Short.MAX_VALUE, oreMithriline);
        Finders.METALS.definitions.forMod(modId).addOre(mithrilineName, Short.MAX_VALUE, oreMithriline);
    }

    static void initBaseMetals() {
        String modId = "basemetals";
        Finders.METALS.definitions.forMod(modId).withOreSuffix().addOre("coldiron", Ore.Metals.IRON.colored(-8617049)).addOre("starsteel", -16447737).addOre("antimony", -4735814).addOres(Ore.Metals.ADAMANTINE.colored(-10863285), Ore.Metals.BISMUTH.colored(-4014151), Ore.Metals.COPPER.colored(-1474216), Ore.Metals.LEAD.colored(-10587762), Ore.Metals.MERCURY.colored(-8892329), Ore.Metals.NICKEL.colored(-11963808), Ore.Metals.PLATINUM.colored(-984586), Ore.Metals.SILVER.colored(-986896), Ore.Metals.TIN.colored(-10530484), Ore.Metals.ZINC.colored(-3757714));
    }

    static void initBaseMinerals() {
        String modId = "baseminerals";
        Finders.METALS.definitions.forMod(modId).withOreSuffix().addOres(Ore.Metals.LITHIUM.colored(-5733461));
        Finders.MINERALS.definitions.forMod(modId).withOreSuffix().addOres(Ore.Minerals.NITER.colored(-3491151), Ore.Minerals.PHOSPHORUS.colored(-3433302), Ore.Minerals.POTASH.colored(-5540762), Ore.Minerals.SALT.colored(-4144962), Ore.Minerals.SALTPETER.colored(-4213833), Ore.Minerals.SULFUR.colored(-4276659));
    }

    static void initPixelmonReforged() {
        String modId = "pixelmon";
        Finders.GEMS.definitions.forMod(modId).withSuffixes("stone_ore").addOre("thunder", -5197054).addOre("leaf", -13089744).addOre("water", -12564369).addOre("fire", -6397143).addOre("sun", -7253714).withOreSuffix().addOre(Short.MAX_VALUE, new Ore("dawn_dusk", -10652022)).addOres(Ore.Gems.RUBY.colored(-9433571), Ore.Gems.SAPPHIRE.colored(-14797448), Ore.Gems.AMETHYST.colored(-12312229), Ore.Gems.CRYSTAL.colored(-9659214)).addOre("silicon", -7106122);
        Finders.METALS.definitions.forMod(modId).withOreSuffix().addOre(Ore.Metals.BAUXITE.colored(-7045278));
        Finders.MINERALS.definitions.forMod(modId).addOre("fossil", -12305361);
    }

    static void initGeolosys() {
        String modId = "geolosys";
        String ore = "ore";
        String vanilla = ore + "_vanilla";
        Finders.GEMS.definitions.forMod(modId).addOres(vanilla, 3, Ore.Gems.LAPIS.colored(-16776961), Ore.Gems.QUARTZ.colored(-5325604), Ore.Gems.KIMBERLITE.colored(-3158065), Ore.Gems.BERYL.colored(-16713053)).addOres(ore, 2, Ore.Gems.MALACHITE.colored(-12805263), Ore.Gems.AZURITE.colored(-14336402));
        Finders.METALS.definitions.forMod(modId).addOres(ore, 0, Ore.Metals.HEMATITE.colored(-9884132), Ore.Metals.LIMONITE.colored(-4022950)).addOres(vanilla, 1, Ore.Metals.CINNABAR.colored(-7661044), Ore.Metals.GOLD.colored(-10496)).addOres(ore, 4, Ore.Metals.CASSITERITE.colored(-2962779), Ore.Metals.TEALLITE.colored(-4611696), Ore.Metals.GALENA.colored(-11514018), Ore.Metals.BAUXITE.colored(-5409458), Ore.Metals.PLATINUM.colored(-8091235), Ore.Metals.AUTUNITE.colored(-4596720), Ore.Metals.SPHALERITE.colored(-11977378));
        Finders.MINERALS.definitions.forMod(modId).addOre(vanilla, Ore.COAL);
    }

    static void initGregTech() {
        String modId = "gregtech";
        String suf_0 = "0";
        Ore naquadah = Ore.from("naquadah", -14145496);
        Finders.GEMS.definitions.forMod(modId).withOrePrefix().withSuffixes(suf_0).withMetaAll().addOre("garnet_yellow", Ore.Gems.GARNET.colored(-4408245)).addOre("garnet_red", Ore.Gems.GARNET.colored(-4437173)).addOre("blue_topaz", Ore.Gems.TOPAZ.colored(-16776976)).addOre("certus_quartz", Ore.Gems.QUARTZ.colored(-4802872)).addOre("nether_quartz", Ore.Gems.QUARTZ.colored(-3754571)).addOre("green_sapphire", Ore.Gems.SAPPHIRE.colored(-10568582)).addOres(Ore.Gems.SODALITE.colored(-15658537), Ore.Gems.SPESSARTINE.colored(-1024418), Ore.Gems.WULFENITE.colored(-3250432), Ore.Gems.TANZANITE.colored(-12844868), Ore.Gems.EMERALD.colored(-11800501), Ore.Gems.TOPAZ.colored(-1017600), Ore.Gems.MALACHITE.colored(-16495356), Ore.Gems.SCHEELITE.colored(-6196976), Ore.Gems.OLIVINE.colored(-10424224), Ore.Gems.APATITE.colored(-4408080), Ore.Gems.QUARTZITE.colored(-4798282), Ore.Gems.MAGNESITE.colored(-3487087), Ore.Gems.JASPER.colored(-4437173), Ore.Gems.PYROPE.colored(-10475952), Ore.Gems.VINTEUM.colored(-10568464), Ore.Gems.BASTNASITE.colored(-5349337), Ore.Gems.RUBY.colored(-5094075), Ore.Gems.GROSSULAR.colored(-4366848), Ore.Gems.SAPPHIRE.colored(-10789961), Ore.Gems.AMETHYST.colored(-3657784), Ore.Gems.OPAL.colored(-16776975), Ore.Gems.CALCITE.colored(-3491150), Ore.Gems.SPODUMENE.colored(-6714999), Ore.Gems.PYRITE.colored(-8822496), Ore.Gems.LAZURITE.colored(-10521869), Ore.Gems.LAPIS.colored(-12566328), Ore.Gems.ALMANDINE.colored(-1048576), Ore.Gems.DIAMOND.colored(-4328718));
        Finders.METALS.definitions.forMod(modId).withOrePrefix().withSuffixes(suf_0).withMetaAll().addOre("cassiterite_sand", Ore.Metals.CASSITERITE.colored(-4144960)).addOre("yellow_limonite", Ore.Metals.LIMONITE.colored(-6118912)).addOre("brown_limonite", Ore.Metals.LIMONITE.colored(-6139648)).addOre("vanadium_magnetite", Ore.Metals.MAGNETITE.colored(-14934992)).addOre("aluminium", Ore.Metals.ALUMINUM.colored(-9985598)).addOre("uranium235", Ore.Metals.URANIUM.colored(-12192443)).addOre("banded_iron", Ore.Metals.IRON.colored(-9090743)).addOres(Ore.Metals.GALENA.colored(-12375997), Ore.Metals.POWELLITE.colored(-3224064), Ore.Metals.OSMIUM.colored(-13224277), Ore.Metals.LITHIUM.colored(-5987164), Ore.Metals.SILVER.colored(-2565894), Ore.Metals.TIN.colored(-5066062), Ore.Metals.COOPERITE.colored(-5526650), Ore.Metals.GOLD.colored(-2039808), Ore.Metals.URANIUM.colored(-14106072), Ore.Metals.IRON.colored(-12369085), Ore.Metals.IRIDIUM.colored(-3223858), Ore.Metals.ILMENITE.colored(-13095896), Ore.Metals.MOLYBDENUM.colored(-7697739), Ore.Metals.TANTALITE.colored(-9092832), Ore.Metals.MOLYBDENITE.colored(-16119286), Ore.Metals.PITCHBLENDE.colored(-6116864), Ore.Metals.TUNGSTATE.colored(-13883364), Ore.Metals.PYROLUSITE.colored(-8816247), Ore.Metals.LEPIDOLITE.colored(-3265672), Ore.Metals.SPHALERITE.colored(-3223858), Ore.Metals.URANINITE.colored(-15263977), Ore.Metals.TETRAHEDRITE.colored(-6219264), Ore.Metals.CHROMITE.colored(-14872564), Ore.Metals.COBALT.colored(-14605928), Ore.Metals.GARNIERITE.colored(-14114504), Ore.Metals.LEAD.colored(-9416592), Ore.Metals.COPPER.colored(-361216), Ore.Metals.RUTILE.colored(-3601321), Ore.Metals.PLATINUM.colored(-329066), Ore.Metals.PALLADIUM.colored(-10197653), Ore.Metals.BERYLLIUM.colored(-11365806), Ore.Metals.MONAZITE.colored(-13680081), Ore.Metals.NIOBIUM.colored(-8950647), Ore.Metals.BARITE.colored(-4538674), Ore.Metals.THORIUM.colored(-16769792), Ore.Metals.MAGNETITE.colored(-15198184), Ore.Metals.BISMUTH.colored(-11435647), Ore.Metals.BAUXITE.colored(-6205184), Ore.Metals.PENTLANDITE.colored(-8029948), Ore.Metals.CASSITERITE.colored(-11053225), Ore.Metals.CHALCOPYRITE.colored(-8298208), Ore.Metals.NICKEL.colored(-7631914), Ore.Metals.ZINC.colored(-3489086), Ore.Metals.NEODYMIUM.colored(-13750738), Ore.Metals.CINNABAR.colored(-7536640), Ore.Metals.STIBNITE.colored(-13158601), Ore.Metals.COBALTITE.colored(-12500533));
        Finders.MINERALS.definitions.forMod(modId).withOrePrefix().withSuffixes(suf_0).withMetaAll().addOre("naquadah_enriched", naquadah.colored(-15724528)).addOre("rock_salt", Ore.Minerals.SALT.colored(-3101267)).addOres(Ore.Minerals.BENTONITE.colored(-3756375), naquadah, Ore.Minerals.PHOSPHOR.colored(-1579264), Ore.Minerals.SALTPETER.colored(-3684409), Ore.COAL.colored(-12829636), Ore.Minerals.TALC.colored(-11691443), Ore.Minerals.SALT.colored(-2236963), Ore.Minerals.REDSTONE.colored(-6225920), Ore.Minerals.PHOSPHATE.colored(-3224064), Ore.LIGNITE.colored(-11257029), Ore.Minerals.GLAUCONITE.colored(-9858768), Ore.OILSANDS.colored(-16316665), Ore.OILSANDS.colored(-16316665), Ore.Minerals.SOAPSTONE.colored(-11700915), Ore.Minerals.GRAPHITE.colored(-11184811), Ore.Minerals.SULFUR.colored(-5329408));
    }

    static void initNetherendingOres() {
        String modId = "netherendingores";
        String[] prefs = new String[]{"ore_nether", "ore_end"};
        String modded_1 = "modded_1";
        String vanilla = "vanilla";
        String other_1 = "ore_other_1";
        Finders.GEMS.definitions.forMod(modId).addOres(other_1, 0, Ore.Gems.QUARTZ.colored(-2237486), Ore.Gems.QUARTZ.colored(-2237486)).withPrefixes(prefs).addOres(modded_1, 9, Ore.Gems.QUARTZ.colored(-2762260), Ore.Gems.QUARTZ.colored(-2762260)).addOres(vanilla, 1, Ore.Gems.DIAMOND.colored(-10754064), Ore.Gems.EMERALD.colored(-15214240)).addOres(vanilla, 5, Ore.Gems.LAPIS.colored(-15056214));
        Finders.METALS.definitions.forMod(modId).addOres(other_1, 2, Ore.Metals.ARDITE.colored(-3825098), Ore.Metals.ARDITE.colored(-3825098), Ore.Metals.COBALT.colored(-14984771), Ore.Metals.COBALT.colored(-14984771)).withPrefixes(prefs).addOres(modded_1, 0, Ore.Metals.ALUMINUM.colored(-5987158), Ore.Metals.COPPER.colored(-365807), Ore.Metals.IRIDIUM.colored(-5197365), Ore.Metals.LEAD.colored(-9141063), Ore.Metals.MYTHRIL.colored(-8325638), Ore.Metals.NICKEL.colored(-6971533), Ore.Metals.PLATINUM.colored(-13978118), Ore.Metals.SILVER.colored(-1904136), Ore.Metals.TIN.colored(-6965544)).addOres(modded_1, 11, Ore.Metals.OSMIUM.colored(-5524795), Ore.Metals.URANIUM.colored(-12394215), Ore.Metals.YELLORITE.colored(-4605696), Ore.Metals.DILITHIUM.colored(-7548206), Ore.Metals.TRITANIUM.colored(-12759214)).addOres("modded_2", 0, Ore.Metals.ZINC.colored(-5529693)).addOres(vanilla, 3, Ore.Metals.GOLD.colored(-530102), Ore.Metals.IRON.colored(-2839664));
        Finders.MINERALS.definitions.forMod(modId).withPrefixes(prefs).addOre(vanilla, 0, Ore.COAL.colored(-13224394)).addOre(vanilla, 6, Ore.Minerals.REDSTONE.colored(-393216));
    }

    static void initLucraftCore() {
        String modId = "lucraftcore";
        Finders.METALS.definitions.forMod(modId).withOrePrefix().addOres(Ore.Metals.OSMIUM.colored(-5982538), Ore.Metals.COPPER.colored(-3703003), Ore.Metals.SILVER.colored(-4209212), new Ore("dwarf_star_alloy", -10983059), new Ore("uru", -7233122), Ore.Metals.IRIDIUM.colored(-4733752), Ore.Metals.PALLADIUM.colored(-1907998), Ore.Metals.NICKEL.colored(-5921394), Ore.Metals.TIN.colored(-4810111), Ore.Metals.TITANIUM.colored(-12171706), Ore.Metals.URANIUM.colored(-9321149), Ore.Metals.VIBRANIUM.colored(-7348744), Ore.Metals.LEAD.colored(-9599855));
    }

    static void initSilentGems() {
        String modId = "silentgems";
        Finders.GEMS.definitions.forMod(modId).addOres("essenceore", 0, new Ore("chaos", -5004387), new Ore("ender", -11476799)).withSuffixes("classic", "dark", "light").addOre("multi_gem_ore", new Ore("multi-gem", -1)).withNoDelimiters().withSuffixes("ore", "orelight", "oredark").addOres("gem", 0, Ore.Gems.RUBY.colored(-2547945), Ore.Gems.GARNET.colored(-2535401), Ore.Gems.TOPAZ.colored(-2526953), Ore.Gems.AMBER.colored(-2514665), Ore.Gems.HELIODOR.colored(-2506473), Ore.Gems.PERIDOT.colored(-7349993), Ore.Gems.BERYL.colored(-15214305), Ore.Gems.INDICOLITE.colored(-15214208), Ore.Gems.AQUAMARINE.colored(-15232598), Ore.Gems.SAPPHIRE.colored(-14871077), Ore.Gems.IOLITE.colored(-10479655), Ore.Gems.AMETHYST.colored(-6088741), Ore.Gems.AGATE.colored(-2549808), Ore.Gems.MORGANITE.colored(-371764), Ore.Gems.ONYX.colored(-16777216), Ore.Gems.OPAL.colored(-4737097));
    }

    static void initMetallurgy4() {
        String modId = "metallurgy";
        Finders.METALS.definitions.forMod(modId).withOreSuffix().addOres(Ore.Metals.ADAMANTINE.colored(-1755080), new Ore("alduorite", -7870489), new Ore("atlarus", -1066471), new Ore("carmot", -339060), new Ore("ceruclase", -10834720), new Ore("eximite", -4480008), new Ore("ignatius", -329172), new Ore("infuscolium", -3114592), new Ore("kalendrite", -2332705), new Ore("lemurite", -328966), new Ore("meutoite", -11976880), new Ore("midasium", -361939), new Ore("mithril", -14040865), new Ore("orichalcum", -11428550), new Ore("oureclase", -2137811), new Ore("prometheum", -11571379), new Ore("rubracium", -7261132), new Ore("sanguinite", -375529), new Ore("vulcanite", -383211), new Ore("vyroxeres", -14030315)).addOre("astral_silver", Ore.Metals.SILVER.colored(-5455686)).addOre("deep_iron", Ore.Metals.IRON.colored(-15196896)).addOre("shadow_iron", Ore.Metals.IRON.colored(-14344163)).addOres(Ore.Metals.COPPER.colored(-4890309), Ore.Metals.MANGANESE.colored(-6984853), Ore.Metals.PLATINUM.colored(-11568148), Ore.Metals.SILVER.colored(-7490894), Ore.Metals.TIN.colored(-9804710), Ore.Metals.ZINC.colored(-3552898));
        Finders.MINERALS.definitions.forMod(modId).withOreSuffix().addOres(Ore.Minerals.SULFUR.colored(-4016360), Ore.Minerals.PHOSPHORITE.colored(-11917271), Ore.Minerals.BITUMEN.colored(-16119286), Ore.Minerals.POTASH.colored(-3517664));
    }

    static void initExtraGems() {
        String modId = "extragems";
        Finders.GEMS.definitions.forMod(modId).withOreSuffix().addOres(Ore.Gems.RUBY.colored(-2549987), Ore.Gems.SAPPHIRE.colored(-15252007), Ore.Gems.AMETHYST.colored(-6875175), Ore.Gems.TOPAZ.colored(-2510825), Ore.Gems.CRYSTAL.colored(-7810327));
    }

    static void initGemsPlusPlus() {
        String modId = "gemsplusplus";
        Finders.GEMS.definitions.forMod(modId).withNoDelimiters().withPrefixes("ore", "netherore").addOres(Ore.Gems.RUBY.colored(-3533788), Ore.Gems.SAPPHIRE.colored(-16768648), Ore.Gems.AMETHYST.colored(-13631368), Ore.Gems.TOPAZ.colored(-10662641), new Ore("phoenixite", -766720), Ore.Gems.JADE.colored(-10434028), Ore.Gems.CITRINE.colored(-3495404), Ore.Gems.GARNET.colored(-6025187), Ore.Gems.SPINEL.colored(-3533722), Ore.Gems.ONYX.colored(-15987700), Ore.Gems.AGATE.colored(-15435318), Ore.Gems.MALACHITE.colored(-15414702), Ore.Gems.TOURMALINE.colored(-3533676), Ore.Gems.CHRYSOCOLLA.colored(-15414599), Ore.Gems.JASPER.colored(-5362120), Ore.Gems.SUGILITE.colored(-11796258));
    }

    static void initAtum2() {
        String modId = "atum";
        Finders.GEMS.definitions.forMod(modId).withOreSuffix().addOres(Ore.Gems.LAPIS.colored(-15384120), Ore.Gems.DIAMOND.colored(-10754064), Ore.Gems.EMERALD.colored(-15214240), Ore.from("relic", -7903169));
        Finders.METALS.definitions.forMod(modId).withOreSuffix().addOres(Ore.Metals.GOLD.colored(-530102), Ore.Metals.IRON.colored(-2839920));
        Finders.MINERALS.definitions.forMod(modId).withOreSuffix().addOres(Ore.COAL.colored(-13224394), Ore.Minerals.REDSTONE.colored(-393216), Ore.from("bone", -8097448));
    }

    static void initGalacticraft() {
        String modId = "galacticraftcore";
        String blockCore = "basic_block_core";
        String blockMoon = "basic_block_moon";
        Finders.METALS.definitions.forMod(modId).addOres(blockCore, 5, Ore.Metals.COPPER.colored(-3510473), Ore.Metals.TIN.colored(-3752272), Ore.Metals.ALUMINUM.colored(-6181692)).addOres(blockMoon, 0, Ore.Metals.COPPER.colored(-4227014), Ore.Metals.TIN.colored(-3554885));
        Finders.MINERALS.definitions.forMod(modId).addOre(blockCore, 8, Ore.Minerals.SILICON.colored(-13094843)).addOre(blockMoon, 2, Ore.from("cheese", -2702848));
        Finders.GEMS.definitions.forMod(modId).addOre(blockMoon, 6, Ore.Gems.SAPPHIRE.colored(-15250727));
    }

    static void initGalacticraftPlanets() {
        String modId = "galacticraftplanets";
        String blockMars = "mars";
        String blockAsteroids = "asteroids_block";
        String blockVenus = "venus";
        Finders.METALS.definitions.forMod(modId).addOres(blockMars, 0, Ore.Metals.COPPER.colored(-6926592), Ore.Metals.TIN.colored(-328966), Ore.from("desh", -12171706), Ore.Metals.IRON.colored(-2179929)).addOres(blockAsteroids, 3, Ore.Metals.ALUMINUM.colored(-6181692), Ore.Metals.ILMENITE.colored(-14273462), Ore.Metals.IRON.colored(-2384781)).addOres(blockVenus, 6, Ore.Metals.ALUMINUM.colored(-6181692), Ore.Metals.COPPER.colored(-3510473), Ore.Metals.GALENA.colored(-12102526)).addOre(blockVenus, 11, Ore.Metals.TIN.colored(-3423305));
        Finders.GEMS.definitions.forMod(modId).addOre(blockVenus, 9, Ore.Gems.QUARTZ.colored(-5855844));
        Finders.MINERALS.definitions.forMod(modId).addOre(blockVenus, 10, Ore.Minerals.SILICON.colored(-14542286)).addOre(blockVenus, 13, Ore.from("sun_dust", -4622784));
    }

    static void initTerraFirmaCraft() {
        String modId = "tfc";
        String delimiter = "/";
        String[] suffixes = new String[]{"granite", "diorite", "gabbro", "shale", "claystone", "rocksalt", "limestone", "conglomerate", "dolomite", "chert", "chalk", "rhyolite", "basalt", "andesite", "dacite", "quartzite", "slate", "phyllite", "schist", "gneiss", "marble"};
        Finders.GEMS.definitions.forMod(modId).withDelimiter(delimiter).withOrePrefix().withSuffixes(suffixes).addOres(Ore.Gems.CRYOLITE.colored(-2498851), Ore.Gems.SERPENTINE.colored(-8549775), Ore.Gems.OLIVINE.colored(-9734326), Ore.Gems.KIMBERLITE.colored(-3229025), Ore.Gems.JET.colored(-14670816), Ore.Gems.MICROCLINE.colored(-13532048), Ore.Gems.MALACHITE.colored(-9974602)).addOre("lapis_lazuli", Ore.Gems.LAPIS.colored(-13285461));
        Finders.METALS.definitions.forMod(modId).withDelimiter(delimiter).withOrePrefix().withSuffixes(suffixes).addOres(Ore.Metals.HEMATITE.colored(-7505796), Ore.Metals.CASSITERITE.colored(-10657967), Ore.Metals.GALENA.colored(-8422271), Ore.Metals.BISMUTHINITE.colored(-6712196), Ore.Metals.GARNIERITE.colored(-10714543), Ore.Metals.CINNABAR.colored(-6075047), Ore.Metals.PITCHBLENDE.colored(-9871277), Ore.Metals.MAGNETITE.colored(-8091769), Ore.Metals.LIMONITE.colored(-11917542), Ore.Metals.SPHALERITE.colored(-5594208), Ore.Metals.TETRAHEDRITE.colored(-10198943)).addOre("native_copper", Ore.Metals.COPPER.colored(-6069951)).addOre("native_gold", Ore.Metals.GOLD.colored(-4414396)).addOre("native_platinum", Ore.Metals.PLATINUM.colored(-8090776)).addOre("native_silver", Ore.Metals.SILVER.colored(-3818550));
        Finders.MINERALS.definitions.forMod(modId).withDelimiter(delimiter).withOrePrefix().withSuffixes(suffixes).addOres(Ore.Minerals.SALTPETER.colored(-5065808), Ore.Minerals.SYLVITE.colored(-6926041), Ore.Minerals.BORAX.colored(-4408132), Ore.Minerals.SATINSPAR.colored(-5923163), Ore.Minerals.SELENITE.colored(-5789533), Ore.Minerals.GRAPHITE.colored(-7954509), Ore.Minerals.SULFUR.colored(-4802719), Ore.LIGNITE.colored(-11189450), Ore.Minerals.KAOLINITE.colored(-1402753), Ore.Minerals.GYPSUM.colored(-8025977)).addOre("petrified_wood", new Ore("wood", -11320261)).addOre("bituminous_coal", Ore.COAL.colored(-15724277));
    }

    static void initMysticalWorld() {
        String modId = "mysticalworld";
        Finders.GEMS.definitions.forMod(modId).withOreSuffix().addOres(Ore.Gems.AMETHYST.colored(-2776838));
        Finders.METALS.definitions.forMod(modId).withOreSuffix().addOres(Ore.Metals.COPPER.colored(-953046), Ore.Metals.LEAD.colored(-13355709), Ore.Metals.SILVER.colored(-6375738), Ore.Metals.TIN.colored(-7165290)).addOre("quicksilver", Ore.Metals.SILVER.colored(-7627102));
    }

    static void initMistyWorld() {
        String modId = "mist";
        Finders.GEMS.definitions.forMod(modId).withOreSuffix().addOres(Ore.Gems.LAPIS.colored(-16301901));
        Finders.METALS.definitions.forMod(modId).withOreSuffix().addOres(Ore.Metals.IRON.colored(-2839664), Ore.Metals.GOLD.colored(-134588), Ore.Metals.NIOBIUM.colored(-5854516));
        Finders.MINERALS.definitions.forMod(modId).withOreSuffix().addOre("filter_coal", Ore.COAL.colored(-13158849)).addOre("bio_shale", -6700496);
    }

    public static void init() {
        Targets.initVanilla();
        Targets.initAbyssalCraft();
        Targets.initActuallyAdditions();
        Targets.initAdInferos();
        Targets.initAdOver();
        Targets.initAether2();
        Targets.initAetherLegacy();
        Targets.initAppliedEnergistics2();
        Targets.initArsMagica2();
        Targets.initAstralSorcery();
        Targets.initAtum2();
        Targets.initAwesomeCraft();
        Targets.initBaseMetals();
        Targets.initBaseMinerals();
        Targets.initBetterWithAddons();
        Targets.initBiomesOplenty();
        Targets.initClockworkPhase2();
        Targets.initDeepResonance();
        Targets.initDefiledLands();
        Targets.initDraconicEvolution();
        Targets.initEbonArts();
        Targets.initEmbers();
        Targets.initEssentialCraft4();
        Targets.initEvilCraft();
        Targets.initExtraGems();
        Targets.initExtremeReactors();
        Targets.initForestry();
        Targets.initFuturePack();
        Targets.initFunOres();
        Targets.initGalacticraft();
        Targets.initGalacticraftPlanets();
        Targets.initGemsPlusPlus();
        Targets.initGeoActivity();
        Targets.initGeolosys();
        Targets.initGregTech();
        Targets.initIceAndFire();
        Targets.initImmersiveEngineering();
        Targets.initIndustrialCraft2();
        Targets.initLightningCraft();
        Targets.initLotOfThings();
        Targets.initLucraftCore();
        Targets.initMagneticraft();
        Targets.initMekanism();
        Targets.initMetallurgy4();
        Targets.initMistyWorld();
        Targets.initMysticalAgriculture();
        Targets.initMysticalWorld();
        Targets.initNetherendingOres();
        Targets.initNetherEx();
        Targets.initNuclearCraft();
        Targets.initPixelmonReforged();
        Targets.initPracticalLogistics2();
        Targets.initProjectRed();
        Targets.initQuantumFlux();
        Targets.initQuark();
        Targets.initRailcraft();
        Targets.initRealWorld();
        Targets.initRFTools();
        Targets.initSaltyMod();
        Targets.initSilentGems();
        Targets.initSimpleOreGeneration();
        Targets.initSimpleOres();
        Targets.initSpectrite();
        Targets.initSteamEnginesMod();
        Targets.initSubstratum();
        Targets.initTAIGA();
        Targets.initTechReborn();
        Targets.initTerraFirmaCraft();
        Targets.initTerraqueous();
        Targets.initThaumcraft();
        Targets.initTheBetweenlands();
        Targets.initThermalFoundation();
        Targets.initTinkersConstruct();
        Targets.initUndergroundBiomes();
        Targets.initWaterPower();
    }
}

