/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.items;

import com.endertech.common.CommonTime;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.ForgeKeys;
import com.endertech.minecraft.forge.configs.ForgeNBT;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.items.GlassMeter;
import com.endertech.minecraft.forge.messages.ForgeNetMsg;
import com.endertech.minecraft.forge.messages.ForgeNetMsgHandler;
import com.endertech.minecraft.forge.threads.ForgeCacheCleaner;
import com.endertech.minecraft.forge.units.UnitVariant;
import com.endertech.minecraft.mods.adfinders.finder.Definitions;
import com.endertech.minecraft.mods.adfinders.finder.FinderState;
import com.endertech.minecraft.mods.adfinders.finder.Target;
import com.endertech.minecraft.mods.adfinders.init.Finders;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Finder
extends GlassMeter {
    public static final CommonTime.Interval UPDATE_INTERVAL = CommonTime.Interval.seconds((double)1.0);
    public static final CommonTime.Interval STATE_TTL = UPDATE_INTERVAL.mult(5.0);
    public static final IntBounds SEARCH_BOUNDS = new IntBounds(Integer.valueOf(1), Integer.valueOf(64));
    public static final int VERT_RANGE = 2;
    public static final float THICKNESS = 0.08f;
    public static final String TARGETS_CONFIG_KEY = "targets";
    private final Map<Entity, FinderState> finderStates = new ConcurrentHashMap<Entity, FinderState>();
    private final Map<String, List<Target>> targetGroups = new ConcurrentHashMap<String, List<Target>>();
    private final List<Target> allTargets = new ArrayList<Target>();
    private int scanRadius;
    private int pingDepth;
    private int veinMinSize;
    private int depositMinSize;
    private Cleaner cleaner;

    public Finder(ForgeMod mod, UnitConfig config, String name, String baseMaterial, int scanRadius, int pingDepth, int veinMinSize, int depositMinSize, TextFormatting textFormatting) {
        super(mod, config, name, CreativeTabs.field_78040_i, 4, EntityEquipmentSlot.HEAD, textFormatting);
        this.scanRadius = ForgeConfig.getInt((ForgeConfig)config, (String)this.getUnitCategory(), (String)"scanRadius", (int)scanRadius, (IntBounds)SEARCH_BOUNDS, (String)"Defines how far from a player in horizontal plane the targets can be found.");
        this.pingDepth = ForgeConfig.getInt((ForgeConfig)config, (String)this.getUnitCategory(), (String)"pingDepth", (int)pingDepth, (IntBounds)SEARCH_BOUNDS, (String)"Defines how far from a player in vertical plane the ore vein can be found.");
        this.veinMinSize = ForgeConfig.getInt((ForgeConfig)config, (String)this.getUnitCategory(), (String)"veinMinSize", (int)veinMinSize, (IntBounds)SEARCH_BOUNDS, (String)"Defines the minimal size of an ore vein to be found.");
        this.depositMinSize = ForgeConfig.getInt((ForgeConfig)config, (String)this.getUnitCategory(), (String)"depositMinSize", (int)depositMinSize, (IntBounds)SEARCH_BOUNDS, (String)"Defines the minimal size of an ore deposit to get alarm.");
        this.addCraftingRecipe("151 232 424", 1, new String[]{"repeater", baseMaterial, "compass", "comparator", "paneGlass"});
        this.setUnitVariants(Variants.class);
    }

    public static boolean stackHasFinder(ItemStack stack) {
        return stack != null && !stack.func_190926_b() && stack.func_77973_b() instanceof Finder;
    }

    protected void addTargets(Target ... targets) {
        for (Target target : targets) {
            this.addTarget(target);
        }
    }

    protected void addTarget(Target target) {
        String name = target.getName();
        List<Target> group = this.targetGroups.get(name);
        if (group != null) {
            group.add(target);
        } else {
            group = new ArrayList<Target>();
            group.add(target);
            this.targetGroups.put(name, group);
        }
        this.allTargets.add(target);
    }

    protected void addTargets(Collection<Target> targets) {
        for (Target target : targets) {
            this.addTarget(target);
        }
    }

    public void onInit() {
        Definitions definitions = null;
        for (Finders finder : Finders.values()) {
            if (finder.instance != this) continue;
            definitions = finder.definitions;
        }
        if (definitions != null) {
            definitions.syncWithConfigs();
            this.syncTargetsWith(definitions.toArray());
        }
        super.onInit();
    }

    public void syncTargetsWith(String[] definitions) {
        this.allTargets.clear();
        this.targetGroups.clear();
        for (String definition : definitions) {
            List<Target> targetList = Target.from(definition);
            this.addTargets(targetList);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onInitClient() {
    }

    public UnitVariant getVariantFor(ItemStack stack) {
        if (Finder.isBroken((ItemStack)stack)) {
            return this.getVariant((Object)Variants.BROKEN);
        }
        FinderState state = Finder.findStateFor(stack);
        if (state != null && state.isDepositFound()) {
            return this.getVariant((Object)Variants.ALARMED);
        }
        return this.getVariant((Object)Variants.NORMAL);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        EnumHand hand = null;
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entity;
            if (stack.equals(living.func_184614_ca())) {
                hand = EnumHand.MAIN_HAND;
            }
            if (stack.equals(living.func_184592_cb())) {
                hand = EnumHand.OFF_HAND;
            }
        }
        this.updateState(world, stack, entity, hand);
    }

    public void updateState(World world, ItemStack stack, Entity entity, @Nullable EnumHand hand) {
        if (this.isClientSide(world) && Finder.stackHasFinder(stack)) {
            if (Finder.notBroken((ItemStack)stack)) {
                FinderState state = Finder.findStateFor(stack);
                if (state == null) {
                    state = this.createStateFor(stack, entity);
                }
                if (state != null && state.needsUpdate()) {
                    state.update(entity);
                    if (hand != null && entity instanceof EntityLivingBase) {
                        FinderState.UpdateMsg message = new FinderState.UpdateMsg((EntityLivingBase)entity, hand);
                        this.getMod().getConnection().sendToServer((IMessage)message);
                    }
                }
            }
            this.cleanOutdatedStates();
        }
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        this.updateState(entityItem.field_70170_p, entityItem.func_92059_d(), (Entity)entityItem, null);
        return super.onEntityItemUpdate(entityItem);
    }

    protected FinderState createStateFor(ItemStack stack, Entity carrier) {
        this.carriers.put(stack, carrier);
        FinderState state = new FinderState(Finder.getFinderItem(stack), carrier);
        this.finderStates.put(carrier, state);
        return state;
    }

    @Nullable
    public static FinderState findStateFor(ItemStack stack) {
        if (Finder.stackHasFinder(stack)) {
            Finder finder = Finder.getFinderItem(stack);
            Entity entity = (Entity)finder.carriers.get(stack);
            if (entity != null) {
                return finder.finderStates.get(entity);
            }
        }
        return null;
    }

    public static Finder getFinderItem(ItemStack stack) {
        return (Finder)stack.func_77973_b();
    }

    public int getScanRadius() {
        return this.scanRadius;
    }

    public int getPingDepth() {
        return this.pingDepth;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        FinderState state = Finder.findStateFor(stack);
        if (state != null) {
            GameSettings gs = ForgeKeys.getGameSettings();
            if (ForgeKeys.isDown((KeyBinding)gs.field_151444_V)) {
                tooltip.add(I18n.func_135052_a((String)"tooltip.finder.needles", (Object[])new Object[]{TextFormatting.RESET, TextFormatting.GREEN}));
                tooltip.add(I18n.func_135052_a((String)"tooltip.finder.arrows", (Object[])new Object[]{TextFormatting.RESET, TextFormatting.YELLOW}));
                tooltip.add(I18n.func_135052_a((String)"tooltip.finder.red_lights", (Object[])new Object[]{TextFormatting.RESET, TextFormatting.RED}));
            } else {
                Finder finder = state.getFinder();
                tooltip.add(I18n.func_135052_a((String)"tooltip.finder.scan_radius", (Object[])new Object[]{TextFormatting.GREEN}) + ": " + finder.getScanRadius());
                tooltip.add(I18n.func_135052_a((String)"tooltip.finder.ping_depth", (Object[])new Object[]{TextFormatting.YELLOW}) + ": " + finder.getPingDepth());
                tooltip.add(I18n.func_135052_a((String)"tooltip.finder.more_info", (Object[])new Object[]{TextFormatting.GRAY, TextFormatting.DARK_PURPLE, ForgeKeys.getName((KeyBinding)gs.field_151444_V)}));
            }
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public Map<String, List<Target>> getTargetGroups() {
        return Collections.unmodifiableMap(this.targetGroups);
    }

    public List<Target> getAllTargets() {
        return Collections.unmodifiableList(this.allTargets);
    }

    public Map<Entity, FinderState> getFinderStates() {
        return Collections.unmodifiableMap(this.finderStates);
    }

    public int getVeinMinSize() {
        return this.veinMinSize;
    }

    private void cleanOutdatedStates() {
        if (this.cleaner == null || this.cleaner.isTimeToRun()) {
            this.cleaner = new Cleaner(UPDATE_INTERVAL.mult(5.0));
        }
    }

    public int getDepositMinSize() {
        return this.depositMinSize;
    }

    public class Cleaner
    extends ForgeCacheCleaner {
        public Cleaner(CommonTime.Interval runInterval) {
            super(runInterval);
        }

        public void run() {
            Iterator<Object> iterator = Finder.this.finderStates.values().iterator();
            while (iterator.hasNext()) {
                FinderState state = (FinderState)iterator.next();
                if (state.isActual()) continue;
                iterator.remove();
            }
            iterator = Finder.this.carriers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                ItemStack stack = (ItemStack)entry.getKey();
                Entity entity = (Entity)entry.getValue();
                if (!stack.func_190926_b() && ForgeEntity.hasStack((Entity)entity, (ItemStack)stack)) continue;
                iterator.remove();
            }
            iterator = Finder.this.carriers.values().iterator();
            while (iterator.hasNext()) {
                Entity entity = (Entity)iterator.next();
                if (Finder.this.finderStates.get(entity) != null) continue;
                iterator.remove();
            }
        }
    }

    public static class SyncClientMsg
    extends ForgeNetMsg {
        private static final String KEY_DEFINITIONS = Definitions.class.getSimpleName();
        public Finders finder;
        public int scanRadius;
        public int pingDepth;
        public int veinMinSize;
        public int depositMinSize;
        public NBTTagCompound definitions;

        public SyncClientMsg() {
        }

        public SyncClientMsg(Finders finder) {
            this.finder = finder;
            this.scanRadius = finder.instance.getScanRadius();
            this.pingDepth = finder.instance.getPingDepth();
            this.veinMinSize = finder.instance.getVeinMinSize();
            this.depositMinSize = finder.instance.getDepositMinSize();
            this.definitions = new NBTTagCompound();
            ForgeNBT.writeStringArray((NBTTagCompound)this.definitions, (String)KEY_DEFINITIONS, (String[])finder.definitions.toArray());
        }

        public static class handler
        extends ForgeNetMsgHandler<SyncClientMsg> {
            public IMessage onMessage(SyncClientMsg message, MessageContext ctx) {
                this.addScheduledTask(ctx, () -> {
                    Finder finder = message.finder.instance;
                    String[] definitions = ForgeNBT.readStringArray((NBTTagCompound)message.definitions, (String)KEY_DEFINITIONS);
                    finder.syncTargetsWith(definitions);
                    finder.scanRadius = message.scanRadius;
                    finder.pingDepth = message.pingDepth;
                    finder.veinMinSize = message.veinMinSize;
                    finder.depositMinSize = message.depositMinSize;
                });
                return null;
            }
        }
    }

    static enum Tags {
        FINDER,
        SCAN_RADIUS,
        PING_DEPTH,
        VEIN_MIN_SIZE,
        DEPOSIT_MIN_SIZE;

    }

    private static enum Variants implements IForgeEnum
    {
        NORMAL,
        BROKEN,
        ALARMED;


        public String func_176610_l() {
            return this.getLowerCase(this.name());
        }
    }
}

