/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.finder;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.mods.adfinders.finder.Indicator;
import com.endertech.minecraft.mods.adfinders.finder.TargetLocation;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum Arrows {
    OVERHEAD(0.0, 1),
    UNDERFOOT(180.0, -1);

    private final CommonMath.Angle angle;
    public final int step;

    private Arrows(double degrees, int step) {
        this.angle = CommonMath.Angle.fromDegrees((double)degrees);
        this.step = step;
    }

    public Arrow create(ColorARGB color, TargetLocation location) {
        return new Arrow(color, location, this.angle);
    }

    class Arrow
    extends Indicator {
        private static final double SIZE = 0.2;
        private final CommonMath.Angle angle;

        public Arrow(ColorARGB color, TargetLocation location, CommonMath.Angle angle) {
            super(color, location);
            this.angle = angle;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void draw(double scale) {
            double size = 0.2 * scale;
            float degrees = (float)this.angle.getDegrees();
            GlStateManager.rotatef((float)degrees, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.color4f((float)this.getColor().getRed().toFloat(), (float)this.getColor().getGreen().toFloat(), (float)this.getColor().getBlue().toFloat(), (float)this.getColor().getAlpha().toFloat());
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder buf = tess.func_178180_c();
            buf.func_181668_a(4, DefaultVertexFormats.field_181707_g);
            buf.func_181662_b(0.0, size, 0.0).func_187315_a(0.5, 0.0).func_181675_d();
            buf.func_181662_b(-size, size / 2.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            buf.func_181662_b(size, size / 2.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            tess.func_78381_a();
            GlStateManager.rotatef((float)(-degrees), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

