/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.finder;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.math.GameMath;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adfinders.finder.Indicator;
import com.endertech.minecraft.mods.adfinders.finder.TargetLocation;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Comparator;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Needle
extends Indicator {
    private static final double WIDTH = 0.1;
    private static final double LENGTH = 0.35;
    public static final double OFFSET = 0.001;
    public static final Comparator<Needle> SORTING_COMPARATOR = (t1, t2) -> t1.equals(t2) ? 0 : -Double.compare(t1.getTargetLocation().getDistance(), t2.getTargetLocation().getDistance());

    public Needle(ColorARGB color, TargetLocation location) {
        super(color, location);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(CommonMath.Angle angle, double scale) {
        double degrees = angle.getDegrees();
        GlStateManager.rotated((double)degrees, (double)0.0, (double)0.0, (double)1.0);
        GlStateManager.color4f((float)this.getColor().getRed().toFloat(), (float)this.getColor().getGreen().toFloat(), (float)this.getColor().getBlue().toFloat(), (float)this.getColor().getAlpha().toFloat());
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        double sW = 0.05 * scale;
        double sL = 0.35 * scale;
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b(-sW, -sL / 5.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        buf.func_181662_b(sW, -sL / 5.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        buf.func_181662_b(sW, sL, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buf.func_181662_b(-sW, sL, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        tess.func_78381_a();
        GlStateManager.rotated((double)(-degrees), (double)0.0, (double)0.0, (double)1.0);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public CommonMath.Angle getAngle(Vect3d startPos, float rotationYaw) {
        Vect3d targetPos = GameWorld.getBlockCenter((BlockPos)this.getTargetLocation().getPos());
        Vect3d delta = startPos.subtract(targetPos);
        return CommonMath.Angle.fromDegrees((double)(rotationYaw - 90.0f - GameMath.arcTan((double)delta.z, (double)delta.x)));
    }
}

