/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.finder;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.client.GameRendering;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.mods.adfinders.finder.Arrows;
import com.endertech.minecraft.mods.adfinders.finder.FinderState;
import com.endertech.minecraft.mods.adfinders.finder.Needle;
import com.endertech.minecraft.mods.adfinders.items.Finder;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.ForgeConfig;
import org.apache.commons.lang3.ArrayUtils;

@OnlyIn(value=Dist.CLIENT)
public class Renderer
extends ItemStackTileEntityRenderer {
    public void func_179022_a(ItemStack stack) {
        IBakedModel model = this.getItemRenderer().func_184393_a(stack, null, null);
        this.renderModel(model, -1, stack);
        if (stack.func_77962_s()) {
            this.getItemRenderer();
            ItemRenderer.func_211128_a((TextureManager)Minecraft.func_71410_x().func_110434_K(), () -> this.renderModel(model, -8372020, ItemStack.field_190927_a), (int)8);
        }
        this.renderIndicators(stack);
    }

    ItemRenderer getItemRenderer() {
        return Minecraft.func_71410_x().func_175599_af();
    }

    void renderIndicators(ItemStack stack) {
        double scale = 1.0;
        FinderState state = Finder.findStateFor(stack);
        if (state == null) {
            return;
        }
        GameRendering.MeterIndicators.beforeRender((float)0.08f);
        Entity carrier = state.getCarrier();
        Vect3d startPos = ForgeEntity.getCenterPosition((Entity)carrier);
        float rotationYaw = carrier.field_70177_z;
        if (carrier instanceof LivingEntity) {
            Minecraft mc = Minecraft.func_71410_x();
            if (carrier != mc.field_71439_g || mc.field_71474_y.field_74320_O > 0) {
                rotationYaw = ((LivingEntity)carrier).field_70761_aq;
            }
        }
        double offset = 0.0;
        for (Arrows.Arrow arrow : state.getArrows().values()) {
            if (arrow == null) continue;
            GlStateManager.translated((double)0.0, (double)0.0, (double)offset);
            arrow.draw(1.0);
            GlStateManager.translated((double)0.0, (double)0.0, (double)(-offset));
        }
        offset = 0.001;
        GlStateManager.translated((double)0.0, (double)0.0, (double)offset);
        for (Needle needle : state.getNeedles()) {
            CommonMath.Angle angle = needle.getAngle(startPos, rotationYaw);
            GlStateManager.translated((double)0.0, (double)0.0, (double)offset);
            needle.draw(angle, 1.0);
            GlStateManager.translated((double)0.0, (double)0.0, (double)(-offset));
            offset += 0.001;
        }
        GameRendering.MeterIndicators.afterRender();
    }

    void renderModel(IBakedModel model, int color, ItemStack stack) {
        if (((Boolean)ForgeConfig.CLIENT.allowEmissiveItems.get()).booleanValue()) {
            ForgeHooksClient.renderLitItem((ItemRenderer)this.getItemRenderer(), (IBakedModel)model, (int)color, (ItemStack)stack);
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        Random random = new Random(42L);
        for (Direction direction : (Direction[])ArrayUtils.add((Object[])Direction.values(), null)) {
            this.getItemRenderer().func_191970_a(builder, model.getQuads(null, direction, random, (IModelData)EmptyModelData.INSTANCE), color, stack);
        }
        tessellator.func_78381_a();
    }
}

