function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile(
			'coremods/core_functions.js')

	var targetBlock = {
		'type' : 'METHOD',
		'class' : 'net/minecraft/block/BlockState',
		'methodName' : resolveName('func_196944_b'), // randomTick
		'methodDesc' : '(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Ljava/util/Random;)V'
	}

	var targetFluid = {
		'type' : 'METHOD',
		'class' : 'net/minecraft/fluid/IFluidState',
		'methodName' : resolveName('func_206891_b'), // randomTick
		'methodDesc' : '(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Ljava/util/Random;)V'
	}

	var handlerBlock = {
		'class' : 'com/endertech/minecraft/forge/events/RandomTickEvent',
		'methodName' : 'onRandomTickBlock',
		'methodDesc' : '(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;)Z'
	}

	var handlerFluid = {
		'class' : 'com/endertech/minecraft/forge/events/RandomTickEvent',
		'methodName' : 'onRandomTickFluid',
		'methodDesc' : '(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/fluid/IFluidState;)Z'
	}

	var instructions = [ 
		insnLoadObj(1, "world"), 
		insnLoadObj(2, "pos"),
		insnLoadObj(0, "state"), 
	];

	return {
		'randomTickBlock' : {
			'target' : targetBlock,
			'transformer' : function(method) {
				insertInstructionsBeforeAll(method, instructions.concat(insnCallHandler(handlerBlock), instructionsIfTrueReturn()));
				return method;
			}
		},
		'randomTickFluid' : {
			'target' : targetFluid,
			'transformer' : function(method) {
				insertInstructionsBeforeAll(method, instructions.concat(insnCallHandler(handlerFluid), instructionsIfTrueReturn()));
				return method;
			}
		}
	}
}