/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.client;

import com.endertech.minecraft.forge.data.GamePath;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.units.IForgeUnit;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public final class GameRendering {
    public static void bindTexture(ResourceLocation texture) {
        TextureManager manager = Minecraft.func_71410_x().func_110434_K();
        manager.func_110577_a(texture);
    }

    public static void line(float width, Vect3d from, Vect3d to) {
        RenderSystem.lineWidth((float)width);
        GameRendering.begin(1);
        GameRendering.vertex(from);
        GameRendering.vertex(to);
        GameRendering.end();
    }

    public static void begin(int mode) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL11.glBegin((int)mode);
    }

    public static void vertex(Vect3d vect) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL11.glVertex3d((double)vect.x, (double)vect.y, (double)vect.z);
    }

    public static void vertex3f(float x, float y, float z) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL11.glVertex3f((float)x, (float)y, (float)z);
    }

    public static void end() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL11.glEnd();
    }

    public static void enable(int target) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL11.glEnable((int)target);
    }

    public static void disable(int target) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL11.glDisable((int)target);
    }

    public static void pushMatrix() {
        RenderSystem.pushMatrix();
    }

    public static void popMatrix() {
        RenderSystem.popMatrix();
    }

    public static void rotatef(float angle, float x, float y, float z) {
        RenderSystem.rotatef((float)angle, (float)x, (float)y, (float)z);
    }

    public static void scalef(float x, float y, float z) {
        RenderSystem.scalef((float)x, (float)y, (float)z);
    }

    public static void translatef(float x, float y, float z) {
        RenderSystem.translatef((float)x, (float)y, (float)z);
    }

    public static void normal3f(float nx, float ny, float nz) {
        RenderSystem.normal3f((float)nx, (float)ny, (float)nz);
    }

    public static void color4f(float red, float green, float blue, float alpha) {
        RenderSystem.color4f((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void enableRescaleNormal() {
        RenderSystem.enableRescaleNormal();
    }

    public static void enableSmoothLines() {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableTexture();
        RenderSystem.disableLighting();
        RenderSystem.disableCull();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        GameRendering.enable(2848);
    }

    public static void disableSmoothLines() {
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
        RenderSystem.enableLighting();
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        GameRendering.disable(2848);
    }

    public static void renderItemLayerIn2D(int width, int height, float thickness, float minX, float minY, float maxX, float maxY, float minU, float minV, float maxU, float maxV, float layerOffsetX, float layerOffsetY, float layerOffsetZ) {
        float v;
        float y;
        float u;
        float x;
        int i;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        float x1 = minX + layerOffsetX;
        float x2 = maxX - layerOffsetX;
        float y1 = minY + layerOffsetY;
        float y2 = maxY - layerOffsetY;
        float z1 = 0.0f - layerOffsetZ;
        float z2 = layerOffsetZ - thickness;
        GameRendering.normal3f(0.0f, 0.0f, 1.0f);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_225582_a_((double)x1, (double)y1, (double)z1).func_225583_a_(minU, minV).func_181675_d();
        buffer.func_225582_a_((double)x2, (double)y1, (double)z1).func_225583_a_(maxU, minV).func_181675_d();
        buffer.func_225582_a_((double)x2, (double)y2, (double)z1).func_225583_a_(maxU, maxV).func_181675_d();
        buffer.func_225582_a_((double)x1, (double)y2, (double)z1).func_225583_a_(minU, maxV).func_181675_d();
        tessellator.func_78381_a();
        GameRendering.normal3f(0.0f, 0.0f, -1.0f);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_225582_a_((double)x1, (double)y2, (double)z2).func_225583_a_(minU, maxV).func_181675_d();
        buffer.func_225582_a_((double)x2, (double)y2, (double)z2).func_225583_a_(maxU, maxV).func_181675_d();
        buffer.func_225582_a_((double)x2, (double)y1, (double)z2).func_225583_a_(maxU, minV).func_181675_d();
        buffer.func_225582_a_((double)x1, (double)y1, (double)z2).func_225583_a_(minU, minV).func_181675_d();
        tessellator.func_78381_a();
        float halfPixelWidth = 0.5f * (minU - maxU) / (float)width;
        float halfPixelHeight = 0.5f * (minV - maxV) / (float)height;
        GameRendering.normal3f(-1.0f, 0.0f, 0.0f);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (i = 0; i < width; ++i) {
            x = (float)i / (float)width;
            u = minU + (maxU - minU) * x - halfPixelWidth;
            x = x1 + (float)i * (maxX - minX - 2.0f * layerOffsetX) / (float)width;
            buffer.func_225582_a_((double)x, (double)y1, (double)z2).func_225583_a_(u, minV).func_181675_d();
            buffer.func_225582_a_((double)x, (double)y1, (double)z1).func_225583_a_(u, minV).func_181675_d();
            buffer.func_225582_a_((double)x, (double)y2, (double)z1).func_225583_a_(u, maxV).func_181675_d();
            buffer.func_225582_a_((double)x, (double)y2, (double)z2).func_225583_a_(u, maxV).func_181675_d();
        }
        tessellator.func_78381_a();
        GameRendering.normal3f(1.0f, 0.0f, 0.0f);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (i = 0; i < width; ++i) {
            x = (float)i / (float)width;
            u = minU + (maxU - minU) * x - halfPixelWidth;
            x = x1 + ((float)i + 1.0f) * (maxX - minX - 2.0f * layerOffsetX) / (float)width;
            buffer.func_225582_a_((double)x, (double)y2, (double)z2).func_225583_a_(u, maxV).func_181675_d();
            buffer.func_225582_a_((double)x, (double)y2, (double)z1).func_225583_a_(u, maxV).func_181675_d();
            buffer.func_225582_a_((double)x, (double)y1, (double)z1).func_225583_a_(u, minV).func_181675_d();
            buffer.func_225582_a_((double)x, (double)y1, (double)z2).func_225583_a_(u, minV).func_181675_d();
        }
        tessellator.func_78381_a();
        GameRendering.normal3f(0.0f, 1.0f, 0.0f);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (i = 0; i < height; ++i) {
            y = (float)i / (float)height;
            v = minV + (maxV - minV) * y - halfPixelHeight;
            y = y1 + ((float)i + 1.0f) * (maxY - minY - 2.0f * layerOffsetY) / (float)height;
            buffer.func_225582_a_((double)x1, (double)y, (double)z1).func_225583_a_(minU, v).func_181675_d();
            buffer.func_225582_a_((double)x2, (double)y, (double)z1).func_225583_a_(maxU, v).func_181675_d();
            buffer.func_225582_a_((double)x2, (double)y, (double)z2).func_225583_a_(maxU, v).func_181675_d();
            buffer.func_225582_a_((double)x1, (double)y, (double)z2).func_225583_a_(minU, v).func_181675_d();
        }
        tessellator.func_78381_a();
        GameRendering.normal3f(0.0f, -1.0f, 0.0f);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (i = 0; i < height; ++i) {
            y = (float)i / (float)height;
            v = minV + (maxV - minV) * y - halfPixelHeight;
            y = y1 + (float)i * (maxY - minY - 2.0f * layerOffsetY) / (float)height;
            buffer.func_225582_a_((double)x2, (double)y, (double)z1).func_225583_a_(maxU, v).func_181675_d();
            buffer.func_225582_a_((double)x1, (double)y, (double)z1).func_225583_a_(minU, v).func_181675_d();
            buffer.func_225582_a_((double)x1, (double)y, (double)z2).func_225583_a_(minU, v).func_181675_d();
            buffer.func_225582_a_((double)x2, (double)y, (double)z2).func_225583_a_(maxU, v).func_181675_d();
        }
        tessellator.func_78381_a();
    }

    public static void renderBlock(float x, float y, float z, float width, float height, float length, float rotateX, float rotateY, float rotateZ, float red, float green, float blue, float alpha) {
        GameRendering.pushMatrix();
        GameRendering.translatef(x, y, z);
        GameRendering.enableRescaleNormal();
        GameRendering.rotatef(rotateX, 1.0f, 0.0f, 0.0f);
        GameRendering.rotatef(rotateY, 0.0f, 1.0f, 0.0f);
        GameRendering.rotatef(rotateZ, 0.0f, 0.0f, 1.0f);
        GameRendering.scalef(width, height, length);
        GameRendering.color4f(red, green, blue, alpha);
        GameRendering.begin(9);
        GameRendering.normal3f(0.0f, 1.0f, 0.0f);
        GameRendering.vertex3f(-0.5f, 0.5f, 0.5f);
        GameRendering.vertex3f(-0.5f, 0.5f, 0.5f);
        GameRendering.vertex3f(0.5f, 0.5f, 0.5f);
        GameRendering.vertex3f(0.5f, 0.5f, -0.5f);
        GameRendering.vertex3f(-0.5f, 0.5f, -0.5f);
        GameRendering.end();
        GameRendering.begin(9);
        GameRendering.normal3f(0.0f, 0.0f, 1.0f);
        GameRendering.vertex3f(0.5f, -0.5f, 0.5f);
        GameRendering.vertex3f(0.5f, 0.5f, 0.5f);
        GameRendering.vertex3f(-0.5f, 0.5f, 0.5f);
        GameRendering.vertex3f(-0.5f, -0.5f, 0.5f);
        GameRendering.end();
        GameRendering.begin(9);
        GameRendering.normal3f(1.0f, 0.0f, 0.0f);
        GameRendering.vertex3f(0.5f, 0.5f, -0.5f);
        GameRendering.vertex3f(0.5f, 0.5f, 0.5f);
        GameRendering.vertex3f(0.5f, -0.5f, 0.5f);
        GameRendering.vertex3f(0.5f, -0.5f, -0.5f);
        GameRendering.end();
        GameRendering.begin(9);
        GameRendering.normal3f(-1.0f, 0.0f, 0.0f);
        GameRendering.vertex3f(-0.5f, -0.5f, 0.5f);
        GameRendering.vertex3f(-0.5f, 0.5f, 0.5f);
        GameRendering.vertex3f(-0.5f, 0.5f, -0.5f);
        GameRendering.vertex3f(-0.5f, -0.5f, -0.5f);
        GameRendering.end();
        GameRendering.begin(9);
        GameRendering.normal3f(0.0f, -1.0f, 0.0f);
        GameRendering.vertex3f(0.5f, -0.5f, 0.5f);
        GameRendering.vertex3f(-0.5f, -0.5f, 0.5f);
        GameRendering.vertex3f(-0.5f, -0.5f, -0.5f);
        GameRendering.vertex3f(0.5f, -0.5f, -0.5f);
        GameRendering.end();
        GameRendering.begin(9);
        GameRendering.normal3f(0.0f, 0.0f, -1.0f);
        GameRendering.vertex3f(0.5f, 0.5f, -0.5f);
        GameRendering.vertex3f(0.5f, -0.5f, -0.5f);
        GameRendering.vertex3f(-0.5f, -0.5f, -0.5f);
        GameRendering.vertex3f(-0.5f, 0.5f, -0.5f);
        GameRendering.end();
        GameRendering.popMatrix();
    }

    public static class MeterIndicators {
        public static final ResourceLocation TEXTURE = GamePath.itemTexture((ResourceLocation)new ResourceLocation((String)"forgeendertech", (String)IForgeUnit.getClassRegName(MeterIndicators.class)), (String[])new String[0]).location;

        public static void begin(MatrixStack matrix, float meterThickness) {
            GameRendering.pushMatrix();
            RenderSystem.multMatrix((Matrix4f)matrix.func_227866_c_().func_227870_a_());
            GameRendering.translatef(0.5f, 0.5f, 0.5f);
            GameRendering.translatef(0.0f, 0.0f, -meterThickness / 2.0f);
            GameRendering.bindTexture(TEXTURE);
        }

        public static void end() {
            GameRendering.popMatrix();
        }
    }
}

