/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import com.endertech.common.Args;
import com.endertech.minecraft.forge.data.INBTSerializable;
import com.endertech.minecraft.forge.data.INetSerializable;
import com.endertech.minecraft.forge.world.ChunkBounds;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class ChunkLoc
implements INetSerializable<ChunkLoc>,
INBTSerializable<ChunkLoc> {
    public static final ChunkLoc ZERO = new ChunkLoc(0, new ChunkPos(0, 0));
    private final int dimensionId;
    private final ChunkPos pos;
    private final ChunkBounds bounds;

    public ChunkLoc(int dimensionId, ChunkPos pos) {
        this.pos = pos;
        this.dimensionId = dimensionId;
        this.bounds = ChunkBounds.from(pos);
    }

    public ChunkLoc(World world, ChunkPos pos) {
        this(world.func_201675_m().func_186058_p().func_186068_a(), pos);
    }

    public static ChunkLoc from(Chunk chunk) {
        return new ChunkLoc(chunk.func_177412_p(), chunk.func_76632_l());
    }

    public static ChunkLoc fromIntArray(int[] array) {
        int dim = array[0];
        int x = array[1];
        int z = array[2];
        return new ChunkLoc(dim, new ChunkPos(x, z));
    }

    public int getDimensionId() {
        return this.dimensionId;
    }

    public ChunkPos getPos() {
        return this.pos;
    }

    public ChunkBounds getBounds() {
        return this.bounds;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChunkLoc) {
            ChunkLoc loc = (ChunkLoc)obj;
            return loc.getDimensionId() == this.getDimensionId() && this.getPos().equals((Object)loc.getPos());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(this.getPos(), this.getDimensionId());
    }

    public boolean contains(Entity entity) {
        return this.getDimensionId() == entity.field_71093_bK.func_186068_a() && this.getBounds().encloses(entity.func_180425_c());
    }

    public String toString() {
        return ChunkLoc.class.getSimpleName() + Args.group(Args.get("pos", this.getPos()), Args.get("dimensionId", this.getDimensionId()));
    }

    @Override
    public ChunkLoc readFrom(PacketBuffer buf) {
        return new ChunkLoc(buf.readInt(), new ChunkPos(buf.readInt(), buf.readInt()));
    }

    @Override
    public PacketBuffer writeTo(PacketBuffer buf) {
        buf.writeInt(this.getDimensionId());
        buf.writeInt(this.getPos().field_77276_a);
        buf.writeInt(this.getPos().field_77275_b);
        return buf;
    }

    @Override
    public ChunkLoc readFrom(CompoundNBT compound) {
        int[] array = compound.func_74759_k(this.getTagName());
        int dim = array[0];
        int x = array[1];
        int z = array[2];
        return new ChunkLoc(dim, new ChunkPos(x, z));
    }

    @Override
    public CompoundNBT writeTo(CompoundNBT compound) {
        int[] array = new int[]{this.getDimensionId(), this.getPos().field_77276_a, this.getPos().field_77275_b};
        compound.func_74783_a(this.getTagName(), array);
        return compound;
    }
}

