/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.world.GameWorld;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class HorizSpread {
    private final World world;
    private final BlockPos centerPos;
    private final Predicate<BlockState> canPassThrough;
    private final int radius;
    private final boolean[][] checkedMatrix;
    private final int centerIndex;
    private final Predicate<BlockState> matchedState;
    private final IntBounds indexRange;

    protected HorizSpread(World world, BlockPos centerPos, int radius, Predicate<BlockState> canSpreadThrough, Predicate<BlockState> matchedState) {
        this.world = world;
        this.centerPos = centerPos;
        this.radius = radius;
        this.canPassThrough = canSpreadThrough;
        this.matchedState = matchedState;
        int matrixSize = this.radius * 2 + 1;
        this.checkedMatrix = new boolean[matrixSize][matrixSize];
        this.centerIndex = radius;
        this.indexRange = new IntBounds(0, matrixSize - 1);
    }

    protected boolean isInRange(BlockPos pos) {
        Vec3i matrixPos = this.getMatrixPos(pos);
        return this.indexRange.encloses(matrixPos.func_177958_n()) && this.indexRange.encloses(matrixPos.func_177956_o()) && this.indexRange.encloses(matrixPos.func_177952_p());
    }

    protected boolean isChecked(BlockPos pos) {
        Vec3i matrixPos = this.getMatrixPos(pos);
        return this.checkedMatrix[matrixPos.func_177958_n()][matrixPos.func_177952_p()];
    }

    protected void setChecked(BlockPos pos) {
        Vec3i matrixPos = this.getMatrixPos(pos);
        this.checkedMatrix[matrixPos.func_177958_n()][matrixPos.func_177952_p()] = true;
    }

    protected Vec3i getMatrixPos(BlockPos pos) {
        return pos.func_177973_b((Vec3i)this.centerPos).func_177982_a(this.centerIndex, this.centerIndex, this.centerIndex);
    }

    @Nullable
    protected BlockPos findMatchedPos(BlockPos pos) {
        if (!this.isInRange(pos) || this.isChecked(pos)) {
            return null;
        }
        BlockState state = this.world.func_180495_p(pos);
        if (this.matchedState.test(state)) {
            return pos;
        }
        this.setChecked(pos);
        if (this.canPassThrough.test(state)) {
            for (Direction direction : GameWorld.Directions.getShuffledHorizontals()) {
                BlockPos foundPos = this.findMatchedPos(pos.func_177972_a(direction));
                if (foundPos == null) continue;
                return foundPos;
            }
        }
        return null;
    }

    @Nullable
    public static BlockPos findAirPos(World world, BlockPos centerPos, int radius, Predicate<BlockState> canSpreadThrough) {
        return HorizSpread.findMatchedPos(world, centerPos, radius, canSpreadThrough, state -> state.func_185904_a() == Material.field_151579_a);
    }

    @Nullable
    public static BlockPos findMatchedPos(World world, BlockPos centerPos, int radius, Predicate<BlockState> canSpreadThrough, Predicate<BlockState> matchedState) {
        BlockState state = world.func_180495_p(centerPos);
        if (matchedState.test(state)) {
            return centerPos;
        }
        if (canSpreadThrough.test(state)) {
            HorizSpread spread = new HorizSpread(world, centerPos, radius, canSpreadThrough, matchedState);
            return spread.findMatchedPos(centerPos);
        }
        return null;
    }
}

