/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.finder;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.math.GameMath;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adfinders.finder.Indicator;
import com.endertech.minecraft.mods.adfinders.finder.TargetLocation;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Comparator;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Needle
extends Indicator {
    private static final float WIDTH = 0.1f;
    private static final float LENGTH = 0.35f;
    public static final float OFFSET = 0.001f;
    public static final Comparator<Needle> SORTING_COMPARATOR = (t1, t2) -> t1.equals(t2) ? 0 : -Double.compare(t1.getTargetLocation().getDistance(), t2.getTargetLocation().getDistance());

    public Needle(ColorARGB color, TargetLocation location) {
        super(color, location);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(CommonMath.Angle angle, double scale) {
        float degrees = (float)angle.getDegrees();
        RenderSystem.rotatef((float)degrees, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.color4f((float)this.getColor().getRed().toFloat(), (float)this.getColor().getGreen().toFloat(), (float)this.getColor().getBlue().toFloat(), (float)this.getColor().getAlpha().toFloat());
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        double sW = (double)0.05f * scale;
        double sL = (double)0.35f * scale;
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_225582_a_(-sW, -sL / 5.0, 0.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
        buf.func_225582_a_(sW, -sL / 5.0, 0.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
        buf.func_225582_a_(sW, sL, 0.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
        buf.func_225582_a_(-sW, sL, 0.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
        tess.func_78381_a();
        RenderSystem.rotatef((float)(-degrees), (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public CommonMath.Angle getAngle(Vect3d startPos, float rotationYaw) {
        Vect3d targetPos = GameWorld.getBlockCenter((BlockPos)this.getTargetLocation().getPos());
        Vect3d delta = startPos.subtract(targetPos);
        return CommonMath.Angle.fromDegrees((double)(rotationYaw - 90.0f - GameMath.arcTan((double)delta.z, (double)delta.x)));
    }
}

