/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.finder;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.client.GameRendering;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.events.ItemRenderEvent;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.mods.adfinders.finder.Arrows;
import com.endertech.minecraft.mods.adfinders.finder.FinderState;
import com.endertech.minecraft.mods.adfinders.finder.Needle;
import com.endertech.minecraft.mods.adfinders.items.Finder;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
@OnlyIn(value=Dist.CLIENT)
public class Renderer {
    @SubscribeEvent
    public static void renderItem(ItemRenderEvent event) {
        FinderState state = Finder.findStateFor(event.itemStack);
        if (state == null) {
            return;
        }
        GameRendering.MeterIndicators.begin((MatrixStack)event.matrixStack, (float)0.08f);
        Entity carrier = state.getCarrier();
        Vect3d startPos = ForgeEntity.getCenterPosition((Entity)carrier);
        float rotationYaw = carrier.field_70177_z;
        if (carrier instanceof LivingEntity) {
            Minecraft mc = Minecraft.func_71410_x();
            if (carrier != mc.field_71439_g || mc.field_71474_y.field_74320_O > 0) {
                rotationYaw = ((LivingEntity)carrier).field_70761_aq;
            }
        }
        double scale = 1.0;
        float offset = 0.0f;
        for (Arrows.Arrow arrow : state.getArrows().values()) {
            if (arrow == null) continue;
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)offset);
            arrow.draw(scale);
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)(-offset));
        }
        offset = 0.001f;
        RenderSystem.translated((double)0.0, (double)0.0, (double)offset);
        for (Needle needle : state.getNeedles()) {
            CommonMath.Angle angle = needle.getAngle(startPos, rotationYaw);
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)offset);
            needle.draw(angle, scale);
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)(-offset));
            offset += 0.001f;
        }
        GameRendering.MeterIndicators.end();
    }
}

