/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.init;

import com.endertech.minecraft.mods.adfinders.finder.Definitions;
import com.endertech.minecraft.mods.adfinders.finder.Ore;
import com.endertech.minecraft.mods.adfinders.init.FinderType;

public class Targets {
    static void init(String modId, Initializer initializer) {
        initializer.init(FinderType.GEM.definitions.forMod(modId), FinderType.METAL.definitions.forMod(modId), FinderType.MINERAL.definitions.forMod(modId));
    }

    public static void initAll() {
        Targets.init("minecraft", new Vanilla());
        Targets.init("extragems", new ExtraGems());
        Targets.init("undergroundbiomes", new UndergroundBiomes());
        Targets.init("silentgems", new SilentGems());
        Targets.init("geolosys", new Geolosys());
        Targets.init("mysticalworld", new MysticalWorld());
        Targets.init("techemistry", new Techemistry());
        Targets.init("simpleores", new SimpleOres());
        Targets.init("gemsplusplus", new GemsPlusPlus());
        Targets.init("silentgear", new SilentGear());
        Targets.init("silents_mechanisms", new SilentsMechanisms());
        Targets.init("mekanism", new Mekanism());
    }

    static class SimpleOres
    implements Initializer {
        SimpleOres() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.withOreSuffix().addOre(Ore.Gems.ONYX.colored(-15132391));
            metals.withOreSuffix().addOres(Ore.Metals.COPPER.colored(-3648247), Ore.Metals.TIN.colored(-4470838), Ore.Metals.MYTHRIL.colored(-13004052), Ore.Metals.ADAMANTIUM.colored(-16745727));
        }
    }

    static class Techemistry
    implements Initializer {
        Techemistry() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            minerals.withOreSuffix().addOres(Ore.Minerals.CARBONATE.colored(-1252946), Ore.Minerals.PHOSPHATE.colored(-9836645), Ore.Minerals.SULFUR.colored(-200960), Ore.Minerals.OXIDE.colored(-4079167), Ore.Minerals.SULFATE.colored(-4730698));
        }
    }

    static class MysticalWorld
    implements Initializer {
        MysticalWorld() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.withOreSuffix().addOres(Ore.Gems.AMETHYST.colored(-2776838));
            metals.withOreSuffix().addOres(Ore.Metals.COPPER.colored(-953046), Ore.Metals.LEAD.colored(-13355709), Ore.Metals.SILVER.colored(-6375738), Ore.Metals.TIN.colored(-7165290)).addOre("quicksilver", Ore.Metals.SILVER.colored(-7627102));
        }
    }

    static class Geolosys
    implements Initializer {
        Geolosys() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.withOreSuffix().addOres(Ore.Gems.LAPIS.colored(-16776961), Ore.Gems.QUARTZ.colored(-5325604), Ore.Gems.KIMBERLITE.colored(-3158065), Ore.Gems.BERYL.colored(-16713053), Ore.Gems.MALACHITE.colored(-12805263), Ore.Gems.AZURITE.colored(-14336402));
            metals.withOreSuffix().addOres(Ore.Metals.HEMATITE.colored(-9884132), Ore.Metals.LIMONITE.colored(-4022950), Ore.Metals.CINNABAR.colored(-7661044), Ore.Metals.GOLD.colored(-10496), Ore.Metals.CASSITERITE.colored(-2962779), Ore.Metals.TEALLITE.colored(-4611696), Ore.Metals.GALENA.colored(-11514018), Ore.Metals.BAUXITE.colored(-5409458), Ore.Metals.PLATINUM.colored(-8091235), Ore.Metals.AUTUNITE.colored(-4596720), Ore.Metals.SPHALERITE.colored(-11977378));
            minerals.withOreSuffix().addOre(Ore.COAL);
        }
    }

    static class SilentGems
    implements Initializer {
        SilentGems() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.withSuffixes("classic", "dark", "light").addOre(new Ore("multi_ore", -1));
            gems.withOreSuffix().addOres(new Ore("chaos", -5004387), new Ore("ender", -11476799)).addOre("green_sapphire", Ore.Gems.SAPPHIRE.colored(-15214305)).addOre("black_diamond", Ore.Gems.DIAMOND.colored(-16777216)).addOre(new Ore("cats_eye", -342978)).addOre("yellow_diamond", Ore.Gems.DIAMOND.colored(-918978)).addOre("rose_quartz", Ore.Gems.QUARTZ.colored(-1481064));
            gems.withOreSuffix().addOres(Ore.Gems.PHOSPHOPHYLLITE.colored(-15214208), Ore.Gems.CARNELIAN.colored(-4517376), Ore.Gems.MORGANITE.colored(-371764), Ore.Gems.SPINEL.colored(-4501504), Ore.Gems.CITRINE.colored(-4493568), Ore.Gems.JASPER.colored(-4481536), Ore.Gems.ZIRCON.colored(-4605184), Ore.Gems.MOLDAVITE.colored(-6636800), Ore.Gems.MALACHITE.colored(-16729279), Ore.Gems.TURQUOISE.colored(-16729186), Ore.Gems.EUCLASE.colored(-16745541), Ore.Gems.BENITOITE.colored(-16769605), Ore.Gems.ALEXANDRITE.colored(-5439301), Ore.Gems.LEPIDOLITE.colored(-4521846), Ore.Gems.AMETRINE.colored(-4521893), Ore.Gems.MOONSTONE.colored(-10395295), Ore.Gems.MALACHITE.colored(-16729279), Ore.Gems.PYROPE.colored(-377244), Ore.Gems.CORAL.colored(-371138), Ore.Gems.SUNSTONE.colored(-362946), Ore.Gems.JADE.colored(-7079362), Ore.Gems.CHRYSOPRASE.colored(-11208130), Ore.Gems.APATITE.colored(-12649772), Ore.Gems.FLUORITE.colored(-12664070), Ore.Gems.KYANITE.colored(-13014299), Ore.Gems.SODALITE.colored(-11453718), Ore.Gems.AMMOLITE.colored(-3787046), Ore.Gems.KUNZITE.colored(-2541898), Ore.Gems.TEKTITE.colored(-9412268), Ore.Gems.PEARL.colored(-7496010), Ore.Gems.RUBY.colored(-2547945), Ore.Gems.GARNET.colored(-2535401), Ore.Gems.TOPAZ.colored(-2526953), Ore.Gems.AMBER.colored(-2514665), Ore.Gems.HELIODOR.colored(-2506473), Ore.Gems.PERIDOT.colored(-7349993), Ore.Gems.BERYL.colored(-15214305), Ore.Gems.INDICOLITE.colored(-15214208), Ore.Gems.AQUAMARINE.colored(-15232598), Ore.Gems.SAPPHIRE.colored(-14871077), Ore.Gems.IOLITE.colored(-10479655), Ore.Gems.AMETHYST.colored(-6088741), Ore.Gems.AGATE.colored(-2549808), Ore.Gems.ONYX.colored(-16777216), Ore.Gems.OPAL.colored(-4737097));
        }
    }

    static class UndergroundBiomes
    implements Initializer {
        UndergroundBiomes() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            String ore = "ore_minecraft";
            String[] prefixes = Definitions.Prefixes.create().add("igneous", ore).add("metamorphic", ore).add("sedimentary", ore).toArray();
            ore = "ore";
            String[] suffixes = Definitions.Suffixes.create().add(ore, "andesite").add(ore, "basalt").add(ore, "black_granite").add(ore, "blueschist").add(ore, "chalk").add(ore, "chert").add(ore, "dacite").add(ore, "dolomite").add(ore, "eclogite").add(ore, "gabbro").add(ore, "gneiss").add(ore, "granite").add(ore, "greenschist").add(ore, "greywacke").add(ore, "komatiite").add(ore, "lignite").add(ore, "limestone").add(ore, "marble").add(ore, "migmatite").add(ore, "quartzite").add(ore, "red_granite").add(ore, "rhyolite").add(ore, "shale").add(ore, "siltstone").add(ore, "soapstone").toArray();
            gems.withPrefixes(prefixes).withSuffixes(suffixes).withMetaAll().addOres(Ore.Gems.DIAMOND.colored(-11866671), Ore.Gems.EMERALD.colored(-16732104), Ore.Gems.LAPIS.colored(-16776961));
            metals.withPrefixes(prefixes).withSuffixes(suffixes).withMetaAll().addOres(Ore.Metals.GOLD.colored(-10496), Ore.Metals.IRON.colored(-2180985));
            minerals.withPrefixes(prefixes).withSuffixes(suffixes).withMetaAll().addOres(Ore.COAL, Ore.Minerals.REDSTONE.colored(-65536));
        }
    }

    static class ExtraGems
    implements Initializer {
        ExtraGems() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.withOreSuffix().addOres(Ore.Gems.RUBY.colored(-2549987), Ore.Gems.SAPPHIRE.colored(-15252007), Ore.Gems.AMETHYST.colored(-6875175), Ore.Gems.TOPAZ.colored(-2510825), Ore.Gems.CRYSTAL.colored(-7810327));
        }
    }

    static class GemsPlusPlus
    implements Initializer {
        GemsPlusPlus() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.withNoDelimiters().withPrefixes("ore", "netherore").addOres(Ore.Gems.RUBY.colored(-3533788), Ore.Gems.SAPPHIRE.colored(-16768648), Ore.Gems.AMETHYST.colored(-13631368), Ore.Gems.TOPAZ.colored(-10662641), new Ore("phoenixite", -766720), Ore.Gems.JADE.colored(-10434028), Ore.Gems.CITRINE.colored(-3495404), Ore.Gems.GARNET.colored(-6025187), Ore.Gems.SPINEL.colored(-3533722), Ore.Gems.ONYX.colored(-15987700), Ore.Gems.AGATE.colored(-15435318), Ore.Gems.MALACHITE.colored(-15414702), Ore.Gems.TOURMALINE.colored(-3533676), Ore.Gems.CHRYSOCOLLA.colored(-15414599), Ore.Gems.JASPER.colored(-5362120), Ore.Gems.SUGILITE.colored(-11796258));
        }
    }

    static class SilentGear
    implements Initializer {
        SilentGear() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            metals.withSuffixes("iron_ore").addOre(new Ore("crimson", -2927504));
        }
    }

    static class SilentsMechanisms
    implements Initializer {
        SilentsMechanisms() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            metals.withOreSuffix().addOres(Ore.Metals.ZINC.colored(-11113380), Ore.Metals.TIN.colored(-7953744), Ore.Metals.NICKEL.colored(-1843297), Ore.Metals.COPPER.colored(-492214), Ore.Metals.BAUXITE.colored(-1726794), Ore.Metals.LEAD.colored(-6385992), Ore.Metals.URANIUM.colored(-7285618), Ore.Metals.PLATINUM.colored(-6832194), Ore.Metals.BISMUTH.colored(-3754036), Ore.Metals.SILVER.colored(-6838593));
        }
    }

    static class Mekanism
    implements Initializer {
        Mekanism() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            metals.withOreSuffix().addOres(Ore.Metals.OSMIUM.colored(-10185235), Ore.Metals.COPPER.colored(-3648247), Ore.Metals.TIN.colored(-4470838));
        }
    }

    static class Vanilla
    implements Initializer {
        Vanilla() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.withOreSuffix().addOres(Ore.Gems.DIAMOND.colored(-11866671), Ore.Gems.EMERALD.colored(-16732104), Ore.Gems.LAPIS.colored(-16776961)).addOre("nether_quartz", Ore.Gems.QUARTZ.colored(-790298));
            metals.withOreSuffix().addOres(Ore.Metals.IRON.colored(-2180985), Ore.Metals.GOLD.colored(-10496));
            minerals.withOreSuffix().addOres(Ore.COAL).withMetaAll().addOre(Ore.Minerals.REDSTONE.colored(-65536));
        }
    }

    static interface Initializer {
        public void init(Definitions var1, Definitions var2, Definitions var3);
    }
}

