/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.common;

import com.endertech.common.CommonMath;
import com.endertech.common.IBounds;

public class IntBounds
implements IBounds<Integer> {
    public final Integer min;
    public final Integer max;

    public IntBounds(Integer bound1, Integer bound2) {
        this.min = Math.min(bound1, bound2);
        this.max = Math.max(bound1, bound2);
    }

    public IntBounds(Integer bound) {
        this(bound, bound);
    }

    @Override
    public boolean encloses(Integer value) {
        return value >= this.min && value <= this.max;
    }

    @Override
    public Integer enclose(Integer value) {
        return CommonMath.Range.enclose(value, this.min, this.max);
    }

    @Override
    public IntBounds enclose(IntBounds bounds) {
        return new IntBounds(this.enclose(bounds.min), this.enclose(bounds.max));
    }

    @Override
    public Integer randomBetween() {
        return CommonMath.Random.between(this.min, this.max);
    }

    @Override
    public Integer approxUp(float factor) {
        return CommonMath.Approx.strictUp(factor, this);
    }

    @Override
    public Integer approxDown(float factor) {
        return CommonMath.Approx.strictDown(factor, this);
    }

    @Override
    public float approxFactor(Integer value) {
        return CommonMath.notZero(this.max - this.min) ? (float)((value - this.min) / (this.max - this.min)) : 0.0f;
    }

    public IntBounds extend(Integer value) {
        return new IntBounds(this.min - value, this.max + value);
    }
}

