/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class ForgeRendering {
    public static ItemModelMesher getMesher() {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a();
    }

    public static void renderItemLayerIn2D(int width, int height, float thickness, float minX, float minY, float maxX, float maxY, float minU, float minV, float maxU, float maxV, double layerOffsetX, double layerOffsetY, double layerOffsetZ) {
        double v;
        double y;
        double u;
        double x;
        int i;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer worldRenderer = tessellator.func_178180_c();
        double x1 = (double)minX + layerOffsetX;
        double x2 = (double)maxX - layerOffsetX;
        double y1 = (double)minY + layerOffsetY;
        double y2 = (double)maxY - layerOffsetY;
        double z1 = 0.0 - layerOffsetZ;
        double z2 = layerOffsetZ - (double)thickness;
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b(x1, y1, z1).func_187315_a((double)minU, (double)minV).func_181675_d();
        worldRenderer.func_181662_b(x2, y1, z1).func_187315_a((double)maxU, (double)minV).func_181675_d();
        worldRenderer.func_181662_b(x2, y2, z1).func_187315_a((double)maxU, (double)maxV).func_181675_d();
        worldRenderer.func_181662_b(x1, y2, z1).func_187315_a((double)minU, (double)maxV).func_181675_d();
        tessellator.func_78381_a();
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b(x1, y2, z2).func_187315_a((double)minU, (double)maxV).func_181675_d();
        worldRenderer.func_181662_b(x2, y2, z2).func_187315_a((double)maxU, (double)maxV).func_181675_d();
        worldRenderer.func_181662_b(x2, y1, z2).func_187315_a((double)maxU, (double)minV).func_181675_d();
        worldRenderer.func_181662_b(x1, y1, z2).func_187315_a((double)minU, (double)minV).func_181675_d();
        tessellator.func_78381_a();
        float halfPixelWidth = 0.5f * (minU - maxU) / (float)width;
        float halfPixelHeight = 0.5f * (minV - maxV) / (float)height;
        GL11.glNormal3f((float)-1.0f, (float)0.0f, (float)0.0f);
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (i = 0; i < width; ++i) {
            x = (float)i / (float)width;
            u = (double)minU + (double)(maxU - minU) * x - (double)halfPixelWidth;
            x = x1 + (double)i * ((double)(maxX - minX) - 2.0 * layerOffsetX) / (double)width;
            worldRenderer.func_181662_b(x, y1, z2).func_187315_a(u, (double)minV).func_181675_d();
            worldRenderer.func_181662_b(x, y1, z1).func_187315_a(u, (double)minV).func_181675_d();
            worldRenderer.func_181662_b(x, y2, z1).func_187315_a(u, (double)maxV).func_181675_d();
            worldRenderer.func_181662_b(x, y2, z2).func_187315_a(u, (double)maxV).func_181675_d();
        }
        tessellator.func_78381_a();
        GL11.glNormal3f((float)1.0f, (float)0.0f, (float)0.0f);
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (i = 0; i < width; ++i) {
            x = (float)i / (float)width;
            u = (double)minU + (double)(maxU - minU) * x - (double)halfPixelWidth;
            x = x1 + (double)((float)i + 1.0f) * ((double)(maxX - minX) - 2.0 * layerOffsetX) / (double)width;
            worldRenderer.func_181662_b(x, y2, z2).func_187315_a(u, (double)maxV).func_181675_d();
            worldRenderer.func_181662_b(x, y2, z1).func_187315_a(u, (double)maxV).func_181675_d();
            worldRenderer.func_181662_b(x, y1, z1).func_187315_a(u, (double)minV).func_181675_d();
            worldRenderer.func_181662_b(x, y1, z2).func_187315_a(u, (double)minV).func_181675_d();
        }
        tessellator.func_78381_a();
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (i = 0; i < height; ++i) {
            y = (float)i / (float)height;
            v = (double)minV + (double)(maxV - minV) * y - (double)halfPixelHeight;
            y = y1 + (double)((float)i + 1.0f) * ((double)(maxY - minY) - 2.0 * layerOffsetY) / (double)height;
            worldRenderer.func_181662_b(x1, y, z1).func_187315_a((double)minU, v).func_181675_d();
            worldRenderer.func_181662_b(x2, y, z1).func_187315_a((double)maxU, v).func_181675_d();
            worldRenderer.func_181662_b(x2, y, z2).func_187315_a((double)maxU, v).func_181675_d();
            worldRenderer.func_181662_b(x1, y, z2).func_187315_a((double)minU, v).func_181675_d();
        }
        tessellator.func_78381_a();
        GL11.glNormal3f((float)0.0f, (float)-1.0f, (float)0.0f);
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (i = 0; i < height; ++i) {
            y = (float)i / (float)height;
            v = (double)minV + (double)(maxV - minV) * y - (double)halfPixelHeight;
            y = y1 + (double)i * ((double)(maxY - minY) - 2.0 * layerOffsetY) / (double)height;
            worldRenderer.func_181662_b(x2, y, z1).func_187315_a((double)maxU, v).func_181675_d();
            worldRenderer.func_181662_b(x1, y, z1).func_187315_a((double)minU, v).func_181675_d();
            worldRenderer.func_181662_b(x1, y, z2).func_187315_a((double)minU, v).func_181675_d();
            worldRenderer.func_181662_b(x2, y, z2).func_187315_a((double)maxU, v).func_181675_d();
        }
        tessellator.func_78381_a();
    }
}

