/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.blocks;

import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.materials.ForgeMaterial;
import com.endertech.minecraft.forge.units.ForgeBlock;
import com.endertech.minecraft.forge.units.IForgeUnit;
import com.endertech.minecraft.forge.units.UnitEnabled;
import com.endertech.minecraft.forge.units.UnitId;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRailPowered;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public abstract class ForgeRail
extends BlockRailBase
implements IForgeUnit {
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    private final ForgeMaterial material;
    private final ForgeMod mod;
    private final ForgeConfig config;
    private final UnitEnabled unitEnabled;
    private final UnitId id;
    private final float maxSpeed;
    private final int signalMaxDistance;
    private final int metaShift;

    public ForgeRail(ForgeMod mod, UnitConfig config, ForgeMaterial material, BlockRailBase.EnumRailDirection direction, int metaShift) {
        super(true);
        this.material = material;
        this.mod = mod;
        this.id = this.createId(mod.getId(), material.getName());
        this.config = config;
        this.unitEnabled = new UnitEnabled(config, this.getConfigCategory(), true);
        this.maxSpeed = material.getStrength();
        this.signalMaxDistance = ForgeBounds.RAIL_SIGNAL_DISTANCE.getIntBounds().approxUp(this.getMaterial().getMagicability());
        this.metaShift = metaShift;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(this.func_176560_l(), (Comparable)direction).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.func_149663_c(this.getId().getRegName());
        this.getMod().getRegistrator().addUnit(this);
    }

    public static Posture getPosture(BlockRailBase.EnumRailDirection direction) {
        switch (direction) {
            case NORTH_SOUTH: 
            case ASCENDING_NORTH: 
            case ASCENDING_SOUTH: {
                return Posture.LONGWISE;
            }
            case EAST_WEST: 
            case ASCENDING_EAST: 
            case ASCENDING_WEST: {
                return Posture.LATERAL;
            }
        }
        return Posture.CURVED;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.func_176560_l(), POWERED});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.func_177016_a((int)((meta & 7) + this.metaShift))).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((BlockRailBase.EnumRailDirection)state.func_177229_b(this.func_176560_l())).func_177015_a() - this.metaShift;
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    public float getRailMaxSpeed(World world, EntityMinecart cart, BlockPos pos) {
        return this.maxSpeed;
    }

    @Override
    public boolean isReadyToRegister() {
        return true;
    }

    @Override
    public ForgeConfig getConfig() {
        return this.config;
    }

    @Override
    public UnitId getId() {
        return this.id;
    }

    @Override
    public ForgeMod getMod() {
        return this.mod;
    }

    @Override
    public boolean isEnabled() {
        return this.unitEnabled.isEnabled();
    }

    @Override
    public boolean isRegistered() {
        return ForgeBlock.isRegistered((Block)this);
    }

    @Override
    public void onInit() {
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        tooltip.add(ChatFormatting.YELLOW + "Max Speed: " + this.getMaxSpeed());
        tooltip.add(ChatFormatting.RED + "Signal Max Distance: " + this.getSignalMaxDistance());
        super.addInformation(stack, player, tooltip, advanced);
    }

    public ForgeMaterial getMaterial() {
        return this.material;
    }

    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    public int getSignalMaxDistance() {
        return this.signalMaxDistance;
    }

    protected static BlockPos nextPosition(BlockPos pos, BlockRailBase.EnumRailDirection direction, boolean forward) {
        switch (direction) {
            case NORTH_SOUTH: {
                return forward ? pos.func_177968_d() : pos.func_177978_c();
            }
            case EAST_WEST: {
                return forward ? pos.func_177974_f() : pos.func_177976_e();
            }
            case ASCENDING_EAST: {
                return forward ? pos.func_177974_f().func_177984_a() : pos.func_177976_e();
            }
            case ASCENDING_WEST: {
                return forward ? pos.func_177974_f() : pos.func_177976_e().func_177984_a();
            }
            case ASCENDING_NORTH: {
                return forward ? pos.func_177968_d() : pos.func_177978_c().func_177984_a();
            }
            case ASCENDING_SOUTH: {
                return forward ? pos.func_177968_d().func_177984_a() : pos.func_177978_c();
            }
            case NORTH_EAST: {
                return forward ? pos.func_177974_f() : pos.func_177978_c();
            }
            case NORTH_WEST: {
                return forward ? pos.func_177976_e() : pos.func_177978_c();
            }
            case SOUTH_EAST: {
                return forward ? pos.func_177974_f() : pos.func_177968_d();
            }
            case SOUTH_WEST: {
                return forward ? pos.func_177976_e() : pos.func_177968_d();
            }
        }
        return pos;
    }

    protected boolean findPowerSource(World world, BlockPos pos, boolean forward, int distance) {
        BlockPos vec;
        EnumFacing checkSide;
        BlockRailBase.EnumRailDirection direction;
        BlockPos checkPos;
        if (distance > this.getSignalMaxDistance()) {
            return false;
        }
        if (world.func_175640_z(pos)) {
            return true;
        }
        IBlockState state = world.func_180495_p(pos);
        if (ForgeRail.func_176563_d((IBlockState)state) && this.isRailWithConnectableSide(world, checkPos = ForgeRail.nextPosition(pos, direction = ForgeRail.getDirection(state), forward), checkSide = EnumFacing.func_176737_a((float)(vec = checkPos.func_177973_b((Vec3i)pos)).func_177958_n(), (float)0.0f, (float)vec.func_177952_p()).func_176734_d()) && ForgeRail.isPoweredRail(world, checkPos)) {
            return this.findPowerSource(world, checkPos, forward, distance + 1);
        }
        return false;
    }

    public static boolean isConnectableSide(BlockRailBase.EnumRailDirection direction, EnumFacing side) {
        switch (ForgeRail.getPosture(direction)) {
            case LONGWISE: {
                return side == EnumFacing.NORTH || side == EnumFacing.SOUTH;
            }
            case LATERAL: {
                return side == EnumFacing.WEST || side == EnumFacing.EAST;
            }
            case CURVED: {
                switch (direction) {
                    case NORTH_WEST: {
                        return side == EnumFacing.NORTH || side == EnumFacing.WEST;
                    }
                    case NORTH_EAST: {
                        return side == EnumFacing.NORTH || side == EnumFacing.EAST;
                    }
                    case SOUTH_EAST: {
                        return side == EnumFacing.SOUTH || side == EnumFacing.EAST;
                    }
                    case SOUTH_WEST: {
                        return side == EnumFacing.SOUTH || side == EnumFacing.WEST;
                    }
                }
            }
        }
        return false;
    }

    protected static BlockRailBase.EnumRailDirection getDirection(IBlockState state) {
        BlockRailBase block = (BlockRailBase)state.func_177230_c();
        return (BlockRailBase.EnumRailDirection)state.func_177229_b(block.func_176560_l());
    }

    protected static boolean isPoweredRail(World world, BlockPos pos) {
        return ForgeRail.isPoweredRail(world.func_180495_p(pos));
    }

    protected static boolean isPoweredRail(IBlockState state) {
        if (state.func_177230_c() instanceof ForgeRail) {
            return (Boolean)state.func_177229_b((IProperty)POWERED);
        }
        if (state.func_177230_c() instanceof BlockRailPowered) {
            return (Boolean)state.func_177229_b((IProperty)BlockRailPowered.field_176569_M);
        }
        return false;
    }

    protected boolean isRailWithConnectableSide(World world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        return ForgeRail.func_176563_d((IBlockState)state) && ForgeRail.isConnectableSide(ForgeRail.getDirection(state), side);
    }

    protected IBlockState func_176564_a(World world, BlockPos pos, IBlockState state, boolean updateBlockState) {
        if (this.isClientSide(world)) {
            return state;
        }
        BlockRailBase.EnumRailDirection bestDirection = ForgeRail.getDirection(state);
        int maxFoundConnections = 0;
        for (BlockRailBase.EnumRailDirection direction : this.func_176560_l().func_177700_c()) {
            int connections = 0;
            for (EnumFacing side : EnumFacing.field_176754_o) {
                if (!ForgeRail.isConnectableSide(direction, side)) continue;
                BlockPos checkPos = pos.func_177972_a(side);
                if (direction.func_177018_c()) {
                    checkPos = checkPos.func_177984_a();
                }
                if (!this.isRailWithConnectableSide(world, checkPos, side.func_176734_d())) continue;
                ++connections;
            }
            if (connections <= maxFoundConnections) continue;
            maxFoundConnections = connections;
            bestDirection = direction;
        }
        IBlockState newState = state.func_177226_a(this.func_176560_l(), (Comparable)bestDirection);
        if (updateBlockState || state != newState) {
            world.func_175656_a(pos, newState);
        }
        return newState;
    }

    protected void func_189541_b(IBlockState state, World world, BlockPos pos, Block block) {
        boolean powered;
        boolean bl = powered = this.findPowerSource(world, pos, true, 0) || this.findPowerSource(world, pos, false, 0);
        if (powered != (Boolean)state.func_177229_b((IProperty)POWERED)) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(powered)), 3);
            world.func_175685_c(pos.func_177977_b(), (Block)this);
            if (((BlockRailBase.EnumRailDirection)state.func_177229_b(this.func_176560_l())).func_177018_c()) {
                world.func_175685_c(pos.func_177984_a(), (Block)this);
            }
        }
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rotation) {
        BlockRailBase.EnumRailDirection direction = (BlockRailBase.EnumRailDirection)state.func_177229_b(this.func_176560_l());
        switch (rotation) {
            case CLOCKWISE_180: {
                switch (direction) {
                    case ASCENDING_EAST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_EAST);
                    }
                    case ASCENDING_NORTH: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.NORTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.NORTH_EAST);
                    }
                    case NORTH_WEST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.SOUTH_EAST);
                    }
                    case NORTH_EAST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.SOUTH_WEST);
                    }
                }
                return state;
            }
            case COUNTERCLOCKWISE_90: {
                switch (direction) {
                    case NORTH_SOUTH: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.NORTH_SOUTH);
                    }
                    case ASCENDING_EAST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_NORTH);
                    }
                    case ASCENDING_WEST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_SOUTH);
                    }
                    case ASCENDING_NORTH: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_WEST);
                    }
                    case ASCENDING_SOUTH: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.NORTH_WEST);
                    }
                }
            }
            case CLOCKWISE_90: {
                switch (direction) {
                    case NORTH_SOUTH: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.NORTH_SOUTH);
                    }
                    case ASCENDING_EAST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_SOUTH);
                    }
                    case ASCENDING_WEST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_NORTH);
                    }
                    case ASCENDING_NORTH: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_EAST);
                    }
                    case ASCENDING_SOUTH: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_WEST);
                    }
                    case SOUTH_EAST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.NORTH_EAST);
                    }
                    case NORTH_EAST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.SOUTH_EAST);
                    }
                }
            }
        }
        return state;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        BlockRailBase.EnumRailDirection direction = (BlockRailBase.EnumRailDirection)state.func_177229_b(this.func_176560_l());
        block0 : switch (mirror) {
            case LEFT_RIGHT: {
                switch (direction) {
                    case ASCENDING_NORTH: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.SOUTH_EAST);
                    }
                }
                return state;
            }
            case FRONT_BACK: {
                switch (direction) {
                    case ASCENDING_EAST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.ASCENDING_EAST);
                    }
                    default: {
                        break block0;
                    }
                    case SOUTH_EAST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.NORTH_EAST);
                    }
                    case NORTH_EAST: 
                }
                return state.func_177226_a(this.func_176560_l(), (Comparable)BlockRailBase.EnumRailDirection.NORTH_WEST);
            }
        }
        return state;
    }

    public static enum Posture {
        LONGWISE,
        LATERAL,
        CURVED;

    }
}

