/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.materials;

import com.endertech.common.Args;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.economy.IValuable;
import com.endertech.minecraft.forge.units.ForgeItem;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ForgeMaterial
extends ForgeItem
implements IValuable {
    public static final int DURABILITY_FACTOR = 250;
    private final String name;
    private final float strength;
    private final float heaviness;
    private final float frequency;
    private final float magicability;
    private final ColorARGB color;

    public ForgeMaterial(ForgeMod mod, UnitConfig config, String name, float strength, float heaviness, float frequency, float magicability, ColorARGB color) {
        super(mod, config, name, CreativeTabs.field_78035_l);
        this.name = name;
        FloatBounds bounds = ForgeBounds.FACTOR.getFloatBounds();
        this.strength = ForgeConfig.getFloat(config, this.getConfigCategory(), "strength", strength, bounds, "Defines how strong the material is. Affects: physical resistance, durability, weapons & tools power etc.");
        this.heaviness = ForgeConfig.getFloat(config, this.getConfigCategory(), "heaviness", heaviness, bounds, "Defines how heavy one gramm of the material is. Affects: damage, speed");
        this.frequency = ForgeConfig.getFloat(config, this.getConfigCategory(), "frequency", frequency, bounds, "Defines how often this material appears in the world. Affects: loot and ore generation.");
        this.magicability = ForgeConfig.getFloat(config, this.getConfigCategory(), "magicability", magicability, bounds, "Defines how magical the material is. Affects: enchantability, magic resistance.");
        this.color = ForgeConfig.getColorARGB(config, this.getConfigCategory(), "color", color, "Defines a color in ARGB (Alpha, Red, Green, Blue) hex format (0xaarrggbb)");
    }

    public static float calculateDamageReduction(float materialStrength) {
        return ForgeBounds.DAMAGE_REDUCTION.getFloatBounds().approxUp(materialStrength).floatValue();
    }

    public static int calculateDurability(float materialStrength) {
        return ForgeBounds.DURABILITY.getIntBounds().approxUp(materialStrength);
    }

    public static int calculateEnchantability(float materialMagicability) {
        return ForgeBounds.ENCHANTABILITY.getIntBounds().approxUp(materialMagicability);
    }

    public static float calculateHardness(float materialStrength) {
        return ForgeBounds.HARDNESS.getFloatBounds().approxUp(materialStrength).floatValue();
    }

    public static float calculateResistance(float materialStrength) {
        return ForgeBounds.RESISTANCE.getFloatBounds().approxUp(materialStrength).floatValue();
    }

    public static float calculateToughness(float materialHeaviness) {
        return ForgeBounds.TOUGHNESS.getFloatBounds().approxUp(materialHeaviness).floatValue();
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        tooltip.add(ChatFormatting.GREEN + "Strength: " + this.getStrength());
        tooltip.add(ChatFormatting.YELLOW + "Heaviness: " + this.getHeaviness());
        tooltip.add(ChatFormatting.LIGHT_PURPLE + "Magicability: " + this.getMagicability());
        super.func_77624_a(stack, playerIn, tooltip, advanced);
    }

    @Override
    public String toString() {
        return ForgeMaterial.class.getSimpleName() + Args.group(Args.get("strength", Float.valueOf(this.getStrength())), Args.get("heaviness", Float.valueOf(this.getHeaviness())), Args.get("frequency", Float.valueOf(this.getFrequency())), Args.get("magicability", Float.valueOf(this.getMagicability()))) + Args.extend(super.toString());
    }

    public String getName() {
        return this.name;
    }

    public float getStrength() {
        return this.strength;
    }

    public float getHeaviness() {
        return this.heaviness;
    }

    public float getFrequency() {
        return this.frequency;
    }

    public float getMagicability() {
        return this.magicability;
    }

    public ColorARGB getColor() {
        return this.color;
    }

    @Override
    public float getWorthness() {
        return this.getStrength() * 0.3f + ForgeBounds.invertFactor(this.getHeaviness()) * 0.1f + ForgeBounds.invertFactor(this.getFrequency()) * 0.4f + this.getMagicability() * 0.2f;
    }
}

