/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.shot;

import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.ForgeLocating;
import com.endertech.minecraft.forge.ForgeRendering;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Rotation;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adhooks.Rope;
import com.endertech.minecraft.mods.adhooks.init.HookType;
import com.endertech.minecraft.mods.adhooks.shot.HookShot;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class HookShotRender
extends Render<HookShot> {
    public HookShotRender(RenderManager renderManager) {
        super(renderManager);
    }

    public ResourceLocation getTextureLocation(HookType hookType, String namePostfix) {
        String name = UnitId.buildRegName((String[])new String[]{hookType.hook.getId().getRegName(), namePostfix});
        return ForgeLocating.itemTexture((String)"adhooks", (String)name, (String[])new String[0]);
    }

    public ResourceLocation getTextureLocation(HookType hookType) {
        return this.getTextureLocation(hookType, "");
    }

    public ResourceLocation getBackTextureLocation(HookType hookType) {
        return this.getTextureLocation(hookType, "back");
    }

    public void renderShot(HookShot hookShot, double x, double y, double z, float yaw, float tickProgress) {
        if (hookShot == null || hookShot.getHookType() == null) {
            return;
        }
        HookType hookType = hookShot.getHookType();
        Rotation shotRotation = hookShot.getRotation(tickProgress);
        float hookThickness = 0.0625f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        GlStateManager.func_179140_f();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)(shotRotation.yaw - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)shotRotation.pitch, (float)0.0f, (float)0.0f, (float)1.0f);
        switch (hookType) {
            case WEB: {
                this.func_110776_a(this.getBackTextureLocation(hookType));
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            default: {
                this.func_110776_a(this.getTextureLocation(hookType));
                GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
        double scale = 0.5;
        GlStateManager.func_179091_B();
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
        switch (hookType) {
            case WEB: {
                GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)(hookThickness / 2.0f));
                break;
            }
            default: {
                GlStateManager.func_179137_b((double)-0.1, (double)-0.9, (double)(hookThickness / 2.0f));
            }
        }
        if (hookType.hook != null) {
            ForgeRendering.renderItemLayerIn2D((int)16, (int)16, (float)hookThickness, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (double)0.0, (double)0.0, (double)0.0);
        }
        GlStateManager.func_179101_C();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    public void renderRope(HookShot hookShot, double x, double y, double z, float rotationYaw, float tickProgress) {
        boolean shooterIsMe;
        if (hookShot == null) {
            return;
        }
        EntityLivingBase shooter = hookShot.getThrower();
        if (shooter == null) {
            return;
        }
        Vect3d launcherOffset = Vect3d.ZERO;
        Rotation shooterRotation = ForgeEntity.getRotation((Entity)shooter, (float)tickProgress);
        boolean bl = shooterIsMe = shooter == Minecraft.func_71410_x().field_71439_g;
        if (shooterIsMe) {
            switch (this.field_76990_c.field_78733_k.field_74320_O) {
                case 1: 
                case 2: {
                    launcherOffset = Vect3d.from((double)-0.1, (double)0.0, (double)0.0);
                    break;
                }
                default: {
                    launcherOffset = Vect3d.from((double)-0.6, (double)-0.6, (double)0.0);
                }
            }
        }
        launcherOffset = launcherOffset.rotateAroundX(-shooterRotation.pitch).rotateAroundY(-shooterRotation.yaw);
        Vect3d launcherPos = hookShot.getLauncherPosition(tickProgress).add(launcherOffset);
        Vect3d hookShotPos = hookShot.getCurPosition(tickProgress);
        Vect3d ropeVec = launcherPos.subtract(hookShotPos);
        HookType hookType = hookShot.getHookType();
        if (hookType.rope != null) {
            Rope rope = hookType.rope;
            float hookStrength = hookType.hook != null ? hookType.hook.strength : 0.0f;
            float tensionForce = hookShot.getTensionForce();
            float tensionFactor = CommonMath.notZero((double)hookStrength) && CommonMath.notZero((double)rope.elasticity) ? tensionForce / hookStrength : 0.0f;
            float ropeWidth = new FloatBounds(Rope.WIDTH_BOUNDS.min, Float.valueOf(shooterIsMe ? rope.width : 4.0f)).approxDown(tensionFactor).floatValue();
            float sagging = hookShot.getSagging();
            Vect3d viewPos = Vect3d.from((double)this.field_76990_c.field_78730_l, (double)this.field_76990_c.field_78731_m, (double)this.field_76990_c.field_78728_n);
            GlStateManager.func_179094_E();
            GlStateManager.func_179090_x();
            GlStateManager.func_179140_f();
            GlStateManager.func_179129_p();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GL11.glEnable((int)2848);
            if (rope.color != null) {
                GlStateManager.func_179124_c((float)rope.color.getRed().toFloat(), (float)rope.color.getGreen().toFloat(), (float)rope.color.getBlue().toFloat());
            }
            Vect3d fromPoint = Vect3d.ZERO;
            for (int i = 1; i <= rope.segmentsAmount; ++i) {
                float f = i;
                rope.getClass();
                float ropeProgress = f / 16.0f;
                float sagHeight = MathHelper.func_76126_a((float)(ropeProgress * (float)Math.PI)) * sagging;
                Vect3d toPoint = Vect3d.from((double)(ropeVec.x * (double)ropeProgress), (double)(ropeVec.y * (double)ropeProgress - (double)sagHeight), (double)(ropeVec.z * (double)ropeProgress));
                float viewDistance = (float)viewPos.distance(hookShotPos.add(toPoint));
                float scale = CommonMath.notZero((double)viewDistance) ? 10.0f / viewDistance : 1.0f;
                float ropeWidthScaled = new FloatBounds(Rope.WIDTH_BOUNDS.min, Float.valueOf(ropeWidth)).approxUp(scale).floatValue();
                GlStateManager.func_187441_d((float)ropeWidthScaled);
                GlStateManager.func_187447_r((int)1);
                GL11.glVertex3d((double)fromPoint.x, (double)fromPoint.y, (double)fromPoint.z);
                GL11.glVertex3d((double)toPoint.x, (double)toPoint.y, (double)toPoint.z);
                GlStateManager.func_187437_J();
                fromPoint = toPoint;
            }
            GL11.glDisable((int)2848);
            GlStateManager.func_179117_G();
            GlStateManager.func_179089_o();
            GlStateManager.func_179145_e();
            GlStateManager.func_179098_w();
            GlStateManager.func_179121_F();
        }
    }

    public void doRender(HookShot hookShot, double x, double y, double z, float yaw, float tickProgress) {
        if (!hookShot.isHookingEntity()) {
            this.renderShot(hookShot, x, y, z, yaw, tickProgress);
        }
        this.renderRope(hookShot, x, y, z, yaw, tickProgress);
        super.func_76986_a((Entity)hookShot, x, y, z, yaw, tickProgress);
    }

    protected ResourceLocation getEntityTexture(HookShot entity) {
        return null;
    }

    public boolean func_188295_H_() {
        return false;
    }
}

