/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge;

import java.util.EnumMap;

public class ForgeString {
    private final EnumMap<Versions, String> map = new EnumMap(Versions.class);

    protected ForgeString(Versions version, String string) {
        this.map.put(version, string);
    }

    public static ForgeString create(String string) {
        return new ForgeString(Versions.DEFAULT, string);
    }

    public ForgeString v10(String string) {
        this.map.put(Versions.V10, string);
        return this;
    }

    public ForgeString v7(String string) {
        this.map.put(Versions.V7, string);
        return this;
    }

    public String toString() {
        for (Versions version : Versions.values()) {
            String result;
            if (!"1.11.2".startsWith(version.prefix) || (result = this.map.get((Object)version)) == null) continue;
            return result;
        }
        return this.map.get((Object)Versions.DEFAULT);
    }

    protected static enum Versions {
        V7("1.7"),
        V10("1.10"),
        DEFAULT("");

        public final String prefix;

        private Versions(String beginsWith) {
            this.prefix = beginsWith;
        }
    }
}

