/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge;

import com.endertech.minecraft.forge.math.ForgeMath;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.units.BlockState;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public final class ForgeWorld {
    public static void explodeBlock(World world, BlockPos pos, @Nullable Entity exploder, float strength, boolean fire) {
        world.func_72885_a(exploder, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), strength, fire, fire);
        world.func_175698_g(pos);
    }

    public static boolean isServerSide(World world) {
        return world != null && !world.field_72995_K;
    }

    public static boolean isClientSide(World world) {
        return world != null && world.field_72995_K;
    }

    @Nullable
    public static Entity findEntity(World world, int id) {
        return world != null ? world.func_73045_a(id) : null;
    }

    public static Block getBlock(World world, BlockPos pos) {
        if (world != null && pos != null) {
            return world.func_180495_p(pos).func_177230_c();
        }
        return Blocks.field_150350_a;
    }

    public static Vect3d getBlockCenter(BlockPos pos) {
        return Vect3d.from(pos).add(ForgeMath.getBBCenter(Block.field_185505_j));
    }

    public static int getBlockMeta(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return ForgeWorld.getBlock(world, pos).func_176201_c(state);
    }

    public static BlockState getBlockState(World world, BlockPos pos) {
        return BlockState.from(world.func_180495_p(pos));
    }

    public static Chunk getChunk(World world, ChunkPos pos) {
        return world.func_72964_e(pos.field_77276_a, pos.field_77275_b);
    }

    public static boolean isAirBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return ForgeWorld.isAirBlock(state);
    }

    public static boolean isAirBlock(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150350_a;
    }

    public static boolean isVerticalOpaque(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.isSideSolid((IBlockAccess)world, pos, EnumFacing.UP) && state.isSideSolid((IBlockAccess)world, pos, EnumFacing.DOWN);
    }

    public static boolean isHorizOpaque(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.isSideSolid((IBlockAccess)world, pos, EnumFacing.WEST) && state.isSideSolid((IBlockAccess)world, pos, EnumFacing.EAST) && state.isSideSolid((IBlockAccess)world, pos, EnumFacing.SOUTH) && state.isSideSolid((IBlockAccess)world, pos, EnumFacing.NORTH);
    }

    @Nullable
    public static TileEntity getTileEntity(World world, BlockPos pos) {
        return world != null && pos != null ? world.func_175625_s(pos) : null;
    }

    public static void spawnParticle(World world, EnumParticleTypes type, Vect3d pos, Vect3d motion) {
        if (world != null) {
            world.func_175688_a(type, pos.x, pos.y, pos.z, motion.x, motion.y, motion.z, new int[0]);
        }
    }

    @Nullable
    @Deprecated
    public static BlockPos findAroundInHorizPlane(World world, BlockState state, BlockPos startPos, int maxRadius) {
        BlockPos pos = startPos;
        int radius = 1;
        int turnsCount = 0;
        while (radius <= maxRadius) {
            for (EnumFacing facing : Position.CLOCKWISE_HORIZONTALS) {
                if (turnsCount > 1) {
                    ++radius;
                    turnsCount = 0;
                }
                for (int n = 1; n <= radius; ++n) {
                    if (!ForgeWorld.getBlockState(world, pos = pos.func_177972_a(facing)).matches(state)) continue;
                    return pos;
                }
                ++turnsCount;
            }
        }
        return null;
    }

    @Nullable
    public static RayTraceResult rayTraceBlocks(World world, Vect3d curPos, Vect3d nextPos, boolean includeLiquids) {
        return world.func_72901_a(curPos.toVec3d(), nextPos.toVec3d(), includeLiquids);
    }

    public static class SnowMelter {
        public static boolean isSnow(World world, BlockPos pos) {
            return world.func_180495_p(pos).func_177230_c() == Blocks.field_150431_aC;
        }

        private static BlockPos getSnowTopPos(World world, BlockPos startPos) {
            int offset = 1;
            while (SnowMelter.isSnow(world, startPos.func_177981_b(offset))) {
                ++offset;
            }
            return startPos.func_177981_b(offset - 1);
        }

        public static void meltLayerAt(World world, BlockPos pos) {
            if (SnowMelter.isSnow(world, pos)) {
                BlockPos meltPos = SnowMelter.getSnowTopPos(world, pos);
                IBlockState state = world.func_180495_p(meltPos);
                int layersAmount = (Integer)state.func_177229_b((IProperty)BlockSnow.field_176315_a);
                if (layersAmount > 1) {
                    world.func_175656_a(meltPos, state.func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(layersAmount - 1)));
                } else {
                    world.func_175698_g(meltPos);
                }
            }
        }
    }

    public static class Position {
        public static final EnumFacing[] CLOCKWISE_HORIZONTALS = new EnumFacing[]{EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.NORTH};

        public static List<BlockPos> getAroundHoriz(BlockPos startPos, boolean includeCorners) {
            return Position.getAroundHoriz(startPos, 1, includeCorners);
        }

        public static List<BlockPos> getAroundHoriz(BlockPos startPos, int radius, boolean includeCorners) {
            ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
            posList.add(startPos.func_177985_f(radius));
            posList.add(startPos.func_177965_g(radius));
            posList.add(startPos.func_177964_d(radius));
            posList.add(startPos.func_177970_e(radius));
            if (includeCorners) {
                posList.add(startPos.func_177985_f(radius).func_177964_d(radius));
                posList.add(startPos.func_177985_f(radius).func_177970_e(radius));
                posList.add(startPos.func_177965_g(radius).func_177964_d(radius));
                posList.add(startPos.func_177965_g(radius).func_177970_e(radius));
            }
            return posList;
        }

        public static List<BlockPos> getAroundSphere(BlockPos startPos, boolean includeCorners) {
            return Position.getAroundSphere(startPos, 1, includeCorners);
        }

        public static List<BlockPos> getAroundSphere(BlockPos startPos, int radius, boolean includeCorners) {
            ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
            for (BlockPos vertPos : new BlockPos[]{startPos.func_177984_a(), startPos, startPos.func_177977_b()}) {
                posList.addAll(Position.getAroundHoriz(vertPos, radius, includeCorners));
            }
            return posList;
        }

        public static double getDistance(BlockPos posA, BlockPos posB) {
            return Vect3d.distance(Vect3d.from(posA), Vect3d.from(posB));
        }

        public static BlockPos getTopForBlock(World world, Block block, BlockPos startPos) {
            int offset = 1;
            while (world.func_180495_p(startPos.func_177981_b(offset)).func_177230_c() == block) {
                ++offset;
            }
            return startPos.func_177981_b(offset - 1);
        }
    }
}

