/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.coremod;

import com.endertech.common.Args;
import com.endertech.minecraft.forge.coremod.InstructList;
import com.endertech.minecraft.forge.coremod.names.ClassName;
import com.endertech.minecraft.forge.coremod.signatures.MethodSignature;
import java.util.ListIterator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class ForgeClassTransformer
implements IClassTransformer {
    private void logInfo(String msg, Object ... params) {
        String loggerName = this.getClass().getSimpleName();
        LogManager.getLogger((String)loggerName).info(msg, params);
    }

    public ClassNode getClassNode(byte[] basicClass) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        return node;
    }

    public byte[] getByteCode(ClassNode classNode) {
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    protected abstract MethodSignature getTarget();

    protected abstract boolean isProperNode(MethodInsnNode var1);

    protected abstract boolean shouldSearchNextNode(MethodInsnNode var1);

    protected abstract void injectInstructions(InstructList var1);

    private byte[] transformClass(byte[] classByteCode) {
        this.logInfo("Transforming class: {}", this.getTarget().className);
        ClassNode classNode = this.getClassNode(classByteCode);
        boolean classTransformed = false;
        for (MethodNode methodNode : classNode.methods) {
            boolean methodTransformed;
            if (!this.getTarget().complyWith(methodNode) || !(methodTransformed = this.transformMethod(methodNode))) continue;
            classTransformed = true;
        }
        this.logInfo("Class transformation result: {}", classTransformed);
        return classTransformed ? this.getByteCode(classNode) : classByteCode;
    }

    private boolean transformMethod(MethodNode methodNode) {
        this.logInfo("\ttransforming method: {}", this.getTarget().name);
        ListIterator iterator = methodNode.instructions.iterator();
        boolean methodTransformed = false;
        while (iterator.hasNext()) {
            MethodInsnNode instructNode;
            AbstractInsnNode node = (AbstractInsnNode)iterator.next();
            if (!(node instanceof MethodInsnNode) || !this.isProperNode(instructNode = (MethodInsnNode)node)) continue;
            this.logInfo("\t\tfound method instruction node: {}", instructNode.getClass().getSimpleName() + Args.group(Args.get("opcode", instructNode.getOpcode()), Args.get("owner", instructNode.owner), Args.get("name", instructNode.name), Args.get("descriptor", instructNode.desc)));
            InstructList instructions = new InstructList(methodNode, instructNode);
            this.injectInstructions(instructions);
            methodTransformed = true;
            if (this.shouldSearchNextNode(instructNode)) continue;
            break;
        }
        this.logInfo("\tmethod transformation result: {}", methodTransformed);
        return methodTransformed;
    }

    public byte[] transform(String obfClassName, String normalClassName, byte[] classByteCode) {
        ClassName targetClassName = this.getTarget().className;
        return targetClassName.java.equals(normalClassName) ? this.transformClass(classByteCode) : classByteCode;
    }
}

