/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.minecraft.forge.units.UnitId;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;

@Immutable
public class BlockState {
    public static final BlockState EMPTY = BlockState.from(null, 0);
    public static final BlockState AIR = BlockState.from(Blocks.field_150350_a.func_176223_P());
    @Nullable
    private final Block block;
    private final int meta;

    protected BlockState(@Nullable Block block, int meta) {
        this.block = block;
        this.meta = meta;
    }

    public static BlockState from(@Nullable Block block, int meta) {
        return new BlockState(block, meta);
    }

    public static BlockState from(IBlockState state) {
        return BlockState.from(state.func_177230_c(), BlockState.getMeta(state));
    }

    public static int getMeta(IBlockState state) {
        return state.func_177230_c().func_176201_c(state);
    }

    @Nullable
    public Block getBlock() {
        return this.block;
    }

    public int getMeta() {
        return this.meta;
    }

    public boolean exists() {
        return this.getBlock() != null;
    }

    public boolean isAir() {
        return this.matches(AIR);
    }

    public boolean matches(IBlockState state) {
        return this.matches(BlockState.from(state));
    }

    public boolean matches(BlockState state) {
        return state.getBlock() == this.getBlock() && UnitId.metasAreMatched(state.getMeta(), this.getMeta());
    }

    public BlockState withMetaAll() {
        return BlockState.from(this.getBlock(), Short.MAX_VALUE);
    }

    public int hashCode() {
        return Objects.hash(this.getBlock(), this.getMeta());
    }

    public boolean equals(Object obj) {
        if (obj instanceof BlockState) {
            BlockState state = (BlockState)obj;
            return state.getBlock() == this.getBlock() && state.getMeta() == this.getMeta();
        }
        return super.equals(obj);
    }

    public String toString() {
        return (this.exists() ? this.getBlock().func_149739_a() : "null") + "@" + this.getMeta();
    }
}

