/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.ForgeWorld;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.materials.CraftingRecipe;
import com.endertech.minecraft.forge.regs.INeedToRegister;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.units.UnitVariant;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IForgeUnit
extends INeedToRegister,
IHaveConfig {
    public static String getStatus(IForgeUnit unit) {
        if (unit != null) {
            if (unit.isEnabled()) {
                if (unit.isReadyToRegister()) {
                    return "OK";
                }
                return "NOT READY";
            }
            return "DISABLED";
        }
        return "unit is NULL!";
    }

    default public UnitId createId(String modId, String name) {
        return UnitId.from(modId, name, this.getClassRegName());
    }

    default public UnitVariant[] createUnitVariants() {
        return new UnitVariant[]{UnitVariant.inventory(this.getId())};
    }

    default public void addCraftingRecipe(ForgeConfig config, String pattern, int amount, String ... components) {
        CraftingRecipe recipe = CraftingRecipe.CreateMain(this.getConfigCategory(), config, pattern, this.getStringId(), amount, components);
        this.getMod().getRegistrator().addCrafting(recipe);
    }

    public static String getClassRegName(Class<?> clazz) {
        return UnitId.dictToRegName(clazz.getSimpleName());
    }

    default public String getClassRegName() {
        return IForgeUnit.getClassRegName(this.getClass());
    }

    default public String getConfigCategory() {
        return this.getId().getDictName();
    }

    default public boolean isServerSide(World world) {
        return ForgeWorld.isServerSide(world);
    }

    default public boolean isClientSide(World world) {
        return ForgeWorld.isClientSide(world);
    }

    public UnitId getId();

    default public String getStringId() {
        return this.getId().toString();
    }

    public ForgeMod getMod();

    public boolean isEnabled();

    public boolean isRegistered();

    public void onInit();

    @SideOnly(value=Side.CLIENT)
    public void onInitClient();

    @SideOnly(value=Side.CLIENT)
    @Nullable
    default public ItemMeshDefinition getItemMeshDefinition() {
        return null;
    }

    public UnitVariant[] getUnitVariants();
}

