/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks;

import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.ForgeKeys;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.messages.ForgeNetMsg;
import com.endertech.minecraft.forge.units.ForgeItem;
import com.endertech.minecraft.forge.units.UnitVariant;
import com.endertech.minecraft.mods.adhooks.Hook;
import com.endertech.minecraft.mods.adhooks.init.HookType;
import com.endertech.minecraft.mods.adhooks.shot.HookShot;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Launcher
extends ForgeItem {
    public static final String TAG_HOOKSHOT_ID = "hookShotId";
    public static final FloatBounds REELING_SPEED_BOUNDS = new FloatBounds(Float.valueOf(0.1f), Float.valueOf(4.0f));
    public static final IntBounds DURABILITY_BOUNDS = new IntBounds(Integer.valueOf(1), Integer.valueOf(1000));
    public static final FloatBounds BOOST_STRENGTH_BOUNDS = new FloatBounds(Float.valueOf(0.0f), Float.valueOf(3.0f));
    public static final int DAMAGE_ON_SHOT = 1;
    private Map<KeyBinding, Boolean> watchedKeys = new ConcurrentHashMap<KeyBinding, Boolean>();
    private Set<ItemStack> queuedShots = new HashSet<ItemStack>();
    public final Hook hook;
    public final float reelingSpeed;
    public final int durability;
    public final float boostStrength;
    @SideOnly(value=Side.CLIENT)
    KeyBinding keyBindUserDrop;
    private final ModelResourceLocation model;
    private final ModelResourceLocation attachedModel;

    public Launcher(ForgeMod mod, String name, UnitConfig config, Hook hook, int durability, float reelingSpeed, float boostStrength) {
        super(mod, config, name, CreativeTabs.field_78040_i);
        this.hook = hook;
        this.durability = ForgeConfig.getInt((ForgeConfig)config, (String)this.getConfigCategory(), (String)"durability", (int)durability, (IntBounds)DURABILITY_BOUNDS, (String)"Defines how many times the launcher can be used");
        this.reelingSpeed = ForgeConfig.getFloat((ForgeConfig)config, (String)this.getConfigCategory(), (String)"reelingSpeed", (float)reelingSpeed, (FloatBounds)REELING_SPEED_BOUNDS, (String)"Defines how fast the launcher reels in the rope.");
        this.boostStrength = ForgeConfig.getFloat((ForgeConfig)config, (String)this.getConfigCategory(), (String)"boostStrength", (float)boostStrength, (FloatBounds)BOOST_STRENGTH_BOUNDS, (String)"Defines how high you will be thrown upward when boost is activated");
        assert (hook != null);
        this.func_77625_d(1);
        this.func_77656_e(this.durability);
        this.func_77664_n();
        this.model = this.getId().toModelResLoc_Inventory();
        this.attachedModel = this.getId().withNamePrefix("attached").toModelResLoc_Inventory();
        this.setUnitVariants(new UnitVariant[]{UnitVariant.from((ModelResourceLocation)this.model), UnitVariant.from((ModelResourceLocation)this.attachedModel)});
    }

    public boolean func_82788_x() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack launcher, EntityPlayer player, List<String> tooltip, boolean advanced) {
        GameSettings gs = ForgeKeys.getGameSettings();
        if (ForgeKeys.isDown((KeyBinding)gs.field_151444_V)) {
            tooltip.add(ChatFormatting.RED + "Hook strength: " + this.hook.strength);
            tooltip.add(ChatFormatting.GREEN + "Rope elasticity: " + this.hook.type.rope.elasticity);
            tooltip.add(ChatFormatting.YELLOW + "Rope max length: " + this.hook.type.rope.maxLength);
            tooltip.add(ChatFormatting.AQUA + "Reeling speed: " + this.hook.type.launcher.reelingSpeed);
            tooltip.add(ChatFormatting.BLUE + "Boost up strength: " + this.hook.type.launcher.boostStrength);
        } else if (ForgeKeys.isDown((KeyBinding)gs.field_74311_E)) {
            tooltip.add(ChatFormatting.RED + "Launch: " + ForgeKeys.getName((KeyBinding)gs.field_74312_F));
            tooltip.add(ChatFormatting.GREEN + "Reel / Unhook: " + ForgeKeys.getName((KeyBinding)gs.field_74316_C));
            tooltip.add(ChatFormatting.YELLOW + "Pull: hold " + ForgeKeys.getName((KeyBinding)gs.field_74313_G));
            tooltip.add(ChatFormatting.AQUA + "Loosen: hold " + ForgeKeys.getName((KeyBinding)gs.field_74312_F));
            tooltip.add(ChatFormatting.GOLD + "Boost up: press " + ForgeKeys.getName((KeyBinding)gs.field_74316_C) + " while pulling");
            tooltip.add(ChatFormatting.LIGHT_PURPLE + "Release: hold " + ForgeKeys.getName((KeyBinding)gs.field_74311_E) + " and press " + ForgeKeys.getName((KeyBinding)gs.field_74312_F));
        } else {
            tooltip.add("hold " + ForgeKeys.getName((KeyBinding)gs.field_151444_V) + " for more info");
            tooltip.add("hold " + ForgeKeys.getName((KeyBinding)gs.field_74311_E) + " for control help");
        }
    }

    public static boolean isAttached(ItemStack launcher) {
        return Launcher.stackHasLauncher(launcher) && launcher.func_77942_o() && launcher.func_77978_p().func_74764_b(TAG_HOOKSHOT_ID);
    }

    public static boolean isAttachedToHookShot(ItemStack launcher, HookShot hookShot) {
        return Launcher.isAttached(launcher) && hookShot != null && Launcher.getAttachedHookShotId(launcher) == hookShot.func_145782_y();
    }

    public static int getAttachedHookShotId(ItemStack launcher) {
        if (launcher != null && launcher.func_77942_o()) {
            return launcher.func_77978_p().func_74762_e(TAG_HOOKSHOT_ID);
        }
        return 0;
    }

    public static boolean stackHasLauncher(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof Launcher;
    }

    @Nullable
    public static HookShot findAttachedHookShot(ItemStack launcher, World world) {
        Entity entity;
        if (Launcher.isAttached(launcher) && world != null && (entity = world.func_73045_a(Launcher.getAttachedHookShotId(launcher))) instanceof HookShot) {
            return (HookShot)entity;
        }
        return null;
    }

    @Nullable
    public static ItemStack findAttachedLauncher(InventoryPlayer inventory, HookShot hookShot) {
        if (inventory != null && inventory.field_70462_a != null && hookShot != null) {
            for (ItemStack stack : inventory.field_70462_a) {
                if (!Launcher.isAttachedToHookShot(stack, hookShot)) continue;
                return stack;
            }
        }
        return null;
    }

    public static void attachToHookShot(ItemStack launcher, HookShot hookShot) {
        if (Launcher.stackHasLauncher(launcher) && hookShot != null) {
            Launcher.ensureHasNBT((ItemStack)launcher);
            NBTTagCompound tag = launcher.func_77978_p();
            tag.func_74768_a(TAG_HOOKSHOT_ID, hookShot.func_145782_y());
        }
    }

    public static void unattach(ItemStack launcher) {
        if (Launcher.stackHasLauncher(launcher) && Launcher.hasNBT((ItemStack)launcher)) {
            launcher.func_77978_p().func_82580_o(TAG_HOOKSHOT_ID);
        }
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        Launcher.ensureHasNBT((ItemStack)stack);
    }

    public boolean onDroppedByPlayer(ItemStack launcher, EntityPlayer player) {
        if (ForgeEntity.isServerSide((Entity)player)) {
            HookShot hookShot = Launcher.findAttachedHookShot(launcher, player.field_70170_p);
            if (hookShot != null) {
                return false;
            }
            if (player.func_184587_cr()) {
                return false;
            }
        }
        return super.onDroppedByPlayer(launcher, player);
    }

    public boolean onLeftClickEntity(ItemStack launcher, EntityPlayer player, Entity entity) {
        return this.hook != null && this.hook.type != HookType.PUDGE;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public void queueShot(ItemStack launcher) {
        this.queuedShots.add(launcher);
    }

    protected void makeShot(ItemStack launcher, World world, EntityLivingBase shooter) {
        if (this.isServerSide(world) && launcher != null && this.hook != null && this.hook.type != null && Launcher.notBroken((ItemStack)launcher)) {
            HookShot hookShot = new HookShot(world, shooter, this.hook.type);
            world.func_72838_d((Entity)hookShot);
            Launcher.attachToHookShot(launcher, hookShot);
            Launcher.damageItem((int)1, (ItemStack)launcher, (EntityLivingBase)shooter, (boolean)false);
        }
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        return false;
    }

    public boolean func_82789_a(ItemStack launcher, ItemStack material) {
        return material != null && material.func_77973_b() == Items.field_151007_F;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (player != null) {
            player.func_184598_c(hand);
        }
        return super.func_77659_a(world, player, hand);
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @SideOnly(value=Side.CLIENT)
    public void onInitClient() {
        int keyCode = ForgeConfig.getInt((ForgeConfig)this.getConfig(), (String)this.getConfigCategory(), (String)"keyUnhook", (int)45, (IntBounds)ForgeBounds.KEY_CODE.getIntBounds(), (String)"Defines the key code for the Unhook action.\nKey codes can be found at: http://minecraft.gamepedia.com/Key_codes");
        this.getConfig().save();
        this.keyBindUserDrop = new KeyBinding("key.unhook", keyCode, "key.categories.gameplay");
        GameSettings gs = ForgeKeys.getGameSettings();
        this.watchedKeys.put(gs.field_74312_F, false);
        this.watchedKeys.put(gs.field_74313_G, false);
        this.watchedKeys.put(gs.field_74316_C, false);
        this.watchedKeys.put(this.keyBindUserDrop, false);
    }

    @SideOnly(value=Side.CLIENT)
    public ItemMeshDefinition getItemMeshDefinition() {
        ItemMeshDefinition definition = stack -> Launcher.isAttached(stack) ? this.attachedModel : this.model;
        return definition;
    }

    @SideOnly(value=Side.CLIENT)
    public void processPressedKeys() {
        GameSettings gs = ForgeKeys.getGameSettings();
        if (ForgeKeys.affectPlayer()) {
            for (KeyBinding keyBinding : this.watchedKeys.keySet()) {
                KeyPressedMsg.Keys key;
                boolean isKeyDown;
                boolean wasKeyDown = this.watchedKeys.get(keyBinding);
                if (wasKeyDown == (isKeyDown = ForgeKeys.isDown((KeyBinding)keyBinding))) continue;
                if (keyBinding == gs.field_74312_F) {
                    key = KeyPressedMsg.Keys.ATTACK;
                } else if (keyBinding == gs.field_74313_G) {
                    key = KeyPressedMsg.Keys.USE;
                } else {
                    if (keyBinding != gs.field_74316_C && keyBinding != this.keyBindUserDrop) continue;
                    key = KeyPressedMsg.Keys.DROP;
                }
                KeyPressedMsg message = new KeyPressedMsg(key, isKeyDown);
                this.getMod().getRegistrator().networkChannel.sendToServer((IMessage)message);
                this.watchedKeys.put(keyBinding, isKeyDown);
            }
        }
    }

    public void func_77663_a(ItemStack launcher, World world, Entity shooter, int inventorySlot, boolean isCurrentItem) {
        if (this.isClientSide(world) && isCurrentItem) {
            this.processPressedKeys();
        }
        if (this.isServerSide(world) && shooter instanceof EntityLivingBase && this.queuedShots.contains(launcher)) {
            this.makeShot(launcher, world, (EntityLivingBase)shooter);
            this.queuedShots.remove(launcher);
        }
        super.func_77663_a(launcher, world, shooter, inventorySlot, isCurrentItem);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77629_n_() {
        return true;
    }

    public static class KeyPressedMsg
    extends ForgeNetMsg<KeyPressedMsg> {
        public int key = Keys.ATTACK.ordinal();
        public boolean isDown = false;

        public KeyPressedMsg() {
        }

        public KeyPressedMsg(Keys key, boolean isDown) {
            this.key = key.ordinal();
            this.isDown = isDown;
        }

        public IMessage onMessage(KeyPressedMsg message, MessageContext ctx) {
            ItemStack stack;
            World world = this.getWorld(ctx);
            EntityPlayer player = this.getPlayer(ctx);
            if (world != null && player != null && Launcher.stackHasLauncher(stack = player.field_71071_by.func_70448_g())) {
                if (Launcher.isAttached(stack)) {
                    HookShot hookShot = Launcher.findAttachedHookShot(stack, world);
                    if (hookShot != null) {
                        switch (Keys.values()[message.key]) {
                            case ATTACK: {
                                hookShot.setLoosening(message.isDown);
                                break;
                            }
                            case USE: {
                                hookShot.setPulling(message.isDown);
                                break;
                            }
                            case DROP: {
                                hookShot.setBoosting(message.isDown);
                                break;
                            }
                        }
                    } else {
                        Launcher.unattach(stack);
                    }
                } else if (message.key == Keys.ATTACK.ordinal() && message.isDown) {
                    Launcher launcher = (Launcher)stack.func_77973_b();
                    launcher.queueShot(stack);
                }
            }
            return null;
        }

        public static enum Keys {
            ATTACK,
            DROP,
            USE;

        }
    }
}

