/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.init;

import com.endertech.minecraft.forge.ForgeLocating;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.ModConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.materials.CraftingRecipe;
import com.endertech.minecraft.mods.adhooks.Hook;
import com.endertech.minecraft.mods.adhooks.Launcher;
import com.endertech.minecraft.mods.adhooks.init.HookType;
import com.endertech.minecraft.mods.adhooks.shot.HookShot;
import com.endertech.minecraft.mods.adhooks.shot.HookShotRender;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.item.Item;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="adhooks", name="Advanced Hook Launchers", version="1.11.2-2.0.5.0", acceptedMinecraftVersions="[1.11.2]", dependencies="required-after:forgeendertech@[1.11.2-2.2.0.0,)")
public class Main
extends ForgeMod {
    public static final String ID = "adhooks";
    public static final String NAME = "Advanced Hook Launchers";
    @Mod.Instance(value="adhooks")
    public static Main instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.printInitMsg((FMLEvent)event);
        this.setConfig(new ModConfig(this.getId(), event));
        HookType.values();
        this.addWebRecipe();
        this.addHookRecipe(HookType.PUDGE, "011 101 200", new String[]{"steel_ingot", "stick"}, new String[]{"iron_ingot", "stick"});
        this.addHookRecipe(HookType.SPEAR, "001 020 100", new String[]{"steel_ingot", "stick"}, new String[]{"iron_ingot", "stick"});
        this.addHookRecipe(HookType.WEB, "001 020 200", new String[]{"web", "string"}, new String[]{"web", "string"});
        this.addLauncherRecipe(HookType.PUDGE, "dye:1", "dye:1", "harden_leather", "leather");
        this.addLauncherRecipe(HookType.SPEAR, "dye:8", "dye:0", "steel_ingot", "iron_ingot");
        this.addLauncherRecipe(HookType.WEB, "dye:8", "dye:12", "mithril_ingot", "obsidian");
        super.preInit(event);
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void preInitClient(FMLPreInitializationEvent event) {
        this.getRegistrator().registerRenderingHandler(HookShot.class, (IRenderFactory)new HookShotRender.Factory());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.printInitMsg((FMLEvent)event);
        this.getRegistrator().registerNetMessageForServer(Launcher.KeyPressedMsg.class, (IMessageHandler)new Launcher.KeyPressedMsg());
        this.getRegistrator().registerEntity((ForgeMod)this, HookShot.class, HookShot.RENDER_DISTANCE, 20, true);
        super.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.printInitMsg((FMLEvent)event);
        super.postInit(event);
    }

    @Mod.EventHandler
    public void onMissingMappings(FMLMissingMappingsEvent event) {
        HashMap<String, Hook> hookMap = new HashMap<String, Hook>();
        HashMap<String, Launcher> launcherMap = new HashMap<String, Launcher>();
        for (HookType element : HookType.values()) {
            hookMap.put("hook" + element.name().toLowerCase(Locale.ROOT), element.hook);
            launcherMap.put("hooklauncher" + element.name().toLowerCase(Locale.ROOT), element.launcher);
        }
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            String oldName = mapping.resourceLocation.func_110623_a().toLowerCase(Locale.ROOT);
            if (mapping.type != GameRegistry.Type.ITEM) continue;
            Hook hook = (Hook)((Object)hookMap.get(oldName));
            Launcher launcher = (Launcher)((Object)launcherMap.get(oldName));
            if (hook != null) {
                mapping.remap((Item)hook);
            }
            if (launcher == null) continue;
            mapping.remap((Item)launcher);
        }
    }

    public String getId() {
        return ID;
    }

    private void addWebRecipe() {
        String pattern = "101 010 101";
        String web = "web";
        UnitConfig config = new UnitConfig(this.getConfig().getConfigDir(), ForgeLocating.Folders.items.name(), HookType.WEB.name());
        CraftingRecipe main = CraftingRecipe.CreateMain((ForgeConfig)config, (String)pattern, (String)web, (int)1, (String[])new String[]{"string"});
        CraftingRecipe reserve = CraftingRecipe.CreateReserve((ForgeConfig)config, (String)pattern, (String)web, (int)1, (String[])new String[]{"string"});
        this.getRegistrator().addCrafting(main, reserve);
        config.save();
    }

    private void addHookRecipe(HookType hookType, String pattern, String[] mainComponents, String[] reserveComponents) {
        int amount = 1;
        Hook hook = hookType.hook;
        ForgeConfig config = hook.getConfig();
        String id = hook.getStringId();
        CraftingRecipe main = CraftingRecipe.CreateMain((ForgeConfig)config, (String)pattern, (String)id, (int)amount, (String[])mainComponents);
        CraftingRecipe reserve = CraftingRecipe.CreateReserve((ForgeConfig)config, (String)pattern, (String)id, (int)amount, (String[])reserveComponents);
        this.getRegistrator().addCrafting(main, reserve);
        config.save();
    }

    private void addLauncherRecipe(HookType hookType, String mainDye, String reserveDye, String mainMaterial, String reserveMaterial) {
        ForgeConfig config = hookType.launcher.getConfig();
        String pattern = "123 242 521";
        String launcher = hookType.launcher.getStringId();
        String hook = hookType.hook.getStringId();
        String reel = "string";
        String button = "wooden_button";
        CraftingRecipe main = CraftingRecipe.CreateMain((ForgeConfig)config, (String)pattern, (String)launcher, (int)1, (String[])new String[]{mainDye, mainMaterial, hook, reel, button});
        CraftingRecipe reserve = CraftingRecipe.CreateReserve((ForgeConfig)config, (String)pattern, (String)launcher, (int)1, (String[])new String[]{reserveDye, reserveMaterial, hook, reel, button});
        this.getRegistrator().addCrafting(main, reserve);
        config.save();
    }

    public String getName() {
        return NAME;
    }

    public ForgeMod getInstance() {
        return instance;
    }
}

