/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.shot;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.ForgeMain;
import com.endertech.minecraft.forge.ForgeWorld;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Combustion;
import com.endertech.minecraft.forge.math.ForgeMath;
import com.endertech.minecraft.forge.math.Rotation;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.messages.MotionMsg;
import com.endertech.minecraft.mods.adhooks.Hook;
import com.endertech.minecraft.mods.adhooks.Launcher;
import com.endertech.minecraft.mods.adhooks.Rope;
import com.endertech.minecraft.mods.adhooks.init.HookType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HookShot
extends ForgeEntity
implements IThrowableEntity,
IProjectile {
    public static final float GRAVITY_VELOCITY = 0.005f;
    public static final int RENDER_DISTANCE = Rope.LENGTH_BOUNDS.max;
    private float shootStrength = 1.5f;
    private float size = 0.6f;
    private Map<Entity, Vect3d> lastAddedMotionsList = new ConcurrentHashMap<Entity, Vect3d>();
    private EnumFacing hitSide = null;
    private Combustion combustion = new Combustion();

    public HookShot(World world) {
        super(world);
        this.func_70105_a(this.size, this.size);
        this.field_70158_ak = true;
    }

    public HookShot(World world, EntityLivingBase shooter, HookType hookType) {
        this(world);
        this.field_70180_af.func_187227_b(WatchedInt.SHOOTER_ID.key, (Object)ForgeEntity.getId((Entity)shooter));
        this.setHookType(hookType);
        this.func_70012_b(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v, shooter.field_70177_z, shooter.field_70125_A);
        this.field_70165_t -= (double)(ForgeMath.cos((float)this.field_70177_z) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(ForgeMath.sin((float)this.field_70177_z) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = -ForgeMath.sin((float)this.field_70177_z) * ForgeMath.cos((float)this.field_70125_A);
        this.field_70179_y = ForgeMath.cos((float)this.field_70177_z) * ForgeMath.cos((float)this.field_70125_A);
        this.field_70181_x = -ForgeMath.sin((float)this.field_70125_A);
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, this.shootStrength, 1.0f);
        if (world != null && shooter != null) {
            world.func_184148_a((EntityPlayer)null, shooter.field_70165_t, shooter.field_70163_u, shooter.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 1.2f) + 0.5f);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        for (WatchedBool watchedBool : WatchedBool.values()) {
            this.field_70180_af.func_187214_a(watchedBool.key, (Object)false);
        }
        for (Enum enum_ : WatchedInt.values()) {
            this.field_70180_af.func_187214_a(((WatchedInt)enum_).key, (Object)0);
        }
        for (Enum enum_ : WatchedFloat.values()) {
            this.field_70180_af.func_187214_a(((WatchedFloat)enum_).key, (Object)Float.valueOf(0.0f));
        }
        this.setState(State.SHOOTING);
    }

    public boolean isLoosening() {
        return (Boolean)this.field_70180_af.func_187225_a(WatchedBool.LOOSENING.key);
    }

    public void setLoosening(boolean loosening) {
        this.field_70180_af.func_187227_b(WatchedBool.LOOSENING.key, (Object)loosening);
    }

    public boolean isPulling() {
        return (Boolean)this.field_70180_af.func_187225_a(WatchedBool.PULLING.key);
    }

    public void setPulling(boolean pulling) {
        this.field_70180_af.func_187227_b(WatchedBool.PULLING.key, (Object)pulling);
    }

    public boolean isBoosting() {
        return (Boolean)this.field_70180_af.func_187225_a(WatchedBool.BOOSTING.key);
    }

    public void setBoosting(boolean boosting) {
        this.field_70180_af.func_187227_b(WatchedBool.BOOSTING.key, (Object)boosting);
    }

    public State getPrevState() {
        int i = (Integer)this.field_70180_af.func_187225_a(WatchedInt.PREV_STATE.key);
        return State.values()[i];
    }

    public State getState() {
        int i = (Integer)this.field_70180_af.func_187225_a(WatchedInt.STATE.key);
        return State.values()[i];
    }

    public void setState(State state) {
        State prevState = this.getState();
        if (state != prevState) {
            this.field_70180_af.func_187227_b(WatchedInt.PREV_STATE.key, (Object)prevState.ordinal());
            this.field_70180_af.func_187227_b(WatchedInt.STATE.key, (Object)state.ordinal());
        }
    }

    public float getRopeLength() {
        return ((Float)this.field_70180_af.func_187225_a(WatchedFloat.ROPE_LENGTH.key)).floatValue();
    }

    public void setRopeLength(float ropeLength) {
        this.field_70180_af.func_187227_b(WatchedFloat.ROPE_LENGTH.key, (Object)Float.valueOf(ropeLength));
    }

    public float getSagging() {
        return ((Float)this.field_70180_af.func_187225_a(WatchedFloat.SAGGING.key)).floatValue();
    }

    public void setSagging(float sagging) {
        if (sagging < 0.0f) {
            sagging = 0.0f;
        }
        this.field_70180_af.func_187227_b(WatchedFloat.SAGGING.key, (Object)Float.valueOf(sagging));
    }

    public void setHookType(HookType value) {
        if (value != null) {
            this.field_70180_af.func_187227_b(WatchedInt.HOOK_TYPE.key, (Object)value.ordinal());
        }
    }

    public HookType getHookType() {
        int ordinal = (Integer)this.field_70180_af.func_187225_a(WatchedInt.HOOK_TYPE.key);
        return HookType.values()[ordinal];
    }

    public boolean canHookOnReeling() {
        return this.getHookType() == HookType.PUDGE;
    }

    public boolean canHookBlocks() {
        return this.getHookType() != HookType.PUDGE;
    }

    public boolean canHookEntities() {
        return true;
    }

    protected Vect3d getHitPosition() {
        return Vect3d.from((double)((Float)this.field_70180_af.func_187225_a(WatchedFloat.HIT_X.key)).floatValue(), (double)((Float)this.field_70180_af.func_187225_a(WatchedFloat.HIT_Y.key)).floatValue(), (double)((Float)this.field_70180_af.func_187225_a(WatchedFloat.HIT_Z.key)).floatValue());
    }

    public Vect3d getLauncherPosition() {
        return HookShot.getCenterPosition((Entity)this.getThrower());
    }

    public Vect3d getLauncherPosition(float tickProgress) {
        return HookShot.getCenterPosition((Entity)this.getThrower(), (float)tickProgress);
    }

    public void setHitPosition(Vect3d hitPosition) {
        if (hitPosition != null) {
            this.field_70180_af.func_187227_b(WatchedFloat.HIT_X.key, (Object)Float.valueOf((float)hitPosition.x));
            this.field_70180_af.func_187227_b(WatchedFloat.HIT_Y.key, (Object)Float.valueOf((float)hitPosition.y));
            this.field_70180_af.func_187227_b(WatchedFloat.HIT_Z.key, (Object)Float.valueOf((float)hitPosition.z));
        }
    }

    public boolean isHookingBlock() {
        return this.getState() == State.HOOKING_BLOCK;
    }

    public boolean isHookingEntity() {
        return this.getState() == State.HOOKING_ENTITY;
    }

    public boolean isLauncherInMainHand() {
        ItemStack itemStack = this.getThrower() != null ? this.getThrower().func_184614_ca() : null;
        return itemStack != null && itemStack.func_77973_b() instanceof Launcher && Launcher.isAttachedToHookShot(itemStack, this);
    }

    public BlockPos getHookedBlockPos() {
        return new BlockPos(((Integer)this.field_70180_af.func_187225_a(WatchedInt.HOOKED_BLOCK_X.key)).intValue(), ((Integer)this.field_70180_af.func_187225_a(WatchedInt.HOOKED_BLOCK_Y.key)).intValue(), ((Integer)this.field_70180_af.func_187225_a(WatchedInt.HOOKED_BLOCK_Z.key)).intValue());
    }

    private void setHookedBlockPos(RayTraceResult rayTraceResult) {
        if (rayTraceResult != null && rayTraceResult.func_178782_a() != null) {
            this.field_70180_af.func_187227_b(WatchedInt.HOOKED_BLOCK_X.key, (Object)rayTraceResult.func_178782_a().func_177958_n());
            this.field_70180_af.func_187227_b(WatchedInt.HOOKED_BLOCK_Y.key, (Object)rayTraceResult.func_178782_a().func_177956_o());
            this.field_70180_af.func_187227_b(WatchedInt.HOOKED_BLOCK_Z.key, (Object)rayTraceResult.func_178782_a().func_177952_p());
        }
    }

    private void onTargetHit(RayTraceResult rayTraceResult) {
        if (rayTraceResult == null) {
            return;
        }
        if (this.getState() == State.REELING && !this.canHookOnReeling()) {
            return;
        }
        Vect3d hitPosition = Vect3d.from((Vec3d)rayTraceResult.field_72307_f);
        switch (rayTraceResult.field_72313_a) {
            case BLOCK: {
                if (!this.canHookBlocks()) {
                    this.setState(State.REELING);
                    return;
                }
                this.hitSide = rayTraceResult.field_178784_b;
                this.setHookedBlockPos(rayTraceResult);
                this.setHitPosition(hitPosition);
                this.setState(State.HOOKING_BLOCK);
                break;
            }
            case ENTITY: {
                IEntityMultiPart dragon;
                Entity target = rayTraceResult.field_72308_g;
                if (target instanceof EntityDragonPart && (dragon = ((EntityDragonPart)target).field_70259_a) instanceof Entity) {
                    target = (Entity)dragon;
                }
                if (target == null) break;
                Hook hook = this.getHookType().hook;
                if (hook != null && this.getThrower() != null && hook.damage > 0.0f) {
                    DamageSource damageSource = new EntityDamageSourceIndirect("arrow", (Entity)this, (Entity)this.getThrower()).func_76349_b();
                    target.func_70097_a(damageSource, hook.damage);
                }
                if (!this.canHookEntities()) {
                    this.setState(State.REELING);
                    return;
                }
                this.field_70180_af.func_187227_b(WatchedInt.HOOKED_ENTITY_ID.key, (Object)target.func_145782_y());
                this.setState(State.HOOKING_ENTITY);
                break;
            }
            default: {
                return;
            }
        }
        float ropeLength = (float)(this.getLauncherPosition().distance(hitPosition) + (double)this.getHookType().launcher.reelingSpeed);
        this.setRopeLength(ropeLength);
        this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
    }

    private void updatePhysics() {
        if (!this.isServerSide()) {
            return;
        }
        HookType hookType = this.getHookType();
        EntityLivingBase shooter = this.getThrower();
        if (shooter == null || shooter.field_70128_L || hookType.launcher == null || hookType.hook == null || hookType.rope == null || this.isServerSide() && shooter instanceof EntityPlayer && Launcher.findAttachedLauncher(((EntityPlayer)shooter).field_71071_by, this) == null) {
            this.func_70106_y();
            return;
        }
        State state = this.getState();
        Vect3d launcherPosition = this.getLauncherPosition();
        Vect3d tensionVec = Vect3d.ZERO;
        float tensionForce = 0.0f;
        float hookDistance = this.getHookDistance();
        float ropeMaxLength = hookType.rope.maxLength;
        float ropeLength = this.getRopeLength();
        float ropeMinLength = Math.min(shooter.field_70130_N, shooter.field_70131_O);
        float reelingSpeed = hookType.launcher.reelingSpeed;
        switch (state) {
            case SHOOTING: {
                ropeLength = hookDistance + reelingSpeed;
                if (!(ropeLength > ropeMaxLength)) break;
                state = State.REELING;
                break;
            }
            case REELING: {
                Vect3d motionVec = launcherPosition.subtract(this.getCurPosition()).normalize().scale((double)(reelingSpeed * 3.0f));
                this.setMotion(motionVec);
                float hookNextDistance = (float)launcherPosition.distance(this.getNextPosition());
                ropeLength = hookDistance;
                if (!(ropeLength <= ropeMinLength) && !(hookDistance <= hookNextDistance)) break;
                this.func_70106_y();
                break;
            }
            case HOOKING_BLOCK: 
            case HOOKING_ENTITY: {
                if (!(ropeLength < hookDistance)) break;
                tensionForce = hookType.rope.getTensionForce(ropeLength, hookDistance);
                tensionVec = this.getCurPosition().subtract(launcherPosition).normalize().scale((double)tensionForce);
                if (tensionForce > hookType.hook.strength) {
                    state = State.REELING;
                    break;
                }
                HookShot.setFallDistance((Entity)shooter, (float)0.0f, (boolean)true);
                break;
            }
        }
        switch (state) {
            case HOOKING_BLOCK: {
                this.sendMotion((Entity)shooter, MotionMsg.Type.add, tensionVec, true);
                break;
            }
            case HOOKING_ENTITY: {
                Entity target = this.findHookedEntity();
                if (target == null) break;
                float shooterWeight = HookShot.getWeight((Entity)shooter, (boolean)true) * 1.5f;
                float targetWeight = HookShot.getWeight((Entity)target, (boolean)true);
                float totalWeight = shooterWeight + targetWeight;
                ropeMinLength = (Math.max(shooter.field_70130_N, shooter.field_70131_O) + Math.max(target.field_70130_N, target.field_70131_O)) / 2.0f;
                if (totalWeight == 0.0f) {
                    totalWeight = 1.0f;
                }
                if (ropeLength <= hookDistance) {
                    HookShot.setFallDistance((Entity)target, (float)0.0f, (boolean)true);
                }
                if (hookType == HookType.PUDGE && ropeLength <= ropeMinLength) {
                    this.sendMotion(target, MotionMsg.Type.set, Vect3d.ZERO, true);
                    this.func_70106_y();
                    break;
                }
                Vect3d motionVec = tensionVec.invert().scale((double)(shooterWeight / totalWeight));
                this.sendMotion(target, MotionMsg.Type.add, motionVec, true);
                motionVec = tensionVec.scale((double)(targetWeight / totalWeight));
                this.sendMotion((Entity)shooter, MotionMsg.Type.add, motionVec, true);
                break;
            }
        }
        ropeLength = CommonMath.Range.enclose((float)ropeLength, (float)ropeMinLength, (float)ropeMaxLength);
        this.setRopeLength(ropeLength);
        this.setSagging(ropeLength - hookDistance);
        this.setState(state);
        this.setTensionForce(tensionForce);
    }

    private void setTensionForce(float tensionForce) {
        this.field_70180_af.func_187227_b(WatchedFloat.TENSION_FORCE.key, (Object)Float.valueOf(tensionForce));
    }

    public float getHookDistance() {
        return (float)this.getLauncherPosition().distance(this.getCurPosition());
    }

    private void updateControlling() {
        if (!this.isServerSide()) {
            return;
        }
        HookType hookType = this.getHookType();
        EntityLivingBase shooter = this.getThrower();
        if (!this.isLauncherInMainHand() || hookType == null || hookType.launcher == null || shooter == null) {
            return;
        }
        float ropeLength = this.getRopeLength();
        float pullingSpeed = hookType.launcher.reelingSpeed;
        if (shooter.func_70093_af()) {
            pullingSpeed *= 0.5f;
        }
        if (this.isBoosting()) {
            pullingSpeed *= 4.0f;
            if (this.isPulling() && this.isHookingBlock() && CommonMath.notZero((double)this.getTensionForce())) {
                this.boostUpShooter();
            }
            this.setState(State.REELING);
        }
        if (this.isPulling()) {
            ropeLength -= pullingSpeed;
        }
        if (this.isLoosening()) {
            ropeLength += pullingSpeed;
        }
        switch (this.getState()) {
            case HOOKING_BLOCK: {
                if (!shooter.func_70051_ag() || !CommonMath.notZero((double)this.getTensionForce())) break;
                ropeLength += pullingSpeed;
                break;
            }
            case HOOKING_ENTITY: {
                if (hookType != HookType.PUDGE || this.isLoosening()) break;
                ropeLength -= pullingSpeed * 2.0f;
                break;
            }
        }
        this.setRopeLength(ropeLength);
    }

    @Nullable
    public Rope getRope() {
        HookType hookType = this.getHookType();
        return hookType != null ? hookType.rope : null;
    }

    @Nullable
    public Launcher getLauncher() {
        HookType hookType = this.getHookType();
        return hookType != null ? hookType.launcher : null;
    }

    @Nullable
    public Hook getHook() {
        HookType hookType = this.getHookType();
        return hookType != null ? hookType.hook : null;
    }

    public void sendMotion(Entity target, MotionMsg.Type type, Vect3d motion, boolean reduction) {
        if (this.isServerSide() && target != null && type != null && motion != null) {
            if (target.func_184218_aH()) {
                target = target.func_184208_bv();
            }
            if (reduction) {
                Vect3d lastAddedMotion = this.lastAddedMotionsList.getOrDefault(target, Vect3d.ZERO);
                if (type == MotionMsg.Type.add) {
                    this.lastAddedMotionsList.put(target, motion);
                    if (lastAddedMotion.isZero() && motion.length() < 1.0E-4) {
                        return;
                    }
                    Rope rope = this.getRope();
                    float motionReduction = rope != null ? rope.getMotionReduction() : 0.0f;
                    motion = motion.subtract(lastAddedMotion.scale((double)motionReduction));
                }
            }
            if (target instanceof EntityPlayer) {
                MotionMsg motionMsg = new MotionMsg(target, type, motion);
                ForgeMain.instance.getRegistrator().networkChannel.sendTo((IMessage)motionMsg, (EntityPlayerMP)target);
            } else {
                switch (type) {
                    case add: {
                        ForgeEntity.addMotion((Entity)target, (Vect3d)motion);
                        break;
                    }
                    case set: {
                        ForgeEntity.setMotion((Entity)target, (Vect3d)motion);
                    }
                }
            }
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        this.func_70106_y();
    }

    public boolean func_70067_L() {
        return false;
    }

    public EntityLivingBase getThrower() {
        Entity entity = ForgeWorld.findEntity((World)this.field_70170_p, (int)((Integer)this.field_70180_af.func_187225_a(WatchedInt.SHOOTER_ID.key)));
        return entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
    }

    public void setThrower(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            this.field_70180_af.func_187227_b(WatchedInt.SHOOTER_ID.key, (Object)ForgeEntity.getId((Entity)entity));
        }
    }

    public Block getHookedBlock() {
        return ForgeWorld.getBlock((World)this.field_70170_p, (BlockPos)this.getHookedBlockPos());
    }

    public boolean hookedBlockExists() {
        return this.getHookedBlock() != Blocks.field_150350_a;
    }

    @Nullable
    public Entity findHookedEntity() {
        return HookShot.findEntity((World)this.field_70170_p, (int)((Integer)this.field_70180_af.func_187225_a(WatchedInt.HOOKED_ENTITY_ID.key)));
    }

    public boolean hookedEntityIsAlive() {
        Entity entity = this.findHookedEntity();
        return entity != null && entity.func_70089_S();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.move();
        this.setPrevRotation(this.getCurRotation());
        this.updateControlling();
        this.updateCombustion();
        this.updatePhysics();
        this.updateCollisions();
        this.updateTargetState();
        this.updateMotion();
        this.updateRotation();
    }

    private void updateCombustion() {
        if (this.isServerSide()) {
            double fireResistance = this.getHookType().hook.resistance;
            boolean fireInfluenced = false;
            switch (this.getState()) {
                case HOOKING_BLOCK: {
                    fireInfluenced = ForgeWorld.getBlock((World)this.field_70170_p, (BlockPos)this.getHookedBlockPos().func_177972_a(this.hitSide)) == Blocks.field_150480_ab;
                    break;
                }
                case HOOKING_ENTITY: {
                    Entity entity = this.findHookedEntity();
                    fireInfluenced = entity != null && entity.func_70027_ad();
                    break;
                }
            }
            if (this.func_70027_ad()) {
                this.combustion.fire();
            }
            if (this.combustion.getFireInfluencedTime().inSeconds() > fireResistance) {
                this.combustion.fire();
            }
            if (this.combustion.isBurning()) {
                this.func_70015_d(1);
            }
            if (this.combustion.getBurningTime().inSeconds() > fireResistance) {
                this.func_70106_y();
            }
            this.combustion.update(fireInfluenced);
        }
    }

    private void updateCollisions() {
        if (!this.isServerSide()) {
            return;
        }
        State state = this.getState();
        if (this.isHookingTarget()) {
            return;
        }
        if (state == State.REELING) {
            if (!this.canHookOnReeling()) {
                return;
            }
            if (this.getHookType() == HookType.PUDGE && this.getPrevState() == State.HOOKING_ENTITY) {
                return;
            }
        }
        ArrayList<RayTraceResult> rayTraceResultsList = new ArrayList<RayTraceResult>();
        if (this.field_70170_p != null) {
            rayTraceResultsList.add(this.field_70170_p.func_147447_a(this.getPrevPosition().toVec3d(), this.getCurPosition().toVec3d(), false, true, false));
        }
        AxisAlignedBB aaBB = this.getBB().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        List list = this.getEntitiesWithinAABB(aaBB);
        EntityLivingBase shooter = this.getThrower();
        Entity shooterRide = shooter != null ? shooter.func_184187_bx() : null;
        for (Entity target : list) {
            RayTraceResult rayTraceResult;
            if (target == shooter && state == State.REELING) {
                this.func_70106_y();
                return;
            }
            if (!this.isServerSide() || !target.func_70067_L() || target == shooter || target == shooterRide || (rayTraceResult = HookShot.getBB((Entity)target).func_72327_a(this.getCurPosition().toVec3d(), this.getNextPosition().toVec3d())) == null) continue;
            rayTraceResultsList.add(new RayTraceResult(target, HookShot.getCenterPosition((Entity)target).toVec3d()));
        }
        RayTraceResult nearestResult = null;
        double minDistance = Double.MAX_VALUE;
        for (RayTraceResult rayTraceResult : rayTraceResultsList) {
            double distance;
            if (rayTraceResult == null || !((distance = this.getCurPosition().distance(Vect3d.from((Vec3d)rayTraceResult.field_72307_f))) < minDistance)) continue;
            nearestResult = rayTraceResult;
            minDistance = distance;
        }
        if (nearestResult != null) {
            this.onTargetHit(nearestResult);
        }
    }

    private void updateTargetState() {
        if (this.isServerSide()) {
            switch (this.getState()) {
                case HOOKING_BLOCK: {
                    if (this.hookedBlockExists()) break;
                    this.setState(State.REELING);
                    break;
                }
                case HOOKING_ENTITY: {
                    Entity entity = this.findHookedEntity();
                    if (!(entity == null || entity.field_70128_L || entity instanceof EntityLivingBase && ((EntityLivingBase)entity).field_82175_bq && entity.func_70093_af() || entity instanceof EntityPlayer && entity.func_184218_aH() && ((EntityPlayer)entity).field_82175_bq) && !HookShot.hasSwingingPlayerPassenger((Entity)entity)) break;
                    this.setState(State.REELING);
                    break;
                }
            }
        }
    }

    public boolean isHookingTarget() {
        switch (this.getState()) {
            case HOOKING_BLOCK: 
            case HOOKING_ENTITY: {
                return true;
            }
        }
        return false;
    }

    private void updateRotation() {
        if (this.isHookingTarget()) {
            this.setAllRotations(this.getCurRotation());
        } else {
            Vect3d motion = this.getMotion();
            if (motion.notZero()) {
                if (this.getState() == State.REELING) {
                    motion = motion.invert();
                }
                this.setCurRotation(motion.rotation());
            }
        }
    }

    private void updateMotion() {
        State state = this.getState();
        switch (state) {
            case HOOKING_BLOCK: {
                if (!this.hookedBlockExists()) break;
                this.setAllPositions(this.getHitPosition());
                this.stopMoving();
                this.field_70122_E = true;
                break;
            }
            case HOOKING_ENTITY: {
                Entity entity;
                if (!this.func_184218_aH() && (entity = this.findHookedEntity()) != null) {
                    this.stopMoving();
                    this.func_184205_a(entity, true);
                    if (this.getHookType() == HookType.PUDGE) {
                        entity.func_184210_p();
                    }
                }
                this.field_70122_E = true;
                break;
            }
            default: {
                if (this.func_184218_aH()) {
                    this.func_184210_p();
                }
                this.field_70122_E = false;
                double motionFactor = 0.99f;
                if (this.func_70090_H()) {
                    Vect3d bubblePos = this.getCurPosition().subtract(this.getMotion().scale(0.25));
                    for (int i = 0; i < 4; ++i) {
                        ForgeWorld.spawnParticle((World)this.field_70170_p, (EnumParticleTypes)EnumParticleTypes.WATER_BUBBLE, (Vect3d)bubblePos, (Vect3d)this.getMotion());
                    }
                    motionFactor = 0.8f;
                }
                this.setMotion(this.getMotion().scale(motionFactor));
                this.field_70181_x -= (double)0.005f;
            }
        }
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        Vect3d vec = Vect3d.from((double)x, (double)y, (double)z).normalize().scale((double)velocity);
        Rotation rotation = new Rotation(vec.pitch(), vec.yaw());
        this.setMotion(vec);
        this.setAllRotations(rotation);
    }

    public void func_70106_y() {
        InventoryPlayer inventory;
        ItemStack launcher;
        if (this.getThrower() instanceof EntityPlayer && (launcher = Launcher.findAttachedLauncher(inventory = ((EntityPlayer)this.getThrower()).field_71071_by, this)) != null) {
            Launcher.unattach(launcher);
        }
        super.func_70106_y();
    }

    public float getTensionForce() {
        return ((Float)this.field_70180_af.func_187225_a(WatchedFloat.TENSION_FORCE.key)).floatValue();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < (double)(RENDER_DISTANCE * RENDER_DISTANCE);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.getBB().func_111270_a(HookShot.getBB((Entity)this.getThrower()));
    }

    private void boostUpShooter() {
        EntityLivingBase shooter = this.getThrower();
        Launcher launcher = this.getLauncher();
        if (shooter != null && launcher != null) {
            this.sendMotion((Entity)shooter, MotionMsg.Type.add, Vect3d.ZERO.withY((double)launcher.boostStrength), false);
            HookShot.setFallDistance((Entity)shooter, (float)0.0f, (boolean)true);
        }
    }

    public static enum State {
        SHOOTING,
        REELING,
        HOOKING_BLOCK,
        HOOKING_ENTITY;

    }

    public static enum WatchedFloat {
        HIT_X,
        HIT_Y,
        HIT_Z,
        ROPE_LENGTH,
        SAGGING,
        TENSION_FORCE;

        public final DataParameter<Float> key = EntityDataManager.func_187226_a(HookShot.class, (DataSerializer)DataSerializers.field_187193_c);
    }

    public static enum WatchedInt {
        HOOKED_BLOCK_X,
        HOOKED_BLOCK_Y,
        HOOKED_BLOCK_Z,
        HOOKED_ENTITY_ID,
        HOOK_TYPE,
        PREV_STATE,
        SHOOTER_ID,
        STATE;

        public final DataParameter<Integer> key = EntityDataManager.func_187226_a(HookShot.class, (DataSerializer)DataSerializers.field_187192_b);
    }

    public static enum WatchedBool {
        PULLING,
        LOOSENING,
        BOOSTING;

        public final DataParameter<Boolean> key = EntityDataManager.func_187226_a(HookShot.class, (DataSerializer)DataSerializers.field_187198_h);
    }
}

