/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge;

import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.units.UnitId;
import java.util.Locale;
import net.minecraft.util.ResourceLocation;

public final class ForgeLocating {
    public static final String PATH_DELIMITER = "/";

    protected static ResourceLocation texture(String modId, Folders folder, String name, String ... subFolders) {
        String folderName = folder != Folders.TEXTURES ? folder.func_176610_l() : "";
        String subDir = ForgeLocating.joinPath(subFolders);
        String path = ForgeLocating.joinPath(Folders.TEXTURES.func_176610_l(), folderName, subDir, name.toLowerCase(Locale.ROOT) + Extensions.PNG.getWithDot());
        return new ResourceLocation(modId, path);
    }

    public static String joinPath(String ... parts) {
        String path = String.join((CharSequence)PATH_DELIMITER, parts);
        String doubleDelimiter = "//";
        while (path.contains(doubleDelimiter)) {
            path = path.replace(doubleDelimiter, PATH_DELIMITER);
        }
        return path;
    }

    public static String joinName(String ... words) {
        return UnitId.buildRegName(words);
    }

    public static ResourceLocation armorTexture(String modId, String name) {
        return ForgeLocating.texture(modId, Folders.MODELS, name, Folders.ARMOR.func_176610_l());
    }

    public static ResourceLocation blockTexture(String modId, String name, String ... subFolders) {
        return ForgeLocating.texture(modId, Folders.BLOCKS, name, subFolders);
    }

    public static ResourceLocation entityTexture(String modId, String name, String ... subFolders) {
        return ForgeLocating.texture(modId, Folders.ENTITY, name, subFolders);
    }

    public static ResourceLocation environmentTexture(String modId, String name, String ... subFolders) {
        return ForgeLocating.texture(modId, Folders.ENVIRONMENT, name, subFolders);
    }

    public static ResourceLocation guiTexture(String modId, String name, String ... subFolders) {
        return ForgeLocating.texture(modId, Folders.GUI, name, subFolders);
    }

    public static ResourceLocation itemTexture(String modId, String name, String ... subFolders) {
        return ForgeLocating.texture(modId, Folders.ITEMS, name, subFolders);
    }

    public static ResourceLocation particleTexture(String modId, String name, String ... subFolders) {
        return ForgeLocating.texture(modId, Folders.PARTICLE, name, subFolders);
    }

    public static ResourceLocation potionTexture(String modId, String name, String ... subFolders) {
        return ForgeLocating.texture(modId, Folders.POTIONS, name, subFolders);
    }

    public static ResourceLocation fluidTexture(String modId, String fluidName, boolean flowing, String ... subFolders) {
        String name = ForgeLocating.joinName(fluidName, flowing ? "flow" : "still");
        String path = ForgeLocating.joinPath(Folders.FLUIDS.func_176610_l(), ForgeLocating.joinPath(subFolders), name);
        return new ResourceLocation(modId, path);
    }

    public static enum Extensions implements IForgeEnum
    {
        PNG;


        public String getWithDot() {
            return "." + this.func_176610_l();
        }

        public String func_176610_l() {
            return this.getLowerCase(this.name());
        }
    }

    public static enum Folders implements IForgeEnum
    {
        ARMOR,
        BLOCKS,
        ENTITY,
        ENVIRONMENT,
        FLUIDS,
        ITEMS,
        GUI,
        MODELS,
        PARTICLE,
        POTIONS,
        TEXTURES;


        public String func_176610_l() {
            return this.getLowerCase(this.name());
        }
    }
}

