/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.data;

import com.endertech.minecraft.forge.ForgeGui;
import com.endertech.minecraft.forge.ForgeMod;
import java.awt.Dimension;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class TileInventory
extends ItemStackHandler {
    public final TileEntity tile;

    public TileInventory(TileEntity tile, int size) {
        super(size);
        this.tile = tile;
    }

    protected void onContentsChanged(int slot) {
        this.tile.func_70296_d();
    }

    public static abstract class GuiHandler
    implements IGuiHandler {
        public GuiHandler(ForgeMod mod) {
            mod.getRegistrator().addGuiHandler(this);
        }

        public abstract boolean isValidTile(TileEntity var1);

        public abstract ServerContainer createServerContainer(World var1, BlockPos var2, TileEntity var3, EntityPlayer var4);

        @SideOnly(value=Side.CLIENT)
        public abstract GuiContainer createClientContainer(World var1, BlockPos var2, TileEntity var3, EntityPlayer var4);

        public static void openContainerFor(ForgeMod mod, World world, BlockPos pos, EntityPlayer player) {
            if (!player.func_70093_af() && !world.field_72995_K) {
                player.openGui((Object)mod, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }

        @Nullable
        public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
            BlockPos pos = new BlockPos(x, y, z);
            TileEntity tile = world.func_175625_s(pos);
            if (tile != null && this.isValidTile(tile)) {
                return this.createServerContainer(world, pos, tile, player);
            }
            return null;
        }

        @Nullable
        public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
            BlockPos pos = new BlockPos(x, y, z);
            TileEntity tile = world.func_175625_s(pos);
            if (tile != null && this.isValidTile(tile)) {
                return this.createClientContainer(world, pos, tile, player);
            }
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class ClientContainer
    extends GuiContainer {
        public final ServerContainer serverContainer;
        public final ForgeGui.GuiTexture texture;

        public ClientContainer(ServerContainer container, ForgeGui.GuiTexture texture) {
            super((Container)container);
            this.serverContainer = container;
            this.texture = texture;
            this.field_146999_f = texture.size.width;
            this.field_147000_g = texture.size.height;
        }

        protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
            this.field_146297_k.func_110434_K().func_110577_a(this.texture.path);
            this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        }

        public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
            super.func_146276_q_();
            super.func_73863_a(mouseX, mouseY, partialTicks);
            super.func_191948_b(mouseX, mouseY);
        }
    }

    public static class ServerContainer
    extends Container {
        public static final Dimension PLAYER_INVENTORY = new Dimension(9, 3);
        public static final Dimension SLOT_SIZE = new Dimension(18, 18);
        public final TileInventory tileInventory;

        public ServerContainer(TileInventory tileInventory) {
            this.tileInventory = tileInventory;
        }

        public ServerContainer addPlayerSlots(InventoryPlayer playerInventory, int startX, int startY) {
            for (int row = 0; row < ServerContainer.PLAYER_INVENTORY.height; ++row) {
                for (int col = 0; col < ServerContainer.PLAYER_INVENTORY.width; ++col) {
                    int x = startX + col * this.slotSize().width;
                    int y = startY + row * this.slotSize().height;
                    this.func_75146_a(new Slot((IInventory)playerInventory, ServerContainer.PLAYER_INVENTORY.width + col + row * ServerContainer.PLAYER_INVENTORY.width, x, y));
                }
            }
            for (int col = 0; col < ServerContainer.PLAYER_INVENTORY.width; ++col) {
                int x = startX + col * this.slotSize().width;
                int y = startY + 58;
                this.func_75146_a(new Slot((IInventory)playerInventory, col, x, y));
            }
            return this;
        }

        public Dimension slotSize() {
            return SLOT_SIZE;
        }

        public ItemSlot addSlot(ItemSlot slot) {
            this.func_75146_a((Slot)slot);
            return slot;
        }

        public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
            ItemStack itemstack = ItemStack.field_190927_a;
            Slot slot = (Slot)this.field_75151_b.get(index);
            if (slot != null && slot.func_75216_d()) {
                ItemStack itemstack1 = slot.func_75211_c();
                itemstack = itemstack1.func_77946_l();
                int size = this.tileInventory.getSlots();
                if (index < size ? !this.func_75135_a(itemstack1, size, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, size, false)) {
                    return ItemStack.field_190927_a;
                }
                if (itemstack1.func_190926_b()) {
                    slot.func_75215_d(ItemStack.field_190927_a);
                } else {
                    slot.func_75218_e();
                }
            }
            return itemstack;
        }

        public boolean func_75145_c(EntityPlayer player) {
            return player.func_174818_b(this.tileInventory.tile.func_174877_v()) < 64.0;
        }
    }

    public static class ItemSlot
    extends SlotItemHandler {
        public final TileInventory tileInventory;

        public ItemSlot(TileInventory tileInventory, int index, int xPosition, int yPosition) {
            super((IItemHandler)tileInventory, index, xPosition, yPosition);
            this.tileInventory = tileInventory;
        }
    }
}

