/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.items;

import com.endertech.minecraft.forge.units.ItemState;
import com.endertech.minecraft.forge.units.UnitId;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@Immutable
public class ForgeStack
extends ItemState {
    public static final ForgeStack EMPTY = ForgeStack.from(ItemState.EMPTY, 0);
    private final int amount;

    protected ForgeStack(Item item, int meta, int amount) {
        super(item, meta);
        this.amount = amount;
    }

    public static ForgeStack from(Item item, int meta, int amount) {
        return new ForgeStack(item, meta, amount);
    }

    public static ForgeStack from(Item item, int amount) {
        return ForgeStack.from(item, 0, amount);
    }

    public static ForgeStack from(Item item) {
        return ForgeStack.from(item, 1);
    }

    public static ForgeStack from(ItemState state, int amount) {
        return ForgeStack.from(state.getItem(), state.getMeta(), amount);
    }

    public static ForgeStack from(ItemStack stack) {
        return ForgeStack.from(stack.func_77973_b(), stack.func_77960_j(), stack.func_190916_E());
    }

    public static ForgeStack from(UnitId id, int amount) {
        return ForgeStack.from(id.getItemState(), amount);
    }

    public int getAmount() {
        return this.amount;
    }

    public boolean matches(ForgeStack stack) {
        return super.matches(stack) && stack.getAmount() == this.getAmount();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getAmount());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ForgeStack) {
            return super.equals(obj) && this.getAmount() == ((ForgeStack)obj).getAmount();
        }
        return super.equals(obj);
    }

    public ItemStack toItemStack() {
        return super.toItemStack(this.getAmount());
    }

    public ForgeStack toStack() {
        return super.toStack(this.getAmount());
    }

    @Override
    public String toString() {
        return this.getAmount() + "x" + super.toString();
    }
}

