/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.items;

import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.items.EquipmentItem;
import com.endertech.minecraft.forge.units.IUnitWithMeshDefinition;
import com.endertech.minecraft.forge.units.UnitId;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public abstract class GlassMeter
extends EquipmentItem
implements IUnitWithMeshDefinition {
    protected final Map<ItemStack, Entity> carriers = new ConcurrentHashMap<ItemStack, Entity>();
    private final TextFormatting textFormatting;

    public GlassMeter(ForgeMod mod, UnitConfig config, String name, CreativeTabs tab, int durability, EntityEquipmentSlot equipSlot, TextFormatting textFormating) {
        super(mod, config, name, tab, durability, UnitId.from("paneGlass"), equipSlot, SoundEvents.field_187565_bO);
        this.textFormatting = textFormating;
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = player.func_184614_ca();
        Item item = stack.func_77973_b();
        if (item instanceof GlassMeter) {
            ((GlassMeter)item).onHit(stack, player);
        }
    }

    protected void onHit(ItemStack stack, EntityPlayer player) {
        if (GlassMeter.notBroken(stack)) {
            GlassMeter.damageItem(1, stack, (EntityLivingBase)player, false);
            if (GlassMeter.isBroken(stack)) {
                player.func_184185_a(SoundEvents.field_187561_bM, 1.0f, 1.0f);
            }
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        this.onHit(stack, player);
        return super.onLeftClickEntity(stack, player, entity);
    }

    public boolean onDroppedByPlayer(ItemStack stack, EntityPlayer player) {
        this.onHit(stack, player);
        return super.onDroppedByPlayer(stack, player);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    public TextFormatting getTextFormatting() {
        return this.textFormatting;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack itemStack) {
        return this.getTextFormatting() + super.func_77653_i(itemStack);
    }
}

