/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.minecraft.forge.units.IForgeUnit;
import com.endertech.minecraft.forge.units.UnitId;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;

public class UnitVariant {
    public static final String VARIANTS = "variants";
    public static final String INVENTORY = "inventory";
    private final UnitId id;
    private final String variant;
    private ModelResourceLocation location = null;

    protected UnitVariant(UnitId id, String name, String value) {
        this(id, name + "=" + value);
    }

    public UnitVariant(UnitId id, String variant) {
        this.id = id;
        this.variant = variant;
    }

    public static <E extends Enum<?>> UnitVariant from(UnitId id, E en) {
        String className = IForgeUnit.getClassRegName(en.getClass());
        if (className.equals(VARIANTS)) {
            return new UnitVariant(id, ((IStringSerializable)en).func_176610_l());
        }
        return new UnitVariant(id, className, ((IStringSerializable)en).func_176610_l());
    }

    public static UnitVariant from(ModelResourceLocation model) {
        UnitId id = UnitId.from((ResourceLocation)model, 0);
        return new UnitVariant(id, model.func_177518_c());
    }

    public String getVariant() {
        return this.variant;
    }

    public UnitId getId() {
        return this.id;
    }

    public ModelResourceLocation toModelResLoc() {
        if (this.location == null) {
            this.location = new ModelResourceLocation(this.getId().toResLoc(), this.getVariant());
        }
        return this.location;
    }
}

