/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.world.WorldBounds;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;

public class ChunkBounds
extends WorldBounds {
    public static final int WIDTH = 16;
    public static final int HALF_WIDTH = 8;
    public static final int SQUARE = 256;
    public static final int DEFAULT_HEIGHT = ForgeBounds.HEIGHT.getIntBounds().length() + 1;
    public static final int DEFAULT_CAPACITY = 256 * DEFAULT_HEIGHT;

    protected ChunkBounds(IntBounds x, IntBounds y, IntBounds z) {
        super(x, y, z);
    }

    public static ChunkBounds from(ChunkPos pos, IntBounds y) {
        return new ChunkBounds(new IntBounds(pos.func_180334_c(), pos.func_180332_e()), y, new IntBounds(pos.func_180333_d(), pos.func_180330_f()));
    }

    public static ChunkBounds from(ChunkPos pos) {
        return ChunkBounds.from(pos, ForgeBounds.HEIGHT.getIntBounds());
    }

    public static ChunkBounds from(Chunk chunk, IntBounds y) {
        return ChunkBounds.from(chunk.func_76632_l(), y);
    }

    public static ChunkBounds from(Chunk chunk) {
        return ChunkBounds.from(chunk.func_76632_l());
    }

    public int getCapacity() {
        return 256 * this.getHeight();
    }
}

