/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.client;

import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.client.GameRendering;
import com.endertech.minecraft.forge.data.GamePath;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Rotation;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adhooks.hook.HookShot;
import com.endertech.minecraft.mods.adhooks.hook.HookType;
import com.endertech.minecraft.mods.adhooks.items.Rope;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class HookShotRenderer
extends EntityRenderer<HookShot> {
    final ResourceLocation webTexture = HookShotRenderer.webTextureLocation("");
    final ResourceLocation webTextureBack = HookShotRenderer.webTextureLocation("back");

    public HookShotRenderer(EntityRendererManager manager) {
        super(manager);
    }

    static ResourceLocation webTextureLocation(String namePostfix) {
        String name = UnitId.buildRegName((String[])new String[]{HookType.WEB.hook.getRegistryName().func_110623_a(), namePostfix});
        return GamePath.itemTexture((ResourceLocation)new ResourceLocation((String)"adhooks", (String)name), (String[])new String[0]).location;
    }

    public void renderHook(HookShot hookShot, double x, double y, double z, float yaw, float tickProgress) {
        HookType hookType = hookShot.getHookType();
        Rotation shotRotation = hookShot.getRotation(tickProgress);
        double pixel = 0.0625;
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)x, (double)y, (double)z);
        GlStateManager.enableRescaleNormal();
        GlStateManager.rotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
        GlStateManager.rotated((double)shotRotation.yaw, (double)0.0, (double)1.0, (double)0.0);
        GlStateManager.rotated((double)shotRotation.pitch, (double)1.0, (double)0.0, (double)0.0);
        GlStateManager.translated((double)-0.03125, (double)0.0, (double)-0.4);
        this.func_110776_a(AtlasTexture.field_110575_b);
        if (this.field_188301_f) {
            GlStateManager.enableColorMaterial();
            GlStateManager.setupSolidRenderingTextureCombine((int)this.func_188298_c((Entity)hookShot));
        }
        Minecraft.func_71410_x().func_175599_af().func_181564_a(hookType.hook.func_190903_i(), ItemCameraTransforms.TransformType.GROUND);
        if (this.field_188301_f) {
            GlStateManager.tearDownSolidRenderingTextureCombine();
            GlStateManager.disableColorMaterial();
        }
        GlStateManager.disableRescaleNormal();
        GlStateManager.popMatrix();
    }

    public void renderWeb(HookShot hookShot, double x, double y, double z, float yaw, float tickProgress) {
        if (hookShot == null || hookShot.getHookType() == null) {
            return;
        }
        HookType hookType = hookShot.getHookType();
        Rotation shotRotation = hookShot.getRotation(tickProgress);
        float hookThickness = 0.0625f;
        GlStateManager.pushMatrix();
        GlStateManager.enableRescaleNormal();
        GlStateManager.disableLighting();
        GlStateManager.translated((double)x, (double)y, (double)z);
        GlStateManager.rotated((double)(shotRotation.yaw - 90.0f), (double)0.0, (double)1.0, (double)0.0);
        GlStateManager.rotated((double)shotRotation.pitch, (double)0.0, (double)0.0, (double)1.0);
        switch (hookType) {
            case WEB: {
                this.func_110776_a(this.webTextureBack);
                GlStateManager.rotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                break;
            }
            default: {
                this.func_110776_a(this.webTexture);
                GlStateManager.rotated((double)45.0, (double)0.0, (double)0.0, (double)1.0);
            }
        }
        double scale = 0.5;
        GlStateManager.enableRescaleNormal();
        GlStateManager.scaled((double)scale, (double)scale, (double)scale);
        switch (hookType) {
            case WEB: {
                GlStateManager.translated((double)-0.5, (double)-0.5, (double)0.03125);
                break;
            }
            default: {
                GlStateManager.translated((double)-0.1, (double)-0.9, (double)0.03125);
            }
        }
        GameRendering.renderItemLayerIn2D((int)16, (int)16, (float)0.0625f, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (double)0.0, (double)0.0, (double)0.0);
        GlStateManager.disableRescaleNormal();
        GlStateManager.enableLighting();
        GlStateManager.popMatrix();
    }

    public void renderRope(HookShot hookShot, double x, double y, double z, float rotationYaw, float tickProgress) {
        boolean shooterIsMe;
        if (hookShot == null) {
            return;
        }
        LivingEntity shooter = hookShot.getShooter();
        if (shooter == null) {
            return;
        }
        Vect3d launcherOffset = Vect3d.ZERO;
        Rotation shooterRotation = ForgeEntity.getRotation((Entity)shooter, (float)tickProgress);
        boolean bl = shooterIsMe = shooter == Minecraft.func_71410_x().field_71439_g;
        if (shooterIsMe) {
            switch (this.field_76990_c.field_78733_k.field_74320_O) {
                case 1: 
                case 2: {
                    launcherOffset = Vect3d.from((double)-0.1, (double)0.0, (double)0.0);
                    break;
                }
                default: {
                    launcherOffset = Vect3d.from((double)-0.6, (double)-0.6, (double)0.0);
                }
            }
        }
        launcherOffset = launcherOffset.rotateAroundX(-shooterRotation.pitch).rotateAroundY(-shooterRotation.yaw);
        Vect3d launcherPos = hookShot.getLauncherPosition(tickProgress).add(launcherOffset);
        Vect3d hookShotPos = hookShot.getCurPosition(tickProgress);
        Vect3d ropeVec = launcherPos.subtract(hookShotPos);
        HookType hookType = hookShot.getHookType();
        if (hookType.rope != null) {
            Rope rope = hookType.rope;
            float hookStrength = hookType.hook != null ? hookType.hook.strength : 0.0f;
            float tensionForce = hookShot.getTensionForce();
            float tensionFactor = CommonMath.notZero((double)hookStrength) && CommonMath.notZero((double)rope.elasticity) ? tensionForce / hookStrength : 0.0f;
            float ropeWidth = new FloatBounds(Rope.WIDTH_BOUNDS.getMin(), Float.valueOf(shooterIsMe ? rope.width : 4.0f)).approxDown(tensionFactor).floatValue();
            float sagging = hookShot.getSagging();
            Vect3d viewPos = Vect3d.from((Vec3d)this.field_76990_c.field_217783_c.func_216785_c());
            GlStateManager.pushMatrix();
            GlStateManager.disableTexture();
            GlStateManager.disableLighting();
            GlStateManager.disableCull();
            GlStateManager.translated((double)x, (double)y, (double)z);
            GL11.glEnable((int)2848);
            if (rope.color != null) {
                GlStateManager.color3f((float)rope.color.getRed().toFloat(), (float)rope.color.getGreen().toFloat(), (float)rope.color.getBlue().toFloat());
            }
            Vect3d fromPoint = Vect3d.ZERO;
            for (int i = 1; i <= rope.segmentsAmount; ++i) {
                float f = i;
                Objects.requireNonNull(rope);
                float ropeProgress = f / 16.0f;
                float sagHeight = MathHelper.func_76126_a((float)(ropeProgress * (float)Math.PI)) * sagging;
                Vect3d toPoint = Vect3d.from((double)(ropeVec.x * (double)ropeProgress), (double)(ropeVec.y * (double)ropeProgress - (double)sagHeight), (double)(ropeVec.z * (double)ropeProgress));
                float viewDistance = (float)viewPos.distance(hookShotPos.add(toPoint));
                float scale = CommonMath.notZero((double)viewDistance) ? 10.0f / viewDistance : 1.0f;
                float ropeWidthScaled = new FloatBounds(Rope.WIDTH_BOUNDS.getMin(), Float.valueOf(ropeWidth)).approxUp(scale).floatValue();
                GlStateManager.lineWidth((float)ropeWidthScaled);
                GlStateManager.begin((int)1);
                GL11.glVertex3d((double)fromPoint.x, (double)fromPoint.y, (double)fromPoint.z);
                GL11.glVertex3d((double)toPoint.x, (double)toPoint.y, (double)toPoint.z);
                GlStateManager.end();
                fromPoint = toPoint;
            }
            GL11.glDisable((int)2848);
            GlStateManager.clearCurrentColor();
            GlStateManager.enableCull();
            GlStateManager.enableLighting();
            GlStateManager.enableTexture();
            GlStateManager.popMatrix();
        }
    }

    public void doRender(HookShot hookShot, double x, double y, double z, float yaw, float tickProgress) {
        if (!hookShot.isHookingEntity()) {
            if (hookShot.getHookType() == HookType.WEB) {
                this.renderWeb(hookShot, x, y, z, yaw, tickProgress);
            } else {
                this.renderHook(hookShot, x, y, z, yaw, tickProgress);
            }
        }
        this.renderRope(hookShot, x, y, z, yaw, tickProgress);
        super.func_76986_a((Entity)hookShot, x, y, z, yaw, tickProgress);
    }

    protected ResourceLocation getEntityTexture(HookShot entity) {
        return null;
    }

    public boolean func_188295_H_() {
        return false;
    }
}

