/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.items;

import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.client.GameKeys;
import com.endertech.minecraft.forge.client.Tooltip;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.items.DamageableItem;
import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adhooks.AdHooks;
import com.endertech.minecraft.mods.adhooks.hook.HookShot;
import com.endertech.minecraft.mods.adhooks.hook.HookType;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Launcher
extends DamageableItem {
    public static final String TAG_HOOKSHOT_ID = "hookShotId";
    public static final FloatBounds REELING_SPEED_BOUNDS = new FloatBounds(Float.valueOf(0.1f), Float.valueOf(4.0f));
    public static final FloatBounds BOOST_STRENGTH_BOUNDS = new FloatBounds(Float.valueOf(0.0f), Float.valueOf(3.0f));
    public static final int DAMAGE_ON_SHOT = 1;
    @OnlyIn(value=Dist.CLIENT)
    protected static KeyBinding keyBindUserDrop;
    private Map<KeyBinding, Boolean> watchedKeys = new ConcurrentHashMap<KeyBinding, Boolean>();
    private Set<ItemStack> queuedShots = new HashSet<ItemStack>();
    public final HookType hookType;
    public final float reelingSpeed;
    public final float boostStrength;

    public Launcher(ForgeMod mod, UnitConfig config, HookType hookType, int durability, float reelingSpeed, float boostStrength) {
        super(mod, config, hookType.func_176610_l() + "_launcher", new Item.Properties().func_200916_a(ItemGroup.field_78040_i), durability, UnitId.from((String)"string"));
        this.hookType = hookType;
        this.reelingSpeed = UnitConfig.getFloat((UnitConfig)config, (String)this.getUnitCategory(), (String)"reelingSpeed", (float)reelingSpeed, (FloatBounds)REELING_SPEED_BOUNDS, (String)"Defines how fast the launcher reels in the rope.");
        this.boostStrength = UnitConfig.getFloat((UnitConfig)config, (String)this.getUnitCategory(), (String)"boostStrength", (float)boostStrength, (FloatBounds)BOOST_STRENGTH_BOUNDS, (String)"Defines how high you will be thrown upward when boost is activated");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> lines, ITooltipFlag flag) {
        GameSettings gs = GameKeys.getGameSettings();
        Tooltip tip = Tooltip.of((ForgeMod)AdHooks.getInstance(), (String)"launcher", lines);
        if (GameKeys.isDown((KeyBinding)gs.field_151444_V)) {
            tip.add(TextFormatting.RED, "hook_strength", (Object)Float.valueOf(this.hookType.hook.strength));
            tip.add(TextFormatting.GREEN, "rope_elasticity", (Object)Float.valueOf(this.hookType.rope.elasticity));
            tip.add(TextFormatting.YELLOW, "rope_max_length", (Object)this.hookType.rope.maxLength);
            tip.add(TextFormatting.AQUA, "reeling_speed", (Object)Float.valueOf(this.reelingSpeed));
            tip.add(TextFormatting.BLUE, "boostup_strength", (Object)Float.valueOf(this.boostStrength));
        } else if (GameKeys.isDown((KeyBinding)gs.field_74311_E)) {
            tip.add("launch", new Object[]{TextFormatting.RED, gs.field_74312_F.func_197978_k()});
            tip.add("reel_unhook", new Object[]{TextFormatting.GREEN, gs.field_74316_C.func_197978_k(), keyBindUserDrop.func_197978_k()});
            tip.add("pull", new Object[]{TextFormatting.YELLOW, gs.field_74313_G.func_197978_k()});
            tip.add("loosen", new Object[]{TextFormatting.AQUA, gs.field_74312_F.func_197978_k()});
            tip.add("boost_up", new Object[]{TextFormatting.GOLD, gs.field_74316_C.func_197978_k(), keyBindUserDrop.func_197978_k()});
            tip.add("release", new Object[]{TextFormatting.LIGHT_PURPLE, gs.field_74312_F.func_197978_k(), gs.field_74311_E.func_197978_k()});
        } else {
            tip.add("more_info", new Object[]{TextFormatting.GRAY, TextFormatting.DARK_PURPLE, gs.field_151444_V.func_197978_k()});
            tip.add("controls", new Object[]{TextFormatting.GRAY, TextFormatting.DARK_PURPLE, gs.field_74311_E.func_197978_k()});
        }
    }

    public static boolean isAttached(ItemStack launcher) {
        return Launcher.stackHasLauncher(launcher) && launcher.func_77942_o() && launcher.func_77978_p().func_74764_b(TAG_HOOKSHOT_ID);
    }

    public static boolean isAttachedToHookShot(ItemStack launcher, HookShot hookShot) {
        return Launcher.isAttached(launcher) && hookShot != null && Launcher.getAttachedHookShotId(launcher) == hookShot.func_145782_y();
    }

    public static int getAttachedHookShotId(ItemStack launcher) {
        if (launcher != null && launcher.func_77942_o()) {
            return launcher.func_77978_p().func_74762_e(TAG_HOOKSHOT_ID);
        }
        return 0;
    }

    public static boolean stackHasLauncher(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof Launcher;
    }

    @Nullable
    public static HookShot findAttachedHookShot(ItemStack launcher, World world) {
        Entity entity;
        if (Launcher.isAttached(launcher) && world != null && (entity = world.func_73045_a(Launcher.getAttachedHookShotId(launcher))) instanceof HookShot) {
            return (HookShot)entity;
        }
        return null;
    }

    @Nullable
    public static ItemStack findAttachedLauncher(PlayerInventory inventory, HookShot hookShot) {
        if (inventory != null && inventory.field_70462_a != null && hookShot != null) {
            for (ItemStack stack : inventory.field_70462_a) {
                if (!Launcher.isAttachedToHookShot(stack, hookShot)) continue;
                return stack;
            }
        }
        return null;
    }

    public static void attachToHookShot(ItemStack launcher, HookShot hookShot) {
        if (Launcher.stackHasLauncher(launcher) && hookShot != null) {
            CompoundNBT tag = launcher.func_196082_o();
            tag.func_74768_a(TAG_HOOKSHOT_ID, hookShot.func_145782_y());
        }
    }

    public static void unattach(ItemStack launcher) {
        if (Launcher.stackHasLauncher(launcher) && launcher.func_77942_o()) {
            launcher.func_77978_p().func_82580_o(TAG_HOOKSHOT_ID);
        }
    }

    public void func_77622_d(ItemStack stack, World world, PlayerEntity player) {
        stack.func_196082_o();
    }

    public boolean onDroppedByPlayer(ItemStack launcher, PlayerEntity player) {
        return super.onDroppedByPlayer(launcher, player);
    }

    public boolean onLeftClickEntity(ItemStack launcher, PlayerEntity player, Entity entity) {
        return this.hookType != HookType.PUDGE;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public void queueShot(ItemStack launcher) {
        this.queuedShots.add(launcher);
    }

    protected void makeShot(ItemStack launcher, World world, LivingEntity shooter) {
        if (this.isServerSide((IWorldReader)world) && this.hookType != HookType.PROTOTYPE && Launcher.notBroken((ItemStack)launcher)) {
            HookShot hookShot = new HookShot(world, shooter, this.hookType);
            world.func_217376_c((Entity)hookShot);
            Launcher.attachToHookShot(launcher, hookShot);
            Launcher.damageItem((int)1, (ItemStack)launcher, (boolean)false, (LivingEntity)shooter, null);
        }
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, PlayerEntity player) {
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        player.func_184598_c(hand);
        return ActionResult.newResult((ActionResultType)ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onClientInit() {
        if (keyBindUserDrop == null) {
            keyBindUserDrop = GameKeys.createBindingFor((ResourceLocation)AdHooks.getInstance().toResLoc("unhook"), (int)88, (GameKeys.KeyCategories)GameKeys.KeyCategories.GAMEPLAY);
        }
        GameSettings gs = GameKeys.getGameSettings();
        this.watchedKeys.put(gs.field_74312_F, false);
        this.watchedKeys.put(gs.field_74313_G, false);
        this.watchedKeys.put(gs.field_74316_C, false);
        this.watchedKeys.put(keyBindUserDrop, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void processPressedKeys() {
        GameSettings gs = GameKeys.getGameSettings();
        if (GameKeys.affectPlayer()) {
            for (KeyBinding keyBinding : this.watchedKeys.keySet()) {
                KeyPressedMsg.Keys key;
                boolean isKeyDown;
                boolean wasKeyDown = this.watchedKeys.get(keyBinding);
                if (wasKeyDown == (isKeyDown = keyBinding.func_151470_d())) continue;
                if (keyBinding == gs.field_74312_F) {
                    key = KeyPressedMsg.Keys.ATTACK;
                } else if (keyBinding == gs.field_74313_G) {
                    key = KeyPressedMsg.Keys.USE;
                } else {
                    if (keyBinding != gs.field_74316_C && keyBinding != keyBindUserDrop) continue;
                    key = KeyPressedMsg.Keys.DROP;
                }
                KeyPressedMsg message = new KeyPressedMsg(key, isKeyDown);
                AdHooks.getInstance().getConnection().sendToServer((Object)message);
                this.watchedKeys.put(keyBinding, isKeyDown);
            }
        }
    }

    public void func_77663_a(ItemStack launcher, World world, Entity shooter, int inventorySlot, boolean isCurrentItem) {
        if (this.isClientSide((IWorldReader)world) && isCurrentItem) {
            this.processPressedKeys();
        }
        if (this.isServerSide((IWorldReader)world) && shooter instanceof LivingEntity && this.queuedShots.contains(launcher)) {
            this.makeShot(launcher, world, (LivingEntity)shooter);
            this.queuedShots.remove(launcher);
        }
        super.func_77663_a(launcher, world, shooter, inventorySlot, isCurrentItem);
    }

    public static class KeyPressedMsg
    extends ForgeNetMsg<KeyPressedMsg> {
        public Keys key;
        public boolean isDown;

        public KeyPressedMsg() {
        }

        public KeyPressedMsg(Keys key, boolean isDown) {
            this.key = key;
            this.isDown = isDown;
        }

        public KeyPressedMsg create() {
            return new KeyPressedMsg();
        }

        public void handle(World world, PlayerEntity player) {
            ItemStack stack = player.field_71071_by.func_70448_g();
            if (Launcher.stackHasLauncher(stack)) {
                if (Launcher.isAttached(stack)) {
                    HookShot hookShot = Launcher.findAttachedHookShot(stack, world);
                    if (hookShot != null) {
                        switch (this.key) {
                            case ATTACK: {
                                hookShot.setLoosening(this.isDown);
                                break;
                            }
                            case USE: {
                                hookShot.setPulling(this.isDown);
                                break;
                            }
                            case DROP: {
                                hookShot.setBoosting(this.isDown);
                                break;
                            }
                        }
                    } else {
                        Launcher.unattach(stack);
                    }
                } else if (this.key == Keys.ATTACK && this.isDown) {
                    Launcher launcher = (Launcher)stack.func_77973_b();
                    launcher.queueShot(stack);
                }
            }
        }

        public static enum Keys {
            ATTACK,
            DROP,
            USE;

        }
    }
}

