/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.common;

import java.nio.file.Path;
import java.util.StringJoiner;

public final class CommonPath {
    private static final String RESERVED_CHARS = "<>:\"|?*";
    public static final String NAME_EXT_DELIMITER = ".";

    public static String getFileNameOnly(Path path) {
        String fileName = path != null ? String.valueOf(path.getFileName()) : "";
        int i = fileName.lastIndexOf(NAME_EXT_DELIMITER);
        if (i >= 0) {
            return fileName.substring(0, i);
        }
        return fileName;
    }

    public static String getFileExtension(Path path) {
        String fileExt = path != null ? String.valueOf(path.getFileName()) : "";
        int i = fileExt.lastIndexOf(NAME_EXT_DELIMITER);
        if (i >= 0) {
            return fileExt.substring(i + 1);
        }
        return fileExt;
    }

    public static String replaceReservedCharsWith(String string, String replacement) {
        StringJoiner regex = new StringJoiner("/", "[", "]");
        for (int i = 0; i < RESERVED_CHARS.length(); ++i) {
            regex.add(String.valueOf(RESERVED_CHARS.charAt(i)));
        }
        return string.replaceAll(regex.toString(), replacement);
    }

    public static String removeReservedChars(String string) {
        return CommonPath.replaceReservedCharsWith(string, "");
    }
}

