/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.items;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.items.RepairMatcher;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public abstract class DamageableItem
extends ForgeItem {
    protected final UnitId repair;
    private final boolean repairCostGrow;
    private final int durability;

    public DamageableItem(ForgeMod mod, UnitConfig config, String name, Item.Properties props, int durability, UnitId repair) {
        super(mod, config, name, props.func_200918_c(durability));
        this.durability = UnitConfig.getInt(this.getConfig(), this.getUnitCategory(), "durability", durability, GameBounds.DURABILITY.getIntBounds(), "Defines durability of the item.");
        this.repair = UnitConfig.getUnitId(this.getConfig(), this.getUnitCategory(), "repair", repair, "Defines the material for repair on an anvil.");
        this.repairCostGrow = UnitConfig.getBool(this.getConfig(), this.getUnitCategory(), "repairCostGrow", false, "If true, repair cost will grow for this item after each repair on an anvil.");
    }

    public int getMaxDamage(ItemStack stack) {
        return this.durability;
    }

    public boolean func_77645_m() {
        return this.durability > 0;
    }

    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        for (ItemStack stack : new ItemStack[]{event.getLeft(), event.getRight()}) {
            Item item = stack.func_77973_b();
            if (!(item instanceof DamageableItem) || ((DamageableItem)item).isRepairCostGrow()) continue;
            DamageableItem.removeRepairPenaltyFor(stack);
        }
    }

    public static void removeRepairPenaltyFor(ItemStack stack) {
        stack.func_196083_e("RepairCost");
    }

    public boolean func_82789_a(ItemStack stack, ItemStack material) {
        return RepairMatcher.from(material).matches(this.repair);
    }

    public boolean isRepairCostGrow() {
        return this.repairCostGrow;
    }

    public Percentage getWearoutPercentage(ItemStack stack) {
        return Percentage.from(stack.func_77952_i(), stack.func_77958_k());
    }
}

