/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.common;

import java.util.Date;
import java.util.Objects;

public final class CommonTime {

    public static class Interval
    implements Comparable<Interval> {
        public static final Interval ZERO = new Interval(0.0);
        public static final int MILLISECONDS_IN_SECOND = 1000;
        public static final int SECONDS_IN_MINUTE = 60;
        public static final int MINUTES_IN_HOUR = 60;
        public static final int HOURS_IN_DAY = 24;
        public static final int SECONDS_IN_HOUR = 3600;
        public static final int SECONDS_IN_DAY = 86400;
        private final long value;

        protected Interval(double value) {
            this.value = Math.round(value);
        }

        public static Interval of(IMessure messure, double amount) {
            return new Interval((double)messure.getCapacity() * amount);
        }

        public static Interval millis(long milliseconds) {
            return new Interval(milliseconds);
        }

        public static Interval seconds(double seconds) {
            return new Interval(seconds * 1000.0);
        }

        public static Interval minutes(double minutes) {
            return new Interval(minutes * 60.0 * 1000.0);
        }

        public static Interval hours(double hours) {
            return new Interval(hours * 3600.0 * 1000.0);
        }

        public static Interval days(int days) {
            return new Interval(days * 86400 * 1000);
        }

        public static Interval leftTo(Stamp time) {
            return Interval.millis(Stamp.now().distanceTo(time));
        }

        public static Interval passedFrom(Stamp stamp) {
            return Interval.millis(stamp.distanceTo(Stamp.now()));
        }

        public boolean moreThan(Interval interval) {
            return this.getValue() > interval.getValue();
        }

        public boolean lessThan(Interval interval) {
            return this.getValue() < interval.getValue();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Interval) {
                return ((Interval)obj).getValue() == this.getValue();
            }
            return super.equals(obj);
        }

        public long inMillis() {
            return this.getValue();
        }

        public double inSeconds() {
            return (double)this.getValue() / 1000.0;
        }

        public double inMinutes() {
            return (double)this.getValue() / 60000.0;
        }

        public double inHours() {
            return (double)this.getValue() / 3600000.0;
        }

        public double inDays() {
            return (double)this.getValue() / 8.64E7;
        }

        public double in(IMessure messure) {
            return (double)this.getValue() / (double)messure.getCapacity();
        }

        public Interval add(Interval time) {
            return Interval.millis(this.getValue() + time.getValue());
        }

        public Interval substract(Interval time) {
            return Interval.millis(this.getValue() - time.getValue());
        }

        public Interval mult(double factor) {
            return Interval.millis(Math.round((double)this.getValue() * factor));
        }

        protected long getValue() {
            return this.value;
        }

        @Override
        public int compareTo(Interval o) {
            return Long.compare(this.getValue(), o.getValue());
        }

        public int hashCode() {
            return Objects.hash(this.getValue());
        }
    }

    public static class Stamp
    implements Comparable<Stamp> {
        private final long value;

        protected Stamp(long value) {
            this.value = value;
        }

        public static Stamp now() {
            return new Stamp(System.currentTimeMillis());
        }

        public static Stamp at(Date date) {
            return new Stamp(date.getTime());
        }

        public long distanceTo(Stamp time) {
            return time.value - this.value;
        }

        @Override
        public int compareTo(Stamp o) {
            return Long.compare(this.value, o.value);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Stamp) {
                return this.value == ((Stamp)obj).value;
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }

    public static interface IMessure {
        public long getCapacity();
    }
}

