/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.math;

import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.world.GameWorld;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;

public class AABB {
    public static final AxisAlignedBB ZERO = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final AxisAlignedBB BLOCK = ForgeBlock.FULL_BLOCK_AABB;
    public static final int BLOCK_SIZE = 1;

    public static List<AxisAlignedBB> getEdges(float thickness) {
        float d0 = thickness;
        float d1 = 1.0f - thickness;
        AxisAlignedBB X = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)d0, (double)d0);
        AxisAlignedBB Y = new AxisAlignedBB(0.0, 0.0, 0.0, (double)d0, 1.0, (double)d0);
        AxisAlignedBB Z = new AxisAlignedBB(0.0, 0.0, 0.0, (double)d0, (double)d0, 1.0);
        AxisAlignedBB[] AABB_X = new AxisAlignedBB[]{X.func_72317_d(0.0, 0.0, 0.0), X.func_72317_d(0.0, (double)d1, 0.0), X.func_72317_d(0.0, 0.0, (double)d1), X.func_72317_d(0.0, (double)d1, (double)d1)};
        AxisAlignedBB[] AABB_Y = new AxisAlignedBB[]{Y.func_72317_d(0.0, 0.0, 0.0), Y.func_72317_d((double)d1, 0.0, 0.0), Y.func_72317_d(0.0, 0.0, (double)d1), Y.func_72317_d((double)d1, 0.0, (double)d1)};
        AxisAlignedBB[] AABB_Z = new AxisAlignedBB[]{Z.func_72317_d(0.0, 0.0, 0.0), Z.func_72317_d(0.0, (double)d1, 0.0), Z.func_72317_d((double)d1, 0.0, 0.0), Z.func_72317_d((double)d1, (double)d1, 0.0)};
        ArrayList<AxisAlignedBB> edges = new ArrayList<AxisAlignedBB>();
        Collections.addAll(edges, AABB_X);
        Collections.addAll(edges, AABB_Y);
        Collections.addAll(edges, AABB_Z);
        return edges;
    }

    public static AxisAlignedBB getFace(float thickness, Direction facing) {
        float d0 = thickness;
        float d1 = 1.0f - thickness;
        switch (facing) {
            case DOWN: {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)d0, 1.0);
            }
            case UP: {
                return new AxisAlignedBB(0.0, (double)d1, 0.0, 1.0, 1.0, 1.0);
            }
            case EAST: {
                return new AxisAlignedBB((double)d1, 0.0, 0.0, 1.0, 1.0, 1.0);
            }
            case NORTH: {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, (double)d0);
            }
            case SOUTH: {
                return new AxisAlignedBB(0.0, 0.0, (double)d1, 1.0, 1.0, 1.0);
            }
            case WEST: {
                return new AxisAlignedBB(0.0, 0.0, 0.0, (double)d0, 1.0, 1.0);
            }
        }
        return ZERO;
    }

    public static List<AxisAlignedBB> getFaces(float thickness, Direction ... facings) {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        for (Direction facing : facings) {
            list.add(AABB.getFace(thickness, facing));
        }
        return list;
    }

    public static List<AxisAlignedBB> getWalls(float thickness) {
        return AABB.getFaces(thickness, GameWorld.Directions.CLOCKWISE_HORIZONTALS);
    }

    public static boolean isFullBlockingPane(AxisAlignedBB aabb, Direction.Axis axis) {
        if (aabb == null) {
            return false;
        }
        switch (axis) {
            case X: {
                if (!(aabb.field_72337_e - aabb.field_72338_b >= 1.0) || !(aabb.field_72334_f - aabb.field_72339_c >= 1.0)) break;
                return true;
            }
            case Y: {
                if (!(aabb.field_72336_d - aabb.field_72340_a >= 1.0) || !(aabb.field_72334_f - aabb.field_72339_c >= 1.0)) break;
                return true;
            }
            case Z: {
                if (!(aabb.field_72337_e - aabb.field_72338_b >= 1.0) || !(aabb.field_72336_d - aabb.field_72340_a >= 1.0)) break;
                return true;
            }
        }
        return false;
    }

    public static boolean isFullBlockingFace(AxisAlignedBB aabb, Direction facing) {
        if (AABB.isFullBlockingPane(aabb, facing.func_176740_k())) {
            boolean neg = facing.func_176743_c() == Direction.AxisDirection.NEGATIVE;
            switch (facing.func_176740_k()) {
                case X: {
                    return neg ? aabb.field_72340_a == 0.0 : aabb.field_72336_d == 1.0;
                }
                case Y: {
                    return neg ? aabb.field_72338_b == 0.0 : aabb.field_72337_e == 1.0;
                }
                case Z: {
                    return neg ? aabb.field_72339_c == 0.0 : aabb.field_72334_f == 1.0;
                }
            }
        }
        return false;
    }
}

