/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.units.IForgeUnit;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;

public class UnitVariant {
    public static final String VARIANTS = "variants";
    public static final String INVENTORY = "inventory";
    private final ResourceLocation regName;
    private final String variant;
    private ModelResourceLocation location = null;

    protected UnitVariant(ResourceLocation regName, String name, String value) {
        this(regName, name + "=" + value);
    }

    public UnitVariant(ResourceLocation regName, String variant) {
        this.regName = regName;
        this.variant = variant;
    }

    public static <E extends Enum<?>> UnitVariant from(ResourceLocation regName, E en) {
        String className = IForgeUnit.getClassRegName(en.getClass());
        if (className.equals(VARIANTS)) {
            return new UnitVariant(regName, ((IForgeEnum)((Object)en)).func_176610_l());
        }
        return new UnitVariant(regName, className, ((IForgeEnum)((Object)en)).func_176610_l());
    }

    public static UnitVariant from(ModelResourceLocation model) {
        return new UnitVariant((ResourceLocation)model, model.func_177518_c());
    }

    public String getVariant() {
        return this.variant;
    }

    public ResourceLocation getRegName() {
        return this.regName;
    }

    public ModelResourceLocation toModelResLoc() {
        if (this.location == null) {
            this.location = new ModelResourceLocation(this.getRegName(), this.getVariant());
        }
        return this.location;
    }
}

