/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.common;

import com.endertech.common.CommonTime;
import java.util.function.BiFunction;
import java.util.function.Function;

public class CachedValue<V> {
    protected CommonTime.Stamp stamp;
    protected V value;
    protected final CommonTime.Interval interval;

    public CachedValue(V initialValue, CommonTime.Interval updateInterval) {
        this.value = initialValue;
        this.stamp = CommonTime.Stamp.now();
        this.interval = updateInterval;
    }

    protected boolean requiresUpdate() {
        return CommonTime.Interval.passedFrom(this.stamp).moreThan(this.interval);
    }

    protected V updateWith(V value) {
        this.value = value;
        this.stamp = CommonTime.Stamp.now();
        return this.value;
    }

    public <P1, P2> V get(BiFunction<P1, P2, V> updatedValue, P1 param1, P2 param2) {
        return this.requiresUpdate() ? this.updateWith(updatedValue.apply(param1, param2)) : this.value;
    }

    public <P> V get(Function<P, V> updatedValue, P param) {
        return this.requiresUpdate() ? this.updateWith(updatedValue.apply(param)) : this.value;
    }
}

