/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.entities;

import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Vect3d;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockStateCarrier
extends ForgeEntity {
    private static final DataParameter<Optional<BlockState>> CARRIED_BLOCK_STATE = EntityDataManager.func_187226_a(BlockStateCarrier.class, (IDataSerializer)DataSerializers.field_187197_g);

    public BlockStateCarrier(EntityType<?> type, World world, BlockPos pos, BlockState carriedState) {
        super(type, world);
        Vect3d centeredPos = BlockStateCarrier.getCenteredPosTo(pos);
        this.setAllPositions(centeredPos);
        this.setCarriedBlockState(carriedState);
    }

    public BlockStateCarrier(EntityType<?> type, World world) {
        super(type, world);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(CARRIED_BLOCK_STATE, Optional.empty());
    }

    @Nullable
    public BlockState getCarriedBlockState() {
        return ((Optional)this.func_184212_Q().func_187225_a(CARRIED_BLOCK_STATE)).orElse(null);
    }

    protected void setCarriedBlockState(@Nullable BlockState newState) {
        this.func_184212_Q().func_187227_b(CARRIED_BLOCK_STATE, Optional.ofNullable(newState));
    }

    @Nullable
    public ResourceLocation getTextureLocation() {
        BlockState state = this.getCarriedBlockState();
        if (state != null && state.func_177230_c() instanceof ForgeBlock) {
            ForgeBlock block = (ForgeBlock)state.func_177230_c();
            ResourceLocation location = block.getTextureLocationFor(state);
            return location;
        }
        return null;
    }

    protected void func_213281_b(CompoundNBT compound) {
        BlockState state = this.getCarriedBlockState();
        if (state != null) {
            compound.func_74768_a(Tags.CARRIED_STATE.name(), Block.func_196246_j((BlockState)state));
        }
    }

    protected void func_70037_a(CompoundNBT compound) {
        String key = Tags.CARRIED_STATE.name();
        if (compound.func_74764_b(key)) {
            int id = compound.func_74762_e(key);
            BlockState state = Block.func_196257_b((int)id);
            this.func_184212_Q().func_187227_b(CARRIED_BLOCK_STATE, Optional.of(state));
        }
    }

    @Override
    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket((Entity)this, Block.func_196246_j((BlockState)this.getCarriedBlockState()));
    }

    private static enum Tags {
        CARRIED_STATE;

    }
}

