/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.entities;

import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.data.GamePath;
import com.endertech.minecraft.forge.math.GameTime;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.ResourceLocation;

public abstract class ForgeEffect
extends Effect {
    protected final ResourceLocation texture;

    protected ForgeEffect(ForgeMod mod, String name, EffectType type, ColorARGB liquidColor) {
        super(type, liquidColor.getARGB());
        this.setRegistryName(mod.getId(), name);
        this.texture = GamePath.effectTexture((ResourceLocation)this.getRegistryName(), (String[])new String[0]).location;
    }

    public abstract void func_76394_a(LivingEntity var1, int var2);

    public EffectInstance createEffect(CommonTime.Interval duration) {
        return this.createInstance(duration, true);
    }

    public EffectInstance createInstance(CommonTime.Interval duration, boolean showParticles) {
        int ticks = (int)GameTime.inServerTicks(duration);
        EffectInstance effect = new EffectInstance((Effect)this, ticks, 0, false, showParticles);
        return effect;
    }

    public boolean func_76397_a(int ticksLeft, int amplifier) {
        int reminder = ticksLeft % this.getUpdateInterval();
        return reminder == 0;
    }

    public int getUpdateInterval() {
        return 5;
    }
}

