/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.hook;

import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.mods.adhooks.AdHooks;
import com.endertech.minecraft.mods.adhooks.items.Hook;
import com.endertech.minecraft.mods.adhooks.items.Launcher;
import com.endertech.minecraft.mods.adhooks.items.Properties;
import com.endertech.minecraft.mods.adhooks.items.Rope;
import java.nio.file.Path;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public enum HookType implements IForgeEnum
{
    PROTOTYPE(new Properties()),
    PUDGE(new Properties().launcher(300, 0.7f, 1.0f).hook(10.0f, 0.0f).rope(32, 0.0f, 3.0f, -4259840)),
    SPEAR(new Properties().launcher(180, 0.5f, 1.0f).hook(5.0f, 2.0f).rope(64, 0.6f, 4.0f, -1090519040)),
    WEB(new Properties().launcher(240, 0.8f, 1.0f).hook(2.0f, 0.0f).rope(76, 0.95f, 6.0f, -1));

    final Properties props;
    public final Hook hook;
    public final Rope rope;
    public final Launcher launcher;

    private HookType(Properties props) {
        props.hookType = this;
        this.props = props;
        AdHooks mod = AdHooks.getInstance();
        Path configDir = mod.getConfigsDir();
        UnitConfig hookConfig = UnitConfig.in((Path)configDir, (String)"hooks", (String)this.getName());
        this.hook = new Hook(mod, hookConfig, this, props.hookStrength, props.hookDamage, props.hookStrength);
        UnitConfig launcherConfig = UnitConfig.in((Path)configDir, (String)"launchers", (String)this.getName());
        this.rope = new Rope(launcherConfig, props.ropeMaxLength, props.ropeWidth, props.ropeElasticity, ColorARGB.from((int)props.ropeColorARGB));
        this.launcher = new Launcher(mod, launcherConfig, this, props.durability, props.reelingSpeed, props.boostStrength);
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player instanceof ServerPlayerEntity) {
            for (HookType type : HookType.values()) {
                AdHooks.getInstance().getConnection().sendToPlayer((Object)type.props.readValues(), (ServerPlayerEntity)player);
            }
        }
    }
}

