/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.init;

import com.endertech.minecraft.forge.ForgeLocating;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.ModConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.materials.CraftingRecipe;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adhooks.Hook;
import com.endertech.minecraft.mods.adhooks.Launcher;
import com.endertech.minecraft.mods.adhooks.init.HookType;
import com.endertech.minecraft.mods.adhooks.shot.HookShot;
import com.endertech.minecraft.mods.adhooks.shot.HookShotRenderer;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.item.Item;

@Mod(modid="adhooks", name="Advanced Hook Launchers", version="1.7.10-2.1.1.0", acceptedMinecraftVersions="[1.7.10]", dependencies="required-after:forgeendertech@[1.7.10-1.9.2.0,)")
public class Main
extends ForgeMod {
    public static final String ID = "adhooks";
    public static final String NAME = "Advanced Hook Launchers";
    @Mod.Instance(value="adhooks")
    public static Main instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.printInitMsg((FMLEvent)event);
        this.setConfig(new ModConfig(this.getId(), event));
        HookType.values();
        this.addWebRecipe();
        this.addHookRecipe(HookType.PUDGE, "011 101 200", new String[]{"steel_ingot", "stick"}, new String[]{"iron_ingot", "stick"});
        this.addHookRecipe(HookType.SPEAR, "001 020 100", new String[]{"steel_ingot", "stick"}, new String[]{"iron_ingot", "stick"});
        this.addHookRecipe(HookType.WEB, "001 020 200", new String[]{"web", "string"}, new String[]{"web", "string"});
        this.addLauncherRecipe(HookType.PUDGE, "dye:1", "dye:1", "harden_leather", "leather");
        this.addLauncherRecipe(HookType.SPEAR, "dye:8", "dye:0", "steel_ingot", "iron_ingot");
        this.addLauncherRecipe(HookType.WEB, "dye:8", "dye:12", "mithril_ingot", "obsidian");
        super.preInit(event);
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void preInitClient(FMLPreInitializationEvent event) {
        this.getRegistrator().registerRenderingHandler(HookShot.class, (Render)new HookShotRenderer());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.printInitMsg((FMLEvent)event);
        this.getRegistrator().registerNetMessageForServer(Launcher.KeyPressedMsg.class, (IMessageHandler)new Launcher.KeyPressedMsg());
        this.getRegistrator().registerEntity((ForgeMod)this, HookShot.class, HookShot.RENDER_DISTANCE, 5, true);
        this.getRegistrator().registerInEventBus((Object)this);
        super.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.printInitMsg((FMLEvent)event);
        super.postInit(event);
    }

    @Mod.EventHandler
    public void onMissingMappings(FMLMissingMappingsEvent event) {
        HashMap<UnitId, Hook> hookMap = new HashMap<UnitId, Hook>();
        HashMap<UnitId, Launcher> launcherMap = new HashMap<UnitId, Launcher>();
        for (HookType element : HookType.values()) {
            hookMap.put(UnitId.from((String)this.getId(), (String)("hook" + element.name().toLowerCase(Locale.ROOT))), element.hook);
            launcherMap.put(UnitId.from((String)this.getId(), (String)("hooklauncher" + element.name().toLowerCase(Locale.ROOT))), element.launcher);
        }
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.getAll()) {
            UnitId oldId = UnitId.from((String)mapping.name.toLowerCase(Locale.ROOT));
            if (mapping.type != GameRegistry.Type.ITEM) continue;
            Hook hook = (Hook)((Object)hookMap.get(oldId));
            Launcher launcher = (Launcher)((Object)launcherMap.get(oldId));
            if (hook != null) {
                mapping.remap((Item)hook);
            }
            if (launcher == null) continue;
            mapping.remap((Item)launcher);
        }
    }

    public String getId() {
        return ID;
    }

    private void addWebRecipe() {
        String pattern = "101 010 101";
        String web = "web";
        UnitConfig config = new UnitConfig(this.getConfig().getConfigDir(), ForgeLocating.Folders.items.name(), HookType.WEB.name());
        CraftingRecipe main = CraftingRecipe.CreateMain((ForgeConfig)config, (String)pattern, (String)web, (int)1, (String[])new String[]{"string"});
        CraftingRecipe reserve = CraftingRecipe.CreateReserve((ForgeConfig)config, (String)pattern, (String)web, (int)1, (String[])new String[]{"string"});
        this.getRegistrator().addCrafting(main, reserve);
        config.save();
    }

    private void addHookRecipe(HookType hookType, String pattern, String[] mainComponents, String[] reserveComponents) {
        int amount = 1;
        Hook hook = hookType.hook;
        ForgeConfig config = hook.getConfig();
        String id = hook.getStringId();
        CraftingRecipe main = CraftingRecipe.CreateMain((ForgeConfig)config, (String)pattern, (String)id, (int)amount, (String[])mainComponents);
        CraftingRecipe reserve = CraftingRecipe.CreateReserve((ForgeConfig)config, (String)pattern, (String)id, (int)amount, (String[])reserveComponents);
        this.getRegistrator().addCrafting(main, reserve);
        config.save();
    }

    private void addLauncherRecipe(HookType hookType, String mainDye, String reserveDye, String mainMaterial, String reserveMaterial) {
        ForgeConfig config = hookType.launcher.getConfig();
        String pattern = "123 242 521";
        String launcher = hookType.launcher.getStringId();
        String hook = hookType.hook.getStringId();
        String reel = "string";
        String button = "wooden_button";
        CraftingRecipe main = CraftingRecipe.CreateMain((ForgeConfig)config, (String)pattern, (String)launcher, (int)1, (String[])new String[]{mainDye, mainMaterial, hook, reel, button});
        CraftingRecipe reserve = CraftingRecipe.CreateReserve((ForgeConfig)config, (String)pattern, (String)launcher, (int)1, (String[])new String[]{reserveDye, reserveMaterial, hook, reel, button});
        this.getRegistrator().addCrafting(main, reserve);
        config.save();
    }

    public String getName() {
        return NAME;
    }

    public ForgeMod getInstance() {
        return instance;
    }
}

