/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.shot;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.ForgeMain;
import com.endertech.minecraft.forge.ForgeWorld;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.BlockPos;
import com.endertech.minecraft.forge.math.Combustion;
import com.endertech.minecraft.forge.math.ForgeMath;
import com.endertech.minecraft.forge.math.Rotation;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.messages.MotionMsg;
import com.endertech.minecraft.mods.adhooks.Hook;
import com.endertech.minecraft.mods.adhooks.Launcher;
import com.endertech.minecraft.mods.adhooks.Rope;
import com.endertech.minecraft.mods.adhooks.init.HookType;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.IThrowableEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class HookShot
extends ForgeEntity
implements IThrowableEntity,
IProjectile {
    public static final float COLLISION_REDUCTION = 0.5f;
    public static final float GRAVITY_VELOCITY = 0.005f;
    public static final int RENDER_DISTANCE = Rope.LENGTH_BOUNDS.max;
    protected float shootStrength = 1.5f;
    protected float size = 0.6f;
    protected Map<Entity, Vect3d> lastAddedMotionsList = new ConcurrentHashMap<Entity, Vect3d>();
    private EnumFacing hitSide = null;
    private Combustion combustion = new Combustion();

    public HookShot(World world) {
        super(world);
        this.field_70155_l = 10.0;
        this.func_70105_a(this.size, this.size);
    }

    public HookShot(World world, EntityLivingBase shooter, HookType hookType) {
        this(world);
        this.setWatched(WatchedInt.SHOOTER_ID, ForgeEntity.getId((Entity)shooter));
        this.setHookType(hookType);
        this.func_70012_b(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v, shooter.field_70177_z, shooter.field_70125_A);
        this.field_70165_t -= (double)(ForgeMath.cos((float)this.field_70177_z) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(ForgeMath.sin((float)this.field_70177_z) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        this.field_70159_w = -ForgeMath.sin((float)this.field_70177_z) * ForgeMath.cos((float)this.field_70125_A);
        this.field_70179_y = ForgeMath.cos((float)this.field_70177_z) * ForgeMath.cos((float)this.field_70125_A);
        this.field_70181_x = -ForgeMath.sin((float)this.field_70125_A);
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, this.shootStrength, 1.0f);
        this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "random.bow", 4.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        for (WatchedBool watchedBool : WatchedBool.values()) {
            this.field_70180_af.func_75682_a(watchedBool.getId(), (Object)0);
        }
        for (Enum enum_ : WatchedInt.values()) {
            this.field_70180_af.func_75682_a(((WatchedInt)enum_).getId(), (Object)0);
        }
        for (Enum enum_ : WatchedFloat.values()) {
            this.field_70180_af.func_75682_a(((WatchedFloat)enum_).getId(), (Object)Float.valueOf(0.0f));
        }
        this.setState(State.SHOOTING);
    }

    public boolean isBoosting() {
        return this.getWatched(WatchedBool.BOOSTING);
    }

    public void setBoosting(boolean boosting) {
        this.setWatched(WatchedBool.BOOSTING, boosting);
    }

    public boolean isLoosening() {
        return this.getWatched(WatchedBool.LOOSENING);
    }

    public void setLoosening(boolean loosening) {
        this.setWatched(WatchedBool.LOOSENING, loosening);
    }

    public boolean isPulling() {
        return this.getWatched(WatchedBool.PULLING);
    }

    public void setPulling(boolean pulling) {
        this.setWatched(WatchedBool.PULLING, pulling);
    }

    public State getState() {
        int i = this.getWatched(WatchedInt.STATE);
        return State.values()[i];
    }

    public State getPrevState() {
        int i = this.getWatched(WatchedInt.PREV_STATE);
        return State.values()[i];
    }

    public void setState(State state) {
        State prevState = this.getState();
        if (state != prevState) {
            this.setWatched(WatchedInt.PREV_STATE, prevState.ordinal());
            this.setWatched(WatchedInt.STATE, state.ordinal());
        }
    }

    public float getRopeLength() {
        return this.getWatched(WatchedFloat.ROPE_LENGTH);
    }

    public void setRopeLength(float ropeLength) {
        this.setWatched(WatchedFloat.ROPE_LENGTH, ropeLength);
    }

    public float getSagging() {
        return this.getWatched(WatchedFloat.SAGGING);
    }

    public void setSagging(float sagging) {
        if (sagging < 0.0f) {
            sagging = 0.0f;
        }
        this.setWatched(WatchedFloat.SAGGING, sagging);
    }

    public boolean getWatched(WatchedBool b) {
        return this.field_70180_af.func_75679_c(b.getId()) != 0;
    }

    protected void setWatched(WatchedBool b, boolean value) {
        this.field_70180_af.func_75692_b(b.getId(), (Object)(value ? 1 : 0));
    }

    public float getWatched(WatchedFloat f) {
        return this.field_70180_af.func_111145_d(f.getId());
    }

    protected void setWatched(WatchedFloat f, float value) {
        this.field_70180_af.func_75692_b(f.getId(), (Object)Float.valueOf(value));
    }

    public int getWatched(WatchedInt i) {
        return this.field_70180_af.func_75679_c(i.getId());
    }

    protected void setWatched(WatchedInt i, int value) {
        this.field_70180_af.func_75692_b(i.getId(), (Object)value);
    }

    public void setHookType(HookType value) {
        if (value != null) {
            this.field_70180_af.func_75692_b(WatchedInt.HOOK_TYPE.getId(), (Object)value.ordinal());
        }
    }

    public HookType getHookType() {
        int ordinal = this.field_70180_af.func_75679_c(WatchedInt.HOOK_TYPE.getId());
        return HookType.values()[ordinal];
    }

    public boolean canHookOnReeling() {
        return this.getHookType() == HookType.PUDGE;
    }

    public boolean canHookBlocks() {
        return this.getHookType() != HookType.PUDGE;
    }

    public boolean canHookEntities() {
        return true;
    }

    public Vect3d getHitPosition() {
        return Vect3d.from((double)this.getWatched(WatchedFloat.HIT_X), (double)this.getWatched(WatchedFloat.HIT_Y), (double)this.getWatched(WatchedFloat.HIT_Z));
    }

    public Vect3d getLauncherPosition() {
        return ForgeEntity.getBBCenter((AxisAlignedBB)ForgeEntity.getBB((Entity)this.getThrower()));
    }

    public Vect3d getLauncherPosition(float tickProgress) {
        return ForgeEntity.getBBCenter((AxisAlignedBB)ForgeEntity.getBB((Entity)this.getThrower(), (Vect3d)this.getCurPosition(tickProgress)));
    }

    public void setHitPosition(Vect3d hitPosition) {
        if (hitPosition != null) {
            this.setWatched(WatchedFloat.HIT_X, (float)hitPosition.x);
            this.setWatched(WatchedFloat.HIT_Y, (float)hitPosition.y);
            this.setWatched(WatchedFloat.HIT_Z, (float)hitPosition.z);
        }
    }

    public boolean isHookingBlock() {
        return this.getState() == State.HOOKING_BLOCK;
    }

    public boolean isHookingEntity() {
        return this.getState() == State.HOOKING_ENTITY;
    }

    public boolean isHookingTarget() {
        switch (this.getState()) {
            case HOOKING_BLOCK: 
            case HOOKING_ENTITY: {
                return true;
            }
        }
        return false;
    }

    private void boostUpShooter() {
        EntityLivingBase shooter = this.getThrower();
        Launcher launcher = this.getLauncher();
        if (shooter != null && launcher != null) {
            this.sendMotion((Entity)shooter, MotionMsg.Type.add, Vect3d.from((double)0.0, (double)launcher.boostStrength, (double)0.0), false);
            HookShot.setFallDistance((Entity)shooter, (float)0.0f, (boolean)true);
        }
    }

    public boolean launcherInMainHand() {
        ItemStack itemStack = this.getThrower() != null ? this.getThrower().func_71124_b(0) : null;
        return itemStack != null && itemStack.func_77973_b() instanceof Launcher && Launcher.isAttachedToHookShot(itemStack, this);
    }

    public BlockPos getHookedBlockPos() {
        return BlockPos.from((int)this.getWatched(WatchedInt.HOOKED_BLOCK_X), (int)this.getWatched(WatchedInt.HOOKED_BLOCK_Y), (int)this.getWatched(WatchedInt.HOOKED_BLOCK_Z));
    }

    public void setHookedBlockPos(MovingObjectPosition hitData) {
        if (hitData != null) {
            this.setWatched(WatchedInt.HOOKED_BLOCK_X, hitData.field_72311_b);
            this.setWatched(WatchedInt.HOOKED_BLOCK_Y, hitData.field_72312_c);
            this.setWatched(WatchedInt.HOOKED_BLOCK_Z, hitData.field_72309_d);
        }
    }

    protected EnumFacing getFacingFrom(int hitSide) {
        switch (hitSide) {
            case 0: {
                return EnumFacing.DOWN;
            }
            case 1: {
                return EnumFacing.UP;
            }
            case 2: {
                return EnumFacing.NORTH;
            }
            case 3: {
                return EnumFacing.SOUTH;
            }
            case 4: {
                return EnumFacing.WEST;
            }
            case 5: {
                return EnumFacing.EAST;
            }
        }
        return null;
    }

    protected void onTargetHit(MovingObjectPosition hitData) {
        if (hitData == null) {
            return;
        }
        if (this.getState() == State.REELING && !this.canHookOnReeling()) {
            return;
        }
        Vect3d hitPosition = Vect3d.from((Vec3)hitData.field_72307_f);
        switch (hitData.field_72313_a) {
            case BLOCK: {
                if (!this.canHookBlocks()) {
                    this.setState(State.REELING);
                    return;
                }
                this.hitSide = this.getFacingFrom(hitData.field_72310_e);
                this.setHookedBlockPos(hitData);
                this.setHitPosition(hitPosition);
                this.setState(State.HOOKING_BLOCK);
                break;
            }
            case ENTITY: {
                IEntityMultiPart dragon;
                Entity target = hitData.field_72308_g;
                if (target instanceof EntityDragonPart && (dragon = ((EntityDragonPart)target).field_70259_a) instanceof Entity) {
                    target = (Entity)dragon;
                }
                if (target == null) break;
                Hook hook = this.getHookType().hook;
                if (hook != null && this.getThrower() != null && hook.damage > 0.0f) {
                    DamageSource damageSource = new EntityDamageSourceIndirect("arrow", (Entity)this, (Entity)this.getThrower()).func_76349_b();
                    target.func_70097_a(damageSource, hook.damage);
                }
                if (!this.canHookEntities()) {
                    this.setState(State.REELING);
                    return;
                }
                this.setWatched(WatchedInt.HOOKED_ENTITY_ID, target.func_145782_y());
                this.setState(State.HOOKING_ENTITY);
                break;
            }
            default: {
                return;
            }
        }
        float ropeLength = (float)(this.getLauncherPosition().distance(hitPosition) + (double)this.getHookType().launcher.reelingSpeed);
        this.setRopeLength(ropeLength);
        this.func_85030_a("random.bowhit", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
    }

    private void updatePhysics() {
        if (!this.isServerSide()) {
            return;
        }
        HookType hookType = this.getHookType();
        EntityLivingBase shooter = this.getThrower();
        if (shooter == null || shooter.field_70128_L || hookType.launcher == null || hookType.hook == null || hookType.rope == null || this.isServerSide() && shooter instanceof EntityPlayer && Launcher.findAttachedLauncher(((EntityPlayer)shooter).field_71071_by, this) == null) {
            this.func_70106_y();
            return;
        }
        State state = this.getState();
        Vect3d launcherPosition = this.getLauncherPosition();
        Vect3d tensionVec = Vect3d.ZERO;
        float tensionForce = 0.0f;
        float hookDistance = this.getHookDistance();
        float ropeMaxLength = hookType.rope.maxLength;
        float ropeLength = this.getWatched(WatchedFloat.ROPE_LENGTH);
        float ropeMinLength = Math.min(shooter.field_70130_N, shooter.field_70131_O);
        float reelingSpeed = hookType.launcher.reelingSpeed;
        switch (state) {
            case SHOOTING: {
                ropeLength = hookDistance + reelingSpeed;
                if (!(ropeLength > ropeMaxLength)) break;
                state = State.REELING;
                break;
            }
            case REELING: {
                Vect3d motionVec = launcherPosition.subtract(this.getCurPosition()).normalize().scale((double)(reelingSpeed * 3.0f));
                this.setMotion(motionVec);
                float hookNextDistance = (float)launcherPosition.distance(this.getNextPosition());
                ropeLength = hookDistance;
                if (!(ropeLength <= ropeMinLength) && !(hookDistance <= hookNextDistance)) break;
                this.func_70106_y();
                break;
            }
            case HOOKING_BLOCK: 
            case HOOKING_ENTITY: {
                if (!(ropeLength < hookDistance)) break;
                tensionForce = hookType.rope.getTensionForce(ropeLength, hookDistance);
                tensionVec = this.getCurPosition().subtract(launcherPosition).normalize().scale((double)tensionForce);
                if (tensionForce > hookType.hook.strength) {
                    state = State.REELING;
                    break;
                }
                HookShot.setFallDistance((Entity)shooter, (float)0.0f, (boolean)true);
                break;
            }
        }
        switch (state) {
            case HOOKING_BLOCK: {
                this.sendMotion((Entity)shooter, MotionMsg.Type.add, tensionVec, true);
                break;
            }
            case HOOKING_ENTITY: {
                Entity target = this.findHookedEntity();
                if (target == null) break;
                float shooterWeight = HookShot.getWeight((Entity)shooter, (boolean)true, (boolean)true) * 1.5f;
                float targetWeight = HookShot.getWeight((Entity)target, (boolean)true, (boolean)true);
                float totalWeight = shooterWeight + targetWeight;
                ropeMinLength = (Math.max(shooter.field_70130_N, shooter.field_70131_O) + Math.max(target.field_70130_N, target.field_70131_O)) / 2.0f;
                if (totalWeight == 0.0f) {
                    totalWeight = 1.0f;
                }
                if (ropeLength <= hookDistance) {
                    HookShot.setFallDistance((Entity)target, (float)0.0f, (boolean)true);
                }
                if (hookType == HookType.PUDGE && ropeLength <= ropeMinLength) {
                    this.sendMotion(target, MotionMsg.Type.set, Vect3d.ZERO, true);
                    this.func_70106_y();
                    break;
                }
                Vect3d motionVec = tensionVec.invert().scale((double)(shooterWeight / totalWeight));
                this.sendMotion(target, MotionMsg.Type.add, motionVec, true);
                motionVec = tensionVec.scale((double)(targetWeight / totalWeight));
                this.sendMotion((Entity)shooter, MotionMsg.Type.add, motionVec, true);
                break;
            }
        }
        ropeLength = CommonMath.Range.enclose((float)ropeLength, (float)ropeMinLength, (float)ropeMaxLength);
        this.setRopeLength(ropeLength);
        this.setSagging(ropeLength - hookDistance);
        this.setState(state);
        this.setTensionForce(tensionForce);
    }

    private void setTensionForce(float tensionForce) {
        this.setWatched(WatchedFloat.TENSION_FORCE, tensionForce);
    }

    public float getHookDistance() {
        return (float)this.getLauncherPosition().distance(this.getCurPosition());
    }

    private void updateControlling() {
        if (!this.isServerSide()) {
            return;
        }
        HookType hookType = this.getHookType();
        EntityLivingBase shooter = this.getThrower();
        if (!this.launcherInMainHand() || hookType == null || hookType.launcher == null || shooter == null) {
            return;
        }
        float ropeLength = this.getRopeLength();
        float pullingSpeed = hookType.launcher.reelingSpeed;
        if (shooter.func_70093_af()) {
            pullingSpeed *= 0.5f;
        }
        if (this.isBoosting()) {
            pullingSpeed *= 4.0f;
            if (this.isPulling() && this.isHookingBlock() && CommonMath.notZero((double)this.getTensionForce())) {
                this.boostUpShooter();
            }
            this.setState(State.REELING);
        }
        if (this.isPulling()) {
            ropeLength -= pullingSpeed;
        }
        if (this.isLoosening()) {
            ropeLength += pullingSpeed;
        }
        switch (this.getState()) {
            case HOOKING_BLOCK: {
                if (!shooter.func_70051_ag() || !CommonMath.notZero((double)this.getTensionForce())) break;
                ropeLength += pullingSpeed;
                break;
            }
            case HOOKING_ENTITY: {
                if (hookType != HookType.PUDGE || this.isLoosening()) break;
                ropeLength -= pullingSpeed * 2.0f;
                break;
            }
        }
        this.setRopeLength(ropeLength);
    }

    @Nullable
    public Rope getRope() {
        HookType hookType = this.getHookType();
        return hookType != null ? hookType.rope : null;
    }

    @Nullable
    public Launcher getLauncher() {
        HookType hookType = this.getHookType();
        return hookType != null ? hookType.launcher : null;
    }

    @Nullable
    public Hook getHook() {
        HookType hookType = this.getHookType();
        return hookType != null ? hookType.hook : null;
    }

    public void sendMotion(Entity target, MotionMsg.Type type, Vect3d motion, boolean reduction) {
        if (this.isServerSide() && target != null && type != null && motion != null) {
            if (target.func_70115_ae()) {
                target = ForgeEntity.getLowestRiding((Entity)target);
            }
            if (reduction) {
                Vect3d lastAddedMotion = this.lastAddedMotionsList.getOrDefault(target, Vect3d.ZERO);
                if (type == MotionMsg.Type.add) {
                    this.lastAddedMotionsList.put(target, motion);
                    if (lastAddedMotion.isZero() && motion.length() < 1.0E-4) {
                        return;
                    }
                    Rope rope = this.getRope();
                    float motionReduction = rope != null ? rope.getMotionReduction() : 0.0f;
                    motion = motion.subtract(lastAddedMotion.scale((double)motionReduction));
                }
            }
            if (target instanceof EntityPlayer) {
                MotionMsg motionMsg = new MotionMsg(target, type, motion);
                ForgeMain.instance.getRegistrator().networkChannel.sendTo((IMessage)motionMsg, (EntityPlayerMP)target);
            } else {
                switch (type) {
                    case add: {
                        HookShot.addMotion((Entity)target, (Vect3d)motion);
                        break;
                    }
                    case set: {
                        HookShot.setMotion((Entity)target, (Vect3d)motion);
                        break;
                    }
                }
            }
        }
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        this.func_70106_y();
    }

    public boolean func_70067_L() {
        return false;
    }

    public EntityLivingBase getThrower() {
        Entity entity = ForgeWorld.findEntity((World)this.field_70170_p, (int)this.getWatched(WatchedInt.SHOOTER_ID));
        return entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
    }

    public void setThrower(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            this.setWatched(WatchedInt.SHOOTER_ID, ForgeEntity.getId((Entity)entity));
        }
    }

    public Block getHookedBlock() {
        return ForgeWorld.getBlock((World)this.field_70170_p, (BlockPos)this.getHookedBlockPos());
    }

    public boolean hookedBlockExists() {
        return this.getHookedBlock() != Blocks.field_150350_a;
    }

    @Nullable
    public Entity findHookedEntity() {
        return HookShot.findEntity((World)this.field_70170_p, (int)this.getWatched(WatchedInt.HOOKED_ENTITY_ID));
    }

    public boolean hookedEntityIsAlive() {
        Entity entity = this.findHookedEntity();
        return entity != null && entity.func_70089_S();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.move();
        this.setPrevRotation(this.getCurRotation());
        this.updateControlling();
        this.updateCombustion();
        this.updatePhysics();
        this.updateCollisions();
        this.updateTargetState();
        this.updateMotion();
        this.updateRotation();
        if (this.isClientSide()) {
            this.expandHitBoxToShooter();
        }
    }

    private void updateCombustion() {
        if (this.isServerSide()) {
            double fireResistance = this.getHookType().hook.resistance;
            boolean fireInfluenced = false;
            switch (this.getState()) {
                case HOOKING_BLOCK: {
                    fireInfluenced = ForgeWorld.getBlock((World)this.field_70170_p, (BlockPos)this.getHookedBlockPos().offset(this.hitSide)) == Blocks.field_150480_ab;
                    break;
                }
                case HOOKING_ENTITY: {
                    Entity entity = this.findHookedEntity();
                    fireInfluenced = entity != null && entity.func_70027_ad();
                    break;
                }
            }
            if (this.func_70027_ad()) {
                this.combustion.fire();
            }
            if (this.combustion.getFireInfluencedTime().inSeconds() > fireResistance) {
                this.combustion.fire();
            }
            if (this.combustion.isBurning()) {
                this.func_70015_d(1);
            }
            if (this.combustion.getBurningTime().inSeconds() > fireResistance) {
                this.func_70106_y();
            }
            this.combustion.update(fireInfluenced);
        }
    }

    private void updateCollisions() {
        if (!this.isServerSide()) {
            return;
        }
        State state = this.getState();
        if (this.isHookingTarget()) {
            return;
        }
        if (state == State.REELING) {
            if (!this.canHookOnReeling()) {
                return;
            }
            if (this.getHookType() == HookType.PUDGE && this.getPrevState() == State.HOOKING_ENTITY) {
                return;
            }
        }
        ArrayList<MovingObjectPosition> hitDataList = new ArrayList<MovingObjectPosition>();
        if (this.field_70170_p != null) {
            hitDataList.add(this.field_70170_p.func_72933_a(this.getPrevPosition().toVec3(), this.getCurPosition().toVec3()));
        }
        AxisAlignedBB aaBB = this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        List list = this.getEntitiesWithinAABB(aaBB);
        EntityLivingBase shooter = this.getThrower();
        Entity shooterRide = shooter != null ? shooter.field_70154_o : null;
        for (Entity target : list) {
            MovingObjectPosition hitData;
            if (target == shooter && state == State.REELING) {
                this.func_70106_y();
                return;
            }
            if (!this.isServerSide() || !target.func_70067_L() || target == shooter || target == shooterRide || target.field_70121_D == null || (hitData = target.field_70121_D.func_72327_a(this.getCurPosition().toVec3(), this.getNextPosition().toVec3())) == null) continue;
            hitDataList.add(new MovingObjectPosition(target, HookShot.getCenterPosition((Entity)target).toVec3()));
        }
        MovingObjectPosition nearestHitData = null;
        double minDistance = Double.MAX_VALUE;
        for (MovingObjectPosition hitData : hitDataList) {
            double distance;
            if (hitData == null || !((distance = this.getCurPosition().distance(Vect3d.from((Vec3)hitData.field_72307_f))) < minDistance)) continue;
            nearestHitData = hitData;
            minDistance = distance;
        }
        if (nearestHitData != null) {
            this.onTargetHit(nearestHitData);
        }
    }

    private void updateTargetState() {
        if (this.isServerSide()) {
            switch (this.getState()) {
                case HOOKING_BLOCK: {
                    if (this.hookedBlockExists()) break;
                    this.setState(State.REELING);
                    break;
                }
                case HOOKING_ENTITY: {
                    Entity target = this.findHookedEntity();
                    if (!(target == null || target.field_70128_L || target instanceof EntityLivingBase && ((EntityLivingBase)target).field_82175_bq && target.func_70093_af() || target instanceof EntityPlayer && target.func_70115_ae() && ((EntityPlayer)target).field_82175_bq) && (!(target.field_70153_n instanceof EntityPlayer) || !((EntityPlayer)target.field_70153_n).field_82175_bq)) break;
                    this.setState(State.REELING);
                    break;
                }
            }
        }
    }

    private void updateRotation() {
        Vect3d motion;
        if (!this.isHookingTarget() && (motion = this.getMotion()).notZero()) {
            if (this.getState() == State.REELING) {
                motion = motion.invert();
            }
            this.setCurRotation(motion.rotation());
        }
    }

    private void updateMotion() {
        State state = this.getState();
        switch (state) {
            case HOOKING_BLOCK: {
                if (!this.hookedBlockExists()) break;
                this.setAllPositions(this.getHitPosition());
                this.stopMoving();
                this.field_70122_E = true;
                break;
            }
            case HOOKING_ENTITY: {
                Entity entity = this.findHookedEntity();
                if (entity != null) {
                    this.stopMoving();
                    Vect3d offsetToCenter = HookShot.getCenterPosition((Entity)entity).subtract(HookShot.getCurPosition((Entity)entity));
                    this.setPrevPosition(HookShot.getLastTickPosition((Entity)entity).add(offsetToCenter));
                    this.setLastTickPosition(HookShot.getLastTickPosition((Entity)entity).add(offsetToCenter));
                    this.setCurPosition(HookShot.getCurPosition((Entity)entity).add(offsetToCenter));
                    if (this.getHookType() == HookType.PUDGE) {
                        HookShot.dismount((Entity)entity);
                    }
                }
                this.field_70122_E = true;
                break;
            }
            default: {
                this.field_70122_E = false;
                double motionFactor = 0.99f;
                if (this.func_70090_H()) {
                    double factor = 0.25;
                    for (int i = 0; i < 4; ++i) {
                        this.field_70170_p.func_72869_a("bubble", this.field_70165_t - this.field_70159_w * factor, this.field_70163_u - this.field_70181_x * factor, this.field_70161_v - this.field_70179_y * factor, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                    }
                    motionFactor = 0.8f;
                }
                this.setMotion(this.getMotion().scale(motionFactor));
                this.field_70181_x -= (double)0.005f;
            }
        }
    }

    private void expandHitBoxToShooter() {
        EntityLivingBase shooter = this.getThrower();
        if (shooter != null) {
            Vect3d shooterCenter = ForgeEntity.getCenterPosition((Entity)shooter);
            this.setBB(this.getBBCenter(), shooterCenter);
        }
    }

    public void func_70186_c(double x, double y, double z, float f, float f1) {
        Vect3d vec = Vect3d.from((double)x, (double)y, (double)z).normalize().scale((double)f);
        Rotation rotation = new Rotation(vec.pitch(), vec.yaw());
        this.setMotion(vec);
        this.setAllRotations(rotation);
    }

    public boolean func_70075_an() {
        return this.getHookType() == HookType.PUDGE;
    }

    public void func_70106_y() {
        InventoryPlayer inventory;
        ItemStack launcher;
        if (this.getThrower() instanceof EntityPlayer && (launcher = Launcher.findAttachedLauncher(inventory = ((EntityPlayer)this.getThrower()).field_71071_by, this)) != null) {
            Launcher.unattach(launcher);
        }
        super.func_70106_y();
    }

    public float getTensionForce() {
        return this.getWatched(WatchedFloat.TENSION_FORCE);
    }

    public static enum State {
        SHOOTING,
        REELING,
        HOOKING_BLOCK,
        HOOKING_ENTITY;

    }

    public static enum WatchedFloat {
        HIT_X,
        HIT_Y,
        HIT_Z,
        ROPE_LENGTH,
        SAGGING,
        TENSION_FORCE;


        public int getId() {
            return this.ordinal() + 20;
        }
    }

    public static enum WatchedInt {
        HOOKED_BLOCK_X,
        HOOKED_BLOCK_Y,
        HOOKED_BLOCK_Z,
        HOOKED_ENTITY_ID,
        HOOK_TYPE,
        SHOOTER_ID,
        STATE,
        PREV_STATE;


        public int getId() {
            return this.ordinal() + 10;
        }
    }

    public static enum WatchedBool {
        PULLING,
        LOOSENING,
        BOOSTING;


        public int getId() {
            return this.ordinal() + 3;
        }
    }
}

