/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.shot;

import com.endertech.common.CommonMath;
import com.endertech.common.CommonString;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.ForgeLocating;
import com.endertech.minecraft.forge.ForgeRendering;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Rotation;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.mods.adhooks.Rope;
import com.endertech.minecraft.mods.adhooks.init.HookType;
import com.endertech.minecraft.mods.adhooks.shot.HookShot;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class HookShotRenderer
extends Render {
    public ResourceLocation getTextureLocation(HookType hookType, String namePostfix) {
        String name = (hookType != null && hookType.hook != null ? hookType.hook.getId().getRegName() : "null") + (CommonString.isNullOrEmpty((String)namePostfix) ? "" : "_" + namePostfix);
        return ForgeLocating.itemTexture((String)"adhooks", (String)name, (String[])new String[0]);
    }

    public ResourceLocation getTextureLocation(HookType hookType) {
        return this.getTextureLocation(hookType, "");
    }

    public ResourceLocation getBackTextureLocation(HookType hookType) {
        return this.getTextureLocation(hookType, "back");
    }

    public void renderShot(HookShot hookShot, double x, double y, double z, float yaw, float tickProgress) {
        if (hookShot == null || hookShot.getHookType() == null) {
            return;
        }
        Tessellator tess = Tessellator.field_78398_a;
        HookType hookType = hookShot.getHookType();
        Rotation shotRotation = hookShot.getRotation(tickProgress);
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glDisable((int)2896);
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glRotatef((float)(shotRotation.yaw - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)shotRotation.pitch, (float)0.0f, (float)0.0f, (float)1.0f);
        switch (hookType) {
            case WEB: {
                this.func_110776_a(this.getBackTextureLocation(hookType));
                GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                break;
            }
            default: {
                this.func_110776_a(this.getTextureLocation(hookType));
                GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
                GL11.glRotated((double)45.0, (double)0.0, (double)0.0, (double)1.0);
            }
        }
        double scale = 0.5;
        GL11.glEnable((int)32826);
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        switch (hookType) {
            case WEB: {
                GL11.glTranslated((double)-0.5, (double)-0.5, (double)0.0);
                break;
            }
            default: {
                GL11.glTranslated((double)-0.9, (double)-0.1, (double)0.0);
            }
        }
        if (hookType.hook != null) {
            ForgeRendering.renderLike2D((Tessellator)tess, (IIcon)hookType.hook.getIcon());
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public void renderRope(HookShot hookShot, double x, double y, double z, float rotationYaw, float tickProgress) {
        Vect3d launcherOffset;
        boolean shooterIsMe;
        if (hookShot == null) {
            return;
        }
        EntityLivingBase shooter = hookShot.getThrower();
        if (shooter == null) {
            return;
        }
        Rotation shooterRotation = ForgeEntity.getRotation((Entity)shooter, (float)tickProgress);
        boolean bl = shooterIsMe = shooter == Minecraft.func_71410_x().field_71439_g;
        if (shooterIsMe) {
            switch (this.field_76990_c.field_78733_k.field_74320_O) {
                case 1: 
                case 2: {
                    launcherOffset = Vect3d.from((double)-0.1, (double)-0.8, (double)0.0);
                    break;
                }
                default: {
                    launcherOffset = Vect3d.from((double)-0.1, (double)-0.1, (double)0.0);
                    launcherOffset = launcherOffset.rotateAroundX(-shooterRotation.pitch).rotateAroundY(-shooterRotation.yaw);
                    break;
                }
            }
        } else {
            launcherOffset = Vect3d.from((double)-0.1, (double)1.0, (double)0.0);
        }
        Vect3d launcherPos = ForgeEntity.getCurPosition((Entity)shooter, (float)tickProgress).add(launcherOffset);
        Vect3d hookShotPos = hookShot.getCurPosition(tickProgress);
        Vect3d ropeVec = launcherPos.subtract(hookShotPos);
        HookType hookType = hookShot.getHookType();
        if (hookType.rope != null) {
            Rope rope = hookType.rope;
            float hookStrength = hookType.hook != null ? hookType.hook.strength : 0.0f;
            float tensionForce = hookShot.getTensionForce();
            float tensionFactor = CommonMath.notZero((double)hookStrength) && CommonMath.notZero((double)rope.elasticity) ? tensionForce / hookStrength : 0.0f;
            float ropeWidth = CommonMath.Approx.down((float)tensionFactor, (FloatBounds)new FloatBounds(Rope.WIDTH_BOUNDS.min, Float.valueOf(shooterIsMe ? rope.width : 4.0f)));
            float sagging = hookShot.getSagging();
            Vect3d viewPos = Vect3d.from((double)this.field_76990_c.field_78730_l, (double)this.field_76990_c.field_78731_m, (double)this.field_76990_c.field_78728_n);
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)8192);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)2884);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2848);
            GL11.glTranslated((double)x, (double)y, (double)z);
            if (rope.color != null) {
                GL11.glColor3f((float)rope.color.getRed().toFloat(), (float)rope.color.getGreen().toFloat(), (float)rope.color.getBlue().toFloat());
            }
            Vect3d fromPoint = Vect3d.ZERO;
            for (int i = 1; i <= rope.segmentsAmount; ++i) {
                float f = i;
                rope.getClass();
                float ropeProgress = f / 16.0f;
                float sagHeight = MathHelper.func_76126_a((float)(ropeProgress * (float)Math.PI)) * sagging;
                Vect3d toPoint = Vect3d.from((double)(ropeVec.x * (double)ropeProgress), (double)(ropeVec.y * (double)ropeProgress - (double)sagHeight), (double)(ropeVec.z * (double)ropeProgress));
                float viewDistance = (float)viewPos.distance(hookShotPos.add(toPoint));
                float scale = CommonMath.notZero((double)viewDistance) ? 10.0f / viewDistance : 1.0f;
                float ropeWidthScaled = CommonMath.Approx.strictUp((float)scale, (FloatBounds)new FloatBounds(Rope.WIDTH_BOUNDS.min, Float.valueOf(ropeWidth)));
                GL11.glLineWidth((float)ropeWidthScaled);
                GL11.glBegin((int)1);
                GL11.glVertex3d((double)fromPoint.x, (double)fromPoint.y, (double)fromPoint.z);
                GL11.glVertex3d((double)toPoint.x, (double)toPoint.y, (double)toPoint.z);
                GL11.glEnd();
                fromPoint = toPoint;
            }
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float yaw, float tickProgress) {
        if (entity instanceof HookShot) {
            HookShot hookShot = (HookShot)entity;
            if (hookShot.getState() != HookShot.State.HOOKING_ENTITY) {
                this.renderShot(hookShot, x, y, z, yaw, tickProgress);
            }
            this.renderRope(hookShot, x, y, z, yaw, tickProgress);
        }
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return null;
    }
}

