/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge;

import com.endertech.minecraft.forge.configs.ModConfig;
import com.endertech.minecraft.forge.regs.ForgeRegistrator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ForgeMod {
    private ModConfig config;
    private final Logger logger = LogManager.getLogger((String)this.getId());
    private final ForgeRegistrator registrator = new ForgeRegistrator(this);

    public abstract String getId();

    public abstract String getName();

    protected ForgeMod() {
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.getRegistrator().onPreInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.getRegistrator().onInit(event);
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void initClient(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void interModCom(FMLInterModComms.IMCEvent event) {
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.getRegistrator().onPostInit(event);
    }

    public void printInitMsg(FMLEvent event) {
        if (event != null) {
            this.getLogger().info("{} of '{}'", new Object[]{event.description(), this.getName()});
        }
    }

    public ForgeRegistrator getRegistrator() {
        return this.registrator;
    }

    public ModConfig getConfig() {
        return this.config;
    }

    protected void setConfig(ModConfig config) {
        this.config = config;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public abstract ForgeMod getInstance();
}

