/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge;

import com.endertech.minecraft.forge.math.BlockPos;
import com.endertech.minecraft.forge.math.ForgeMath;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.units.BlockState;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public final class ForgeWorld {
    public static void explodeBlock(World world, BlockPos pos, @Nullable Entity exploder, float strength, boolean fire) {
        world.func_72885_a(exploder, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), strength, fire, fire);
        ForgeWorld.setBlockToAir(world, pos);
    }

    public static boolean isServerSide(World world) {
        return world != null && !world.field_72995_K;
    }

    public static boolean isClientSide(World world) {
        return world != null && world.field_72995_K;
    }

    @Nullable
    public static Entity findEntity(World world, int id) {
        return world != null ? world.func_73045_a(id) : null;
    }

    public static void setBlockToAir(World world, BlockPos pos) {
        world.func_147468_f(pos.getX(), pos.getY(), pos.getZ());
    }

    public static Block getBlock(World world, BlockPos pos) {
        if (world != null && pos != null) {
            return world.func_147439_a(pos.getX(), pos.getY(), pos.getZ());
        }
        return Blocks.field_150350_a;
    }

    public static Vect3d getBlockCenter(BlockPos pos) {
        return Vect3d.from(pos).add(ForgeMath.getBBCenter(AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0)));
    }

    public static int getBlockMeta(World world, BlockPos pos) {
        return world.func_72805_g(pos.getX(), pos.getY(), pos.getZ());
    }

    public static BlockState getBlockState(World world, BlockPos pos) {
        return BlockState.from(ForgeWorld.getBlock(world, pos), ForgeWorld.getBlockMeta(world, pos));
    }

    public static boolean isVerticalOpaque(World world, BlockPos pos) {
        return world.isSideSolid(pos.getX(), pos.getY(), pos.getZ(), ForgeDirection.UP) && world.isSideSolid(pos.getX(), pos.getY(), pos.getZ(), ForgeDirection.DOWN);
    }

    public static boolean isHorizOpaque(World world, BlockPos pos) {
        return world.isSideSolid(pos.getX(), pos.getY(), pos.getZ(), ForgeDirection.WEST) && world.isSideSolid(pos.getX(), pos.getY(), pos.getZ(), ForgeDirection.EAST) && world.isSideSolid(pos.getX(), pos.getY(), pos.getZ(), ForgeDirection.SOUTH) && world.isSideSolid(pos.getX(), pos.getY(), pos.getZ(), ForgeDirection.NORTH);
    }

    @Nullable
    public static TileEntity getTileEntity(World world, BlockPos pos) {
        return world != null && pos != null ? world.func_147438_o(pos.getX(), pos.getY(), pos.getZ()) : null;
    }

    public static void spawnParticle(World world, String name, Vect3d pos, Vect3d motion) {
        if (world != null) {
            world.func_72869_a(name, pos.x, pos.y, pos.z, motion.x, motion.y, motion.z);
        }
    }

    public static void setBlockMeta(World world, BlockPos pos, int meta) {
        world.func_72921_c(pos.getX(), pos.getY(), pos.getZ(), meta, 3);
    }

    @Nullable
    public static MovingObjectPosition rayTraceBlocks(World world, Vect3d curPos, Vect3d nextPos, boolean includeLiquids) {
        return world.func_72901_a(curPos.toVec3(), nextPos.toVec3(), includeLiquids);
    }

    public static class SnowMelter {
        public static boolean isSnow(World world, BlockPos pos) {
            return ForgeWorld.getBlock(world, pos) == Blocks.field_150431_aC;
        }

        private static BlockPos getSnowTopPos(World world, BlockPos startPos) {
            int offset = 1;
            while (SnowMelter.isSnow(world, startPos.up(offset))) {
                ++offset;
            }
            return startPos.up(offset - 1);
        }

        public static void meltLayerAt(World world, BlockPos pos) {
            if (SnowMelter.isSnow(world, pos)) {
                BlockPos meltPos = SnowMelter.getSnowTopPos(world, pos);
                int meta = ForgeWorld.getBlockMeta(world, meltPos);
                if (meta > 0) {
                    ForgeWorld.setBlockMeta(world, meltPos, meta - 1);
                } else {
                    ForgeWorld.setBlockToAir(world, meltPos);
                }
            }
        }
    }

    public static class Position {
        public static List<BlockPos> getAllAround(BlockPos pos, boolean includeCorners) {
            ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
            posList.add(pos.west());
            posList.add(pos.east());
            posList.add(pos.north());
            posList.add(pos.south());
            if (includeCorners) {
                posList.add(pos.west().north());
                posList.add(pos.west().south());
                posList.add(pos.east().north());
                posList.add(pos.east().south());
            }
            return posList;
        }

        public static double getDistance(BlockPos posA, BlockPos posB) {
            return Vect3d.distance(Vect3d.from(posA), Vect3d.from(posB));
        }
    }
}

