/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.materials;

import com.endertech.common.Args;
import com.endertech.common.Names;
import com.endertech.minecraft.forge.ForgeRecipe;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.materials.ISmeltable;
import com.endertech.minecraft.forge.materials.SmeltingData;
import com.endertech.minecraft.forge.units.ForgeStack;
import com.endertech.minecraft.forge.units.UnitId;

public class SmeltingRecipe
extends ForgeRecipe
implements ISmeltable {
    public final UnitId inputId;
    public final UnitId outputId;
    public final SmeltingData smeltingData;
    protected final ForgeConfig config;

    protected static SmeltingRecipe Create(ForgeRecipe.Type type, ForgeConfig config, String input, String output, int amount, float xp) {
        String category = Names.join(SmeltingRecipe.class.getSimpleName(), type.name());
        return new SmeltingRecipe(config, category, input, output, amount, xp);
    }

    public static SmeltingRecipe CreateMain(ForgeConfig config, String input, String output, int amount, float xp) {
        return SmeltingRecipe.Create(ForgeRecipe.Type.main, config, input, output, amount, xp);
    }

    public static SmeltingRecipe CreateReserve(ForgeConfig config, String input, String output, int amount, float xp) {
        return SmeltingRecipe.Create(ForgeRecipe.Type.reserve, config, input, output, amount, xp);
    }

    public SmeltingRecipe(ForgeConfig config, String category, String input, String output, int amount, float xp) {
        this.config = config;
        this.inputId = ForgeConfig.getUnitId(config, category, "inputId", UnitId.from(input), "Input unit id.\nId is a basic unit (block or item) identifier in <modId:unitName:meta> format.\nModId can be omitted for vanilla items. Meta can be omitted too if it equals 0.\nUnitName must be lowercase, words separated by '_', words order - from private to common (example: black_iron_ore).\nUnit name will be automatically converted to ore dictionary name with reverse word order (example: oreIronBlack).\nUse '*' char as meta value to specify all possible values.\nAlso you may use just ore dictionary name as full id.\n");
        this.outputId = ForgeConfig.getUnitId(config, category, "outputId", UnitId.from(output), "Output unit id.\nId is a basic unit (block or item) identifier in <modId:unitName:meta> format.\nModId can be omitted for vanilla items. Meta can be omitted too if it equals 0.\nUnitName must be lowercase, words separated by '_', words order - from private to common (example: black_iron_ore).\nUnit name will be automatically converted to ore dictionary name with reverse word order (example: oreIronBlack).\nUse '*' char as meta value to specify all possible values.\nAlso you may use just ore dictionary name as full id.\n");
        this.smeltingData = new SmeltingData(config, category, amount, xp);
    }

    public SmeltingRecipe(String inputName, String outputName, int amount, float xp) {
        this(null, null, inputName, outputName, amount, xp);
    }

    @Override
    public boolean isValid() {
        if (this.inputId.isEmpty()) {
            this.statusDescription = "EMPTY input";
            return false;
        }
        if (this.outputId.isEmpty()) {
            this.statusDescription = "EMPTY output";
            return false;
        }
        if (this.getSmeltingData().getAmount() <= 0) {
            this.statusDescription = "Wrong amount";
            return false;
        }
        return true;
    }

    public ForgeStack getInputStack() {
        return this.inputId.getItemState().toStack(1);
    }

    public ForgeStack getOutputStack() {
        return this.outputId.getItemState().toStack(this.getSmeltingData().getAmount());
    }

    @Override
    public SmeltingData getSmeltingData() {
        return this.smeltingData;
    }

    public String toString() {
        return SmeltingRecipe.class.getSimpleName() + Args.group(Args.get("status", SmeltingRecipe.getStatus(this)), Args.get("input", this.getInputStack().exists() ? this.getInputStack() : this.inputId), Args.get("output", this.getOutputStack().exists() ? this.getOutputStack() : this.outputId), Args.get("smeltingData", this.getSmeltingData()));
    }

    @Override
    public boolean isReadyToRegister() {
        return this.inputId.getItemState().exists() && this.outputId.getItemState().exists();
    }

    @Override
    public ForgeConfig getConfig() {
        return this.config;
    }
}

