/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.math;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.math.MathHelper;
import com.endertech.minecraft.forge.math.Vect3d;
import net.minecraft.util.AxisAlignedBB;

public final class ForgeMath {
    public static final float PI = (float)Math.PI;

    public static float cos(float degrees) {
        return MathHelper.cos(ForgeMath.getRadians(degrees));
    }

    public static float sin(float degrees) {
        return MathHelper.sin(ForgeMath.getRadians(degrees));
    }

    public static Vect3d getBBCenter(AxisAlignedBB bb) {
        if (bb != null) {
            return Vect3d.from(CommonMath.getAverage(bb.field_72340_a, bb.field_72336_d), CommonMath.getAverage(bb.field_72338_b, bb.field_72337_e), CommonMath.getAverage(bb.field_72339_c, bb.field_72334_f));
        }
        return Vect3d.ZERO;
    }

    public static float getDegrees(float radians) {
        return radians * 180.0f / (float)Math.PI;
    }

    public static float getRadians(float degrees) {
        return degrees * (float)Math.PI / 180.0f;
    }

    public static float arcTan(double y, double x) {
        return ForgeMath.getDegrees((float)Math.atan2(y, x));
    }

    public static float roundTo(float value, int powerOf10) {
        double pow = Math.pow(10.0, -powerOf10);
        double mult = (double)value * pow;
        int round = Math.round((float)mult);
        return (float)((double)round / pow);
    }
}

